/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui.dialogs.wizardpages;

import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.gui.dialogs.Messages;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.memento.IArcwayMemento;
import java.io.File;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileSelectionPage
extends WizardPage {
    private static final String pageID = "com.arcway.cockpit.modulelib2.client.gui.adapter.FileSelectionPage";
    private final List<String> allowedFileExtensions;
    private final boolean isForLoading;
    private final boolean fileExistsWarning;
    private final boolean fileDoesNotExistError;
    private Text fileNameWidget;
    private Button browseButton;
    private String fileNameFromSettingsStore;
    private static final String SETTING_KEY_FILENAME = "fileName";

    public FileSelectionPage(String pageTitle, String pageInstruction, List<String> allowedFileExtensions_, boolean isForLoading, boolean fileExistsWarning, boolean fileDoesNotExistError) {
        this(pageTitle, pageInstruction, allowedFileExtensions_, isForLoading, fileExistsWarning, fileDoesNotExistError, pageID);
    }

    public FileSelectionPage(String pageTitle, String pageInstruction, List<String> allowedFileExtensions_, boolean isForLoading, boolean fileExistsWarning, boolean fileDoesNotExistError, String pageID_) {
        super(pageID_ != null ? pageID_ : pageID, pageTitle, null);
        this.allowedFileExtensions = allowedFileExtensions_;
        this.isForLoading = isForLoading;
        this.fileExistsWarning = fileExistsWarning;
        this.fileDoesNotExistError = fileDoesNotExistError;
        this.setDescription(pageInstruction);
        this.setPageComplete(false);
    }

    public String getKey() {
        return this.getName();
    }

    public void createControl(Composite parent) {
        Composite baseComposite = new Composite(parent, 0);
        GridLayout baseLayout = new GridLayout();
        baseLayout.verticalSpacing = 30;
        baseLayout.marginHeight = 15;
        baseComposite.setLayout((Layout)baseLayout);
        Composite fileSelectionComposite = new Composite(baseComposite, 0);
        fileSelectionComposite.setLayout((Layout)new GridLayout(3, false));
        GridData fileSelectionCompositeLayoutData = new GridData(4, 1, true, false);
        fileSelectionCompositeLayoutData.widthHint = 200;
        fileSelectionComposite.setLayoutData((Object)fileSelectionCompositeLayoutData);
        Label textLabel = new Label(fileSelectionComposite, 0);
        textLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        textLabel.setText(Messages.getString("FileSelectionPage.Label"));
        this.fileNameWidget = new Text(fileSelectionComposite, 2052);
        this.fileNameWidget.setLayoutData((Object)new GridData(4, 2, true, false));
        this.fileNameWidget.setEditable(false);
        this.fileNameWidget.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                block6: {
                    if (FileSelectionPage.this.allowedFileExtensions == null || FileSelectionPage.filenameHasAllowedExtension(FileSelectionPage.this.fileNameWidget.getText(), FileSelectionPage.this.allowedFileExtensions)) {
                        try {
                            File testFile = new File(FileSelectionPage.this.fileNameWidget.getText());
                            boolean fileExists = testFile.exists();
                            if (FileSelectionPage.this.fileExistsWarning && fileExists) {
                                FileSelectionPage.this.setErrorMessage(null);
                                FileSelectionPage.this.setMessage(Messages.getString("FileSelectionPage.FileExistsWarning"), 2);
                                FileSelectionPage.this.setPageComplete(true);
                                break block6;
                            }
                            if (FileSelectionPage.this.fileDoesNotExistError && !fileExists) {
                                FileSelectionPage.this.setErrorMessage(Messages.getString("FileSelectionPage.FileDoesNotExistError"));
                                FileSelectionPage.this.setPageComplete(false);
                                break block6;
                            }
                            FileSelectionPage.this.setErrorMessage(null);
                            FileSelectionPage.this.setPageComplete(true);
                        }
                        catch (Exception exception) {
                            FileSelectionPage.this.setErrorMessage(Messages.getString("FileSelectionPage.InvalidFileError"));
                            FileSelectionPage.this.setPageComplete(false);
                        }
                    } else {
                        FileSelectionPage.this.setErrorMessage(Messages.getString("FileSelectionPage.InvalidFileExtensionError"));
                        FileSelectionPage.this.setPageComplete(false);
                    }
                }
            }
        });
        this.browseButton = new Button(fileSelectionComposite, 0);
        this.browseButton.setLayoutData((Object)new GridData(3, 2, false, false));
        this.browseButton.setText(Messages.getString("FileSelectionPage.BrowseButton.Text"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionPage.this.startFileDialog();
            }
        });
        this.setControl((Control)baseComposite);
        if (this.fileNameFromSettingsStore != null && !ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled")) {
            this.fileNameWidget.setText(this.fileNameFromSettingsStore);
        }
    }

    private void startFileDialog() {
        String fileNameFromDialogue;
        String[] extensionFilter = FileSelectionPage.getExtensionFilterForFileChooserDialogue(this.allowedFileExtensions);
        String previousSelectedPath = this.getFileName().trim();
        File startPath = null;
        if (previousSelectedPath.length() > 0) {
            startPath = new File(previousSelectedPath).getParentFile();
        }
        FileChooserDialog dialog = new FileChooserDialog(extensionFilter, startPath, this.getShell());
        File fileFromDialogue = this.isForLoading ? dialog.openForLoad() : dialog.openForSave();
        String string = fileNameFromDialogue = fileFromDialogue != null ? fileFromDialogue.getAbsolutePath() : null;
        if (fileNameFromDialogue != null && fileNameFromDialogue.length() > 0) {
            if (this.allowedFileExtensions != null && !this.allowedFileExtensions.isEmpty() && !FileSelectionPage.filenameHasAllowedExtension(fileNameFromDialogue, this.allowedFileExtensions)) {
                fileNameFromDialogue = String.valueOf(fileNameFromDialogue) + "." + this.allowedFileExtensions.get(0);
            }
            this.fileNameWidget.setText(fileNameFromDialogue);
        }
    }

    public void setEnabled(boolean enabled) {
        this.fileNameWidget.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public String getFileName() {
        return this.fileNameWidget.getText();
    }

    public Object getParameter() {
        return this.getFileName();
    }

    public void readSettings(IArcwayMemento settingsStore) {
        String fileName = settingsStore.getString(SETTING_KEY_FILENAME);
        if (fileName != null && fileName.trim().length() > 0) {
            this.fileNameFromSettingsStore = fileName;
        }
    }

    public void storeSettings(IArcwayMemento settingsStore) {
        settingsStore.putString(SETTING_KEY_FILENAME, this.getFileName());
    }

    private static boolean filenameHasAllowedExtension(String filename, List<String> extensions) {
        String filenameLowerCase = filename.toLowerCase();
        for (String extension : extensions) {
            if (!filenameLowerCase.endsWith("." + extension.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static String[] getExtensionFilterForFileChooserDialogue(List<String> allowedExtensions) {
        String filterString = "";
        if (allowedExtensions == null) {
            filterString = "*.*";
        } else {
            boolean first = true;
            for (String extension : allowedExtensions) {
                filterString = String.valueOf(filterString) + (!first ? ";" : "") + "*." + extension;
                if (!first) continue;
                first = false;
            }
        }
        return new String[]{filterString};
    }
}

