/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class DecoratedImageDescriptorForGIFs
extends ImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private final ImageData baseImageData;
    private final ImageDescriptor[] overlays = new ImageDescriptor[4];
    private ImageData imageData;

    public DecoratedImageDescriptorForGIFs(ImageDescriptor baseImage) {
        this.baseImageData = baseImage.getImageData();
    }

    public DecoratedImageDescriptorForGIFs(Image baseImage) {
        this.baseImageData = baseImage.getImageData();
    }

    public void addDecorator(ImageDescriptor imageDescriptor, int corner) {
        this.overlays[corner] = imageDescriptor;
    }

    public ImageData getImageData() {
        RGB black = new RGB(0, 0, 0);
        RGB[] rgbs = new RGB[256];
        rgbs[0] = black;
        rgbs[1] = black;
        PaletteData dataPalette = new PaletteData(rgbs);
        this.imageData = new ImageData(this.baseImageData.width, this.baseImageData.height, 8, dataPalette);
        this.imageData.transparentPixel = 0;
        this.drawImage(this.baseImageData, 0, 0);
        this.drawOverlays(this.overlays);
        int i = 0;
        while (i < rgbs.length) {
            if (rgbs[i] == null) {
                rgbs[i] = black;
            }
            ++i;
        }
        return this.imageData;
    }

    private void drawOverlays(ImageDescriptor[] overlays1_) {
        int i = 0;
        while (i < overlays1_.length) {
            ImageDescriptor overlay = overlays1_[i];
            if (overlay != null) {
                ImageData overlayData = overlay.getImageData();
                if (overlayData == null) {
                    overlayData = ImageDescriptor.getMissingImageDescriptor().getImageData();
                }
                switch (i) {
                    case 0: {
                        this.drawImage(overlayData, 0, 0);
                        break;
                    }
                    case 1: {
                        this.drawImage(overlayData, this.baseImageData.width - overlayData.width, 0);
                        break;
                    }
                    case 2: {
                        this.drawImage(overlayData, 0, this.baseImageData.height - overlayData.height);
                        break;
                    }
                    case 3: {
                        this.drawImage(overlayData, this.baseImageData.width - overlayData.width, this.baseImageData.height - overlayData.height);
                    }
                }
            }
            ++i;
        }
    }

    private static int alloc(RGB[] map, int red, int green, int blue) {
        RGB c;
        int i = 1;
        while (i < map.length && (c = map[i]) != null) {
            if (c.red == red && c.green == green && c.blue == blue) {
                return i;
            }
            ++i;
        }
        if (i < map.length - 1) {
            map[i] = new RGB(red, green, blue);
            return i;
        }
        return 0;
    }

    protected final void drawImage(ImageData src, int ox, int oy) {
        RGB[] out = this.imageData.getRGBs();
        PaletteData palette = src.palette;
        if (palette.isDirect) {
            ImageData mask = src.getTransparencyMask();
            int y = 0;
            while (y < src.height) {
                int x = 0;
                while (x < src.width) {
                    if (mask.getPixel(x, y) != 0) {
                        int xx = x + ox;
                        int yy = y + oy;
                        if (xx >= 0 && xx < this.imageData.width && yy >= 0 && yy < this.imageData.height) {
                            int pixel = src.getPixel(x, y);
                            int r = pixel & palette.redMask;
                            r = palette.redShift < 0 ? r >>> -palette.redShift : r << palette.redShift;
                            int g = pixel & palette.greenMask;
                            g = palette.greenShift < 0 ? g >>> -palette.greenShift : g << palette.greenShift;
                            int b = pixel & palette.blueMask;
                            b = palette.blueShift < 0 ? b >>> -palette.blueShift : b << palette.blueShift;
                            pixel = DecoratedImageDescriptorForGIFs.alloc(out, r, g, b);
                            this.imageData.setPixel(xx, yy, pixel);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            return;
        }
        int[] map = new int[256];
        int i = 0;
        while (i < map.length) {
            map[i] = -1;
            ++i;
        }
        if (src.getTransparencyType() == 2) {
            ImageData mask = src.getTransparencyMask();
            int y = 0;
            while (y < src.height) {
                int x = 0;
                while (x < src.width) {
                    if (mask.getPixel(x, y) != 0) {
                        int xx = x + ox;
                        int yy = y + oy;
                        if (xx >= 0 && xx < this.imageData.width && yy >= 0 && yy < this.imageData.height) {
                            int pixel = src.getPixel(x, y);
                            int newPixel = map[pixel];
                            if (newPixel < 0) {
                                RGB c = palette.getRGB(pixel);
                                map[pixel] = newPixel = DecoratedImageDescriptorForGIFs.alloc(out, c.red, c.green, c.blue);
                            }
                            this.imageData.setPixel(xx, yy, newPixel);
                        }
                    }
                    ++x;
                }
                ++y;
            }
            return;
        }
        int maskPixel = src.transparentPixel;
        int y = 0;
        while (y < src.height) {
            int x = 0;
            while (x < src.width) {
                int pixel = src.getPixel(x, y);
                if (maskPixel < 0 || pixel != maskPixel) {
                    int xx = x + ox;
                    int yy = y + oy;
                    if (xx >= 0 && xx < this.imageData.width && yy >= 0 && yy < this.imageData.height) {
                        int newPixel = map[pixel];
                        if (newPixel < 0) {
                            RGB c = palette.getRGB(pixel);
                            map[pixel] = newPixel = DecoratedImageDescriptorForGIFs.alloc(out, c.red, c.green, c.blue);
                        }
                        this.imageData.setPixel(xx, yy, newPixel);
                    }
                }
                ++x;
            }
            ++y;
        }
    }
}

