/*
 * Decompiled with CFR 0.152.
 */
package au.com.swz.swttocom.swt.types.pointer;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.pointer.AbstractPointer;
import au.com.swz.swttocom.swt.types.pointer.IPointer;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.win32.OS;

public class StringPointer
extends AbstractPointer
implements IPointer {
    private String stringData;

    public StringPointer(String initString, ResourceManager resourceManager) {
        this(0, resourceManager);
        this.stringData = initString;
    }

    public StringPointer(ResourceManager resourceManager) {
        this(0, resourceManager);
    }

    public StringPointer(int address, ResourceManager resourceManager) {
        super(resourceManager);
        this.resourcePackage.setPointerAddress(address);
    }

    public String getValue() {
        if (this.resourcePackage.getPointerAddress() > 0) {
            this.copyValueFromMemory(false);
        }
        return this.stringData;
    }

    public void setValue(String stringData) {
        this.stringData = stringData;
        if (this.resourcePackage.getPointerAddress() > 0) {
            this.copyValueToMemory();
        }
    }

    @Override
    public int getAddress() {
        if (this.resourcePackage.getPointerAddress() == 0) {
            this.resourcePackage.setPointerAddress(OS.GlobalAlloc((int)64, (int)4));
            this.copyValueToMemory();
        }
        return this.resourcePackage.getPointerAddress();
    }

    @Override
    public void setAddress(int address) {
        this.resourcePackage.setPointerAddress(address);
    }

    @Override
    public void dispose() {
        if (this.resourcePackage.getPointerAddress() > 0) {
            this.copyValueFromMemory(true);
            this.resourcePackage.dispose();
        }
    }

    private void copyValueFromMemory(boolean freeMem) {
        if (this.resourcePackage.getPointerAddress() > 0) {
            int[] hMem = new int[1];
            OS.MoveMemory((int[])hMem, (int)this.resourcePackage.getPointerAddress(), (int)4);
            if (hMem[0] != 0) {
                int size = COM.SysStringByteLen((int)hMem[0]);
                if (size > 0) {
                    char[] buffer = new char[(size + 1) / 2];
                    COM.MoveMemory((char[])buffer, (int)hMem[0], (int)size);
                    this.stringData = new String(buffer);
                } else {
                    this.stringData = "";
                }
                if (freeMem) {
                    COM.SysFreeString((int)hMem[0]);
                }
            }
        }
    }

    private void copyValueToMemory() {
        if (this.stringData == null) {
            this.stringData = "";
        }
        int[] hMem = new int[1];
        OS.MoveMemory((int[])hMem, (int)this.resourcePackage.getPointerAddress(), (int)4);
        if (hMem[0] != 0) {
            COM.SysFreeString((int)hMem[0]);
        }
        char[] data = (String.valueOf(this.stringData) + "\u0000").toCharArray();
        int pbstrVal = COM.SysAllocString((char[])data);
        COM.MoveMemory((int)this.resourcePackage.getPointerAddress(), (int[])new int[]{pbstrVal}, (int)4);
    }
}

