/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.gef.draw2d.printing;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrintOperation;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.widgets.Display;

public class PrintFigureOperation
extends PrintOperation {
    private static ILogger logger = Logger.getLogger(PrintFigureOperation.class);
    public static final int TILE = 1;
    public static final int FIT_PAGE = 2;
    public static final int FIT_WIDTH = 3;
    public static final int FIT_HEIGHT = 4;
    private IFigure printSource;
    private Color oldBGColor;
    private int printMode = 1;

    protected PrintFigureOperation(Printer p) {
        super(p);
    }

    public PrintFigureOperation(Printer p, IFigure srcFigure) {
        super(p);
        this.setPrintSource(srcFigure);
    }

    protected int getPrintMode() {
        return this.printMode;
    }

    protected IFigure getPrintSource() {
        return this.printSource;
    }

    protected void preparePrintSource() {
        this.oldBGColor = this.getPrintSource().getLocalBackgroundColor();
        this.getPrintSource().setBackgroundColor(ColorConstants.white);
    }

    /*
     * Unable to fully structure code
     */
    protected void printPages() {
        draw2DProblemOccurred = false;
        graphics = this.getFreshPrinterGraphics();
        clipRect = new Rectangle();
        graphics.getClip(clipRect);
        if (clipRect.height == 1 && clipRect.width == 1) {
            printRegion = this.getPrintRegion();
            graphics.setClip(printRegion);
        }
        figure = this.getPrintSource();
        this.setupPrinterGraphicsFor((Graphics)graphics, figure);
        bounds = figure.getBounds();
        x = bounds.x;
        y = bounds.y;
        clipRect = new Rectangle();
        ** GOTO lbl38
        {
            block4: {
                graphics.pushState();
                this.getPrinter().startPage();
                graphics.translate(-x, -y);
                graphics.getClip(clipRect);
                clipRect.setLocation(x, y);
                graphics.clipRect(clipRect);
                figure.paint((Graphics)graphics);
                this.getPrinter().endPage();
                graphics.popState();
                if (this.getPrintMode() != 2 && this.getPrintMode() != 3 || (x += clipRect.width) >= bounds.x + bounds.width) break block4;
                draw2DProblemOccurred = true;
                ** GOTO lbl34
            }
            do {
                if (x < bounds.x + bounds.width) continue block0;
lbl34:
                // 2 sources

                x = bounds.x;
                if (this.getPrintMode() != 2 && this.getPrintMode() != 4 || (y += clipRect.height) >= bounds.y + bounds.height) continue;
                draw2DProblemOccurred = true;
                break block0;
lbl38:
                // 2 sources

            } while (y < bounds.y + bounds.height);
        }
        if (draw2DProblemOccurred) {
            PrintFigureOperation.logger.info("Draw2D printing support defective on this system (at least partially).");
        }
    }

    protected void restorePrintSource() {
        this.getPrintSource().setBackgroundColor(this.oldBGColor);
        this.oldBGColor = null;
    }

    public void setPrintMode(int mode) {
        this.printMode = mode;
    }

    protected void setPrintSource(IFigure printSource) {
        this.printSource = printSource;
    }

    protected void setupPrinterGraphicsFor(Graphics graphics, IFigure figure) {
        double dpiScale = (double)this.getPrinter().getDPI().x / (double)Display.getCurrent().getDPI().x;
        Rectangle printRegion = this.getPrintRegion();
        printRegion.width = (int)((double)printRegion.width / dpiScale);
        printRegion.height = (int)((double)printRegion.height / dpiScale);
        Rectangle bounds = figure.getBounds();
        double xScale = (double)printRegion.width / (double)bounds.width;
        double yScale = (double)printRegion.height / (double)bounds.height;
        switch (this.getPrintMode()) {
            case 2: {
                graphics.scale(Math.min(xScale, yScale) * dpiScale);
                break;
            }
            case 3: {
                graphics.scale(xScale * dpiScale);
                break;
            }
            case 4: {
                graphics.scale(yScale * dpiScale);
                break;
            }
            default: {
                graphics.scale(dpiScale);
            }
        }
        graphics.setForegroundColor(figure.getForegroundColor());
        graphics.setBackgroundColor(figure.getBackgroundColor());
        graphics.setFont(figure.getFont());
    }
}

