/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.adapter.excel.exports;

import java.util.LinkedList;
import java.util.List;

public class SheetDescription {
    private final String sheetName;
    private final String[] columnHeadings;
    private final int[] columnFormatDefinitions;
    private final int numberOfColumns;
    private final List<String[]> lineEntries;

    public SheetDescription(String sheetName, String[] columnHeadings, int[] columnFormatDefinitions) {
        assert (columnHeadings.length == columnFormatDefinitions.length) : "Different lengths of headings list and multiline definitions list";
        this.sheetName = sheetName;
        this.columnHeadings = columnHeadings;
        this.columnFormatDefinitions = columnFormatDefinitions;
        this.numberOfColumns = columnHeadings.length;
        this.lineEntries = new LinkedList<String[]>();
    }

    public void addLineEntry(String[] values) {
        assert (values.length == this.numberOfColumns) : "Invalid line entry: number of values does not match number of columns";
        this.lineEntries.add(values);
    }

    String getSheetName() {
        return this.sheetName;
    }

    String[] getColumnHeadings() {
        return this.columnHeadings;
    }

    int[] getColumnFormatDefinitions() {
        return this.columnFormatDefinitions;
    }

    List<String[]> getAllLineEntries() {
        return this.lineEntries;
    }
}

