/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.eclipse.adapter.excel.exports;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AutomationObjectImpl;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDouble;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationSingle;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeInteger;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.lib.eclipse.adapter.excel.ExcelUtils;
import com.arcway.lib.eclipse.adapter.excel.Messages;
import com.arcway.lib.eclipse.adapter.excel.exports.SheetDescription;
import com.arcway.lib.eclipse.ole.excel.Application;
import com.arcway.lib.eclipse.ole.excel.Border;
import com.arcway.lib.eclipse.ole.excel.Borders;
import com.arcway.lib.eclipse.ole.excel.Interior;
import com.arcway.lib.eclipse.ole.excel.Range;
import com.arcway.lib.eclipse.ole.excel.Sheets;
import com.arcway.lib.eclipse.ole.excel.Workbook;
import com.arcway.lib.eclipse.ole.excel.Workbooks;
import com.arcway.lib.eclipse.ole.excel.Worksheet;
import com.arcway.lib.eclipse.ole.excel._Application;
import com.arcway.lib.eclipse.ole.excel.util.TypeLibPatches;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.swt.SWTException;

public class GenericExcelListExporter {
    private static final ILogger logger = Logger.getLogger(GenericExcelListExporter.class);
    private static final int MAX_SHEETNAME_LENGTH = 31;
    private static final int xlEdgeLeft = 7;
    private static final int xlEdgeTop = 8;
    private static final int xlEdgeBottom = 9;
    private static final int xlEdgeRight = 10;
    private static final int xlDiagonalDown = 5;
    private static final int xlDiagonalUp = 6;
    private static final int xlContinuous = 1;
    private static final int xlThin = 2;
    private final String applicationName;
    private String exportFileName;
    private _Application excelApplication;
    private ResourceManager resourceManager;
    private Workbook excelWorkbook;
    private boolean hadWorkbooksOpenWhenStarting;

    public GenericExcelListExporter(String applicationName) {
        this.applicationName = applicationName;
    }

    public Throwable startExport(String fileName) {
        this.exportFileName = fileName;
        try {
            this.resourceManager = new ResourceManager();
            logger.trace(String.valueOf(this.applicationName) + ": ExcelExporter: Create new Excel-Application");
            try {
                this.excelApplication = Application.create((int)6, (ResourceManager)this.resourceManager, (boolean)true);
            }
            catch (SWTException aNEE) {
                logger.error(com.arcway.lib.eclipse.ole.excel.util.Messages.getString((String)"ExcelFacade.ExcelNotInstalled_Message"), (Throwable)aNEE);
                return new Exception(com.arcway.lib.eclipse.ole.excel.util.Messages.getString((String)"ExcelFacade.ExcelNotInstalled_Message"), aNEE);
            }
            Workbooks books = this.excelApplication.get_Workbooks();
            int workbookCount = books.get_Count();
            int index = 0;
            while (index < workbookCount) {
                Workbook book = books.get_Item((Object)(index + 1));
                String bookFilename = book.get_FullName();
                if (bookFilename.substring(bookFilename.lastIndexOf(92) + 1).equals(this.exportFileName.substring(this.exportFileName.lastIndexOf(92) + 1))) {
                    book.Close();
                }
                book.dispose();
                ++index;
            }
            this.hadWorkbooksOpenWhenStarting = workbookCount > 0;
            File exportFile = new File(fileName);
            if (exportFile.exists()) {
                FileHelper.deleteExistingFileOrDirectory((File)exportFile);
            }
            this.excelWorkbook = books.Add();
        }
        catch (Exception e) {
            logger.error(String.valueOf(this.applicationName) + ": ExcelExporter: Exception occured: ", (Throwable)e);
            this.resourceManager.shutdown();
            return new Exception(e);
        }
        return null;
    }

    public Throwable export(List<SheetDescription> sheetDescriptions, IProgressDisplay monitor) {
        monitor.beginQuantifiedTask(Messages.getString("ExcelExporter.ProgressBar.TaskName"), sheetDescriptions.size() + 1, true);
        int parentItemsDoneCount = 0;
        SetMap<String, SheetDescription> map_sheetName_sheets = GenericExcelListExporter.generateSheetNames(sheetDescriptions);
        for (String sheetName : map_sheetName_sheets.keySet()) {
            Set sheets = map_sheetName_sheets.get((Object)sheetName);
            boolean indexNecessary = sheets.size() > 1;
            int index = 1;
            for (SheetDescription sheetDescription : sheets) {
                String effectiveSheetName = indexNecessary ? String.valueOf(sheetName) + "#" + index : sheetName;
                monitor.reportQuantifiedProgress(++parentItemsDoneCount, String.valueOf(Messages.getString("ExcelExporter.ProgressBar.WorkItemName.ExportSheet")) + sheetName);
                List<String[]> lineEntries = sheetDescription.getAllLineEntries();
                Throwable result = this.exportToWorksheet(effectiveSheetName, sheetDescription.getColumnHeadings(), sheetDescription.getColumnFormatDefinitions(), lineEntries);
                if (result != null) {
                    return result;
                }
                if (!indexNecessary) continue;
                ++index;
            }
        }
        monitor.endTask();
        return null;
    }

    public Throwable closeExport(IProgressDisplay monitor) {
        Exception exception = null;
        monitor.beginUnquantifiedTask(Messages.getString("ExcelExporter.ProgressBar.WorkItemName.ClosingFile"), false);
        try {
            try {
                try {
                    TypeLibPatches.Workbook_SaveAs((Workbook)this.excelWorkbook, (String)this.exportFileName);
                }
                catch (Exception e) {
                    logger.error(String.valueOf(this.applicationName) + ": Exporter.closeExport() - Exception occured during Save", (Throwable)e);
                    exception = new Exception(new Exception("Excel file was not saved.", e));
                }
                this.excelWorkbook.Close();
                if (!this.hadWorkbooksOpenWhenStarting) {
                    this.excelApplication.Quit();
                }
                this.excelWorkbook.dispose();
                this.excelApplication.dispose();
            }
            catch (Exception e) {
                logger.error(String.valueOf(this.applicationName) + ": Exporter.closeExport() - Exception occured during Close or Quit", (Throwable)e);
                exception = new Exception(e);
                this.resourceManager.shutdown();
                monitor.endTask();
            }
        }
        finally {
            this.resourceManager.shutdown();
            monitor.endTask();
        }
        return exception;
    }

    private static SetMap<String, SheetDescription> generateSheetNames(List<SheetDescription> allSheets) {
        SetMap map_sheetName_sheets = new SetMap();
        for (SheetDescription element : allSheets) {
            String parentLabel = element.getSheetName();
            if (parentLabel.length() > 31) {
                parentLabel = parentLabel.substring(0, 31);
            }
            map_sheetName_sheets.add((Object)parentLabel, (Object)element);
        }
        GenericExcelListExporter.checkNumberOfPossibleSuffices((SetMap<String, SheetDescription>)map_sheetName_sheets);
        return map_sheetName_sheets;
    }

    private static void checkNumberOfPossibleSuffices(SetMap<String, SheetDescription> map_sheetName_sheets) {
        boolean mayHaveSheetnamesWithInsufficientNrOfSuffices = true;
        while (mayHaveSheetnamesWithInsufficientNrOfSuffices) {
            mayHaveSheetnamesWithInsufficientNrOfSuffices = false;
            SetMap newMappings = new SetMap();
            Iterator sheetNameIterator = map_sheetName_sheets.keySet().iterator();
            while (sheetNameIterator.hasNext()) {
                String sheetName = (String)sheetNameIterator.next();
                Set sheets = map_sheetName_sheets.get((Object)sheetName);
                if (sheets.size() <= 1) continue;
                int possibleSuffixDigits = 31 - sheetName.length() - 1;
                int lettersToRemove = 0;
                while (Math.pow(10.0, possibleSuffixDigits + lettersToRemove) - 1.0 < (double)sheets.size()) {
                    ++lettersToRemove;
                }
                if (lettersToRemove <= 0) continue;
                String newSheetName = sheetName.substring(0, sheetName.length() - lettersToRemove);
                newMappings.addAll((Object)newSheetName, (Collection)sheets);
                sheetNameIterator.remove();
                mayHaveSheetnamesWithInsufficientNrOfSuffices = true;
            }
            map_sheetName_sheets.addAll(newMappings);
        }
    }

    private Throwable exportToWorksheet(String name, String[] columnHeadings, int[] columnFormatSpecifications, List<String[]> lineEntries) {
        try {
            Worksheet sheet = GenericExcelListExporter.makeWorksheet(this.excelWorkbook, name);
            GenericExcelListExporter.formatDataCells(sheet, columnHeadings.length, columnFormatSpecifications);
            GenericExcelListExporter.formatColumnHeaders(sheet, columnHeadings.length);
            int columnIndex = 0;
            while (columnIndex < columnHeadings.length) {
                GenericExcelListExporter.writeColumnHeader(sheet, columnIndex, columnHeadings[columnIndex], columnFormatSpecifications[columnIndex]);
                ++columnIndex;
            }
            int rowNumber = 2;
            for (String[] values : lineEntries) {
                GenericExcelListExporter.writeDataCell(sheet, rowNumber, values, columnFormatSpecifications);
                ++rowNumber;
            }
            sheet.get_Rows().AutoFit();
            sheet.get_Columns().AutoFit();
            sheet.dispose();
        }
        catch (Exception e) {
            logger.error(String.valueOf(this.applicationName) + ": ExcelExporter: Exception occured", (Throwable)e);
            this.resourceManager.shutdown();
            return new Exception(e);
        }
        return null;
    }

    private static Worksheet makeWorksheet(Workbook workbook, String name) {
        Worksheet activeSheet = new Worksheet(((AutomationObjectImpl)workbook.get_ActiveSheet()).getOleAutomation(), workbook.getResourceManager());
        Sheets sheets = workbook.get_Worksheets();
        Worksheet newSheet = new Worksheet(((AutomationObjectImpl)sheets.Add((Object)activeSheet)).getOleAutomation(), workbook.getResourceManager());
        String effectiveName = name.replaceAll("/|\\\\|\\?|\\*|:|\\[|\\]", " ");
        newSheet.set_Name(effectiveName);
        activeSheet.dispose();
        sheets.dispose();
        return newSheet;
    }

    private static void writeDataCell(Worksheet sheet, int rowNumber, String[] values, int[] columnFormatSpecifications) {
        int columnIndex = 0;
        while (columnIndex < values.length) {
            if (values[columnIndex] != null && values[columnIndex].trim().length() > 0) {
                String columnIndexString = ExcelUtils.getColumnIndex(columnIndex);
                Range cell = sheet.get_Range((Object)(String.valueOf(columnIndexString) + rowNumber));
                String value = values[columnIndex];
                if (columnFormatSpecifications[columnIndex] == 1 || columnFormatSpecifications[columnIndex] == 0) {
                    value = "'" + value;
                }
                cell.set_Value((Object)value);
                cell.dispose();
            }
            ++columnIndex;
        }
    }

    private static void formatDataCells(Worksheet sheet, int columnCount, int[] formatSpecifications) {
        String columnIndexStringFirstColumn = ExcelUtils.getColumnIndex(0);
        String columnIndexStringLastColumn = ExcelUtils.getColumnIndex(columnCount - 1);
        Range everything = sheet.get_Range((Object)(String.valueOf(columnIndexStringFirstColumn) + ":" + columnIndexStringLastColumn));
        everything.set_VerticalAlignment((Object)-4160);
        everything.dispose();
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            String columnIndexString = ExcelUtils.getColumnIndex(columnIndex);
            Range column = sheet.get_Range((Object)(String.valueOf(columnIndexString) + ":" + columnIndexString));
            if (formatSpecifications[columnIndex] == 1 || formatSpecifications[columnIndex] == 0) {
                column.set_NumberFormat((Object)"");
                if (formatSpecifications[columnIndex] == 1) {
                    column.set_WrapText((Object)Boolean.TRUE);
                }
            } else if (formatSpecifications[columnIndex] == 2) {
                column.set_NumberFormat((Object)"0");
            } else if (formatSpecifications[columnIndex] == 3) {
                column.set_NumberFormat((Object)"@");
                column.set_HorizontalAlignment((Object)-4152);
            } else if (formatSpecifications[columnIndex] == 4) {
                column.set_NumberFormat((Object)"@");
                column.set_HorizontalAlignment((Object)-4152);
            } else if (formatSpecifications[columnIndex] == 5) {
                column.set_NumberFormat((Object)"@");
                column.set_HorizontalAlignment((Object)-4152);
            }
            column.dispose();
            ++columnIndex;
        }
    }

    private static void writeColumnHeader(Worksheet sheet, int columnNumber, String label, int columnFormatSpecification) {
        String columnIndexString = ExcelUtils.getColumnIndex(columnNumber);
        Range cell = sheet.get_Range((Object)(String.valueOf(columnIndexString) + "1"));
        cell.set_Value((Object)label);
        if (columnFormatSpecification == 1) {
            cell.set_ColumnWidth((Object)40);
        }
        cell.dispose();
    }

    private static void formatColumnHeaders(Worksheet sheet, int columnCount) {
        String columnIndexStringFirstColumn = ExcelUtils.getColumnIndex(0);
        String columnIndexStringLastColumn = ExcelUtils.getColumnIndex(columnCount - 1);
        Range columnHeaders = sheet.get_Range((Object)(String.valueOf(columnIndexStringFirstColumn) + "1:" + columnIndexStringLastColumn + "1"));
        columnHeaders.set_NumberFormat((Object)"@");
        columnHeaders.set_HorizontalAlignment((Object)-4131);
        columnHeaders.get_Font().set_Bold((Object)Boolean.TRUE);
        Interior interior = columnHeaders.get_Interior();
        interior.set_ColorIndex((Object)37);
        interior.set_Pattern((Object)1);
        Borders borders = columnHeaders.get_Borders();
        borders.get_Item(5).set_LineStyle((Object)-4142);
        borders.get_Item(6).set_LineStyle((Object)-4142);
        borders.get_Item(7).set_LineStyle((Object)-4142);
        borders.get_Item(10).set_LineStyle((Object)-4142);
        borders.get_Item(8).set_LineStyle((Object)-4142);
        Border bottomBorder = borders.get_Item(9);
        bottomBorder.set_LineStyle((Object)1);
        bottomBorder.set_Weight((Object)2);
        bottomBorder.set_ColorIndex((Object)-4105);
        bottomBorder.dispose();
        borders.dispose();
        columnHeaders.dispose();
    }

    public static void determineColumnFormatSpecificationsForCustomProperties(List<? extends IAttributeType> customProperties, int[] columnFormatSpecifications, int beginIndex) {
        int counter = beginIndex;
        for (IAttributeType iAttributeType : customProperties) {
            IAttributeTypeDataType dataType = iAttributeType.getDataType();
            columnFormatSpecifications[counter] = dataType instanceof DataTypeText || dataType instanceof DataTypeEnumerationMultiple ? 1 : (dataType instanceof DataTypeDate ? 4 : (dataType instanceof DataTypeDouble ? 3 : (dataType instanceof DataTypeInteger || dataType instanceof DataTypeEnumerationSingle && ((DataTypeEnumerationSingle)dataType).getBaseDataType() instanceof DataTypeInteger ? 2 : 0)));
            ++counter;
        }
    }

    public static void determineColumnContentsForCustomProperties(List<? extends IAttributeType> customProperties, List<String> columnContents, IAttributeOwner attributeOwner, Locale locale) {
        for (IAttributeType iAttributeType : customProperties) {
            IAttribute attribute;
            String label = "";
            if (ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem((IAttributeOwner)attributeOwner, (IAttributeType)iAttributeType) && (attribute = attributeOwner.getAttribute(iAttributeType.getAttributeTypeID())) != null) {
                IAttributeTypeDataType dataType = iAttributeType.getDataType();
                IValueRange valueRange = iAttributeType.getValueRange();
                List labelList = dataType.getValueAsStrings(attribute.getAttributeValue(), valueRange, locale);
                label = "";
                Iterator labelListIterator = labelList.iterator();
                while (labelListIterator.hasNext()) {
                    String labelPart = (String)labelListIterator.next();
                    label = String.valueOf(label) + labelPart + (labelListIterator.hasNext() ? "\n" : "");
                }
            }
            columnContents.add(label);
        }
    }
}

