/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.ppm1.ppm1migrator.messages;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLE_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkUE_V0;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public final class EODataContainer
extends EOEncodableObject {
    public static String XML_NAME = "pmm.datacontainer";
    private static final String ROLE_TASKS = "tasks";
    private static final String ROLE_PM_PROJECTS = "pmProjects";
    private static final String ROLE_SOURCE_INFORMATION = "sourceInformation";
    private static final String ROLE_WORK_ITEMS = "workItems";
    public static final String ATTR_TAG_PROJECT_UID = "projectUID";
    private String projectUID;
    private final List linksUE = new ArrayList();
    private final List linksLE = new ArrayList();
    private EOList tasks = new EOList("tasks");
    private EOList pmProjects = new EOList("pmProjects");
    private EOList sourceInformation = new EOList("sourceInformation");
    private EOList workItems = new EOList("workItems");

    public EODataContainer() {
        super(XML_NAME);
        this.init();
    }

    public EODataContainer(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.init();
    }

    private void init() {
        this.tasks = new EOList(ROLE_TASKS);
        this.pmProjects = new EOList(ROLE_PM_PROJECTS);
        this.sourceInformation = new EOList(ROLE_SOURCE_INFORMATION);
        this.workItems = new EOList(ROLE_WORK_ITEMS);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUID = value;
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        return this.getLinksUECount() > 0 || this.getLinksLECount() > 0 || this.tasks.size() > 0 || this.pmProjects.size() > 0 || this.sourceInformation.size() > 0 || this.workItems.size() > 0;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        int i = 0;
        while (i < this.getLinksUECount()) {
            this.getLinkUE(i).writeXMLBody(writeContext, depth);
            ++i;
        }
        i = 0;
        while (i < this.getLinksLECount()) {
            this.getLinkLE(i).writeXMLBody(writeContext, depth);
            ++i;
        }
        this.tasks.writeXMLBody(writeContext, depth);
        this.pmProjects.writeXMLBody(writeContext, depth);
        this.sourceInformation.writeXMLBody(writeContext, depth);
        this.workItems.writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (EOLinkUE_V0.XML_NAME.equals(newChild.getTag())) {
            this.addLinkUE((EOLinkUE_V0)newChild);
            return true;
        }
        if (EOLinkLE_V0.XML_NAME.equals(newChild.getTag())) {
            this.addLinkLE((EOLinkLE_V0)newChild);
            return true;
        }
        if ("List".equals(newChild.getTag())) {
            if (ROLE_TASKS.equals(((EOList)newChild).getRole())) {
                this.tasks = (EOList)newChild;
                return true;
            }
            if (ROLE_PM_PROJECTS.equals(((EOList)newChild).getRole())) {
                this.pmProjects = (EOList)newChild;
                return true;
            }
            if (ROLE_SOURCE_INFORMATION.equals(((EOList)newChild).getRole())) {
                this.sourceInformation = (EOList)newChild;
                return true;
            }
            if (ROLE_WORK_ITEMS.equals(((EOList)newChild).getRole())) {
                this.workItems = (EOList)newChild;
                return true;
            }
        }
        return false;
    }

    public int getLinksUECount() {
        return this.linksUE.size();
    }

    public EOLinkUE_V0 getLinkUE(int index) {
        return (EOLinkUE_V0)this.linksUE.get(index);
    }

    public void addLinkUE(EOLinkUE_V0 linkUE) {
        assert (linkUE != null) : "link UE is null";
        this.linksUE.add(linkUE);
    }

    public void removeLinkUE(EOLinkUE_V0 linkUE) {
        this.linksUE.remove(linkUE);
    }

    public void removeLinkUE(int index) {
        this.linksUE.remove(index);
    }

    public Object[] getLinksUEArray() {
        return this.linksUE.toArray();
    }

    public int getLinksLECount() {
        return this.linksLE.size();
    }

    public EOLinkLE_V0 getLinkLE(int index) {
        return (EOLinkLE_V0)this.linksLE.get(index);
    }

    public void addLinkLE(EOLinkLE_V0 linkLE) {
        assert (linkLE != null) : "link LE is null";
        this.linksLE.add(linkLE);
    }

    public void removeLinkLE(EOLinkLE_V0 linkLE) {
        this.linksLE.remove(linkLE);
    }

    public void removeLinkLE(int index) {
        this.linksLE.remove(index);
    }

    public Object[] getLinksLEArray() {
        return this.linksLE.toArray();
    }

    public List getTaskList() {
        return this.tasks;
    }

    public void setTaskList(EOList list) {
        assert (list != null) : "task list is null";
        list.setRole(ROLE_TASKS);
        this.tasks = list;
    }

    public List getPMProjectList() {
        return this.pmProjects;
    }

    public void setPMProjectList(EOList list) {
        assert (list != null) : "pmProject list is null";
        list.setRole(ROLE_PM_PROJECTS);
        this.pmProjects = list;
    }

    public EOList getSourceInformationList() {
        return this.sourceInformation;
    }

    public void setSourceInformationList(EOList list) {
        assert (list != null) : "sourceInformation list is null";
        list.setRole(ROLE_SOURCE_INFORMATION);
        this.sourceInformation = list;
    }

    public EOList getWorkItemList() {
        return this.workItems;
    }

    public void setWorkItemList(EOList list) {
        assert (list != null) : "work item list is null";
        list.setRole(ROLE_WORK_ITEMS);
        this.workItems = list;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void setProjectUID(String projectUID) {
        assert (projectUID != null) : "project UID is null";
        this.projectUID = projectUID;
    }
}

