/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.planimporter.wizard;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanElementTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class AssignUniqueElementsContentLabelProvider
implements ITreeContentProvider,
ILabelProvider {
    private final Map<Object, Image> icons = new HashMap<Object, Image>();
    private final Collection<Plan> plansCollection;

    protected AssignUniqueElementsContentLabelProvider(Plans plans) {
        assert (plans != null);
        this.plansCollection = new ArrayList<Plan>();
        this.plansCollection.addAll(plans.getAllCheckedPlans());
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TypeSprig) {
            TypeSprig sprig = (TypeSprig)parentElement;
            return sprig.getElementSprigs().toArray();
        }
        if (parentElement instanceof CtrlSprig) {
            CtrlSprig sprig = (CtrlSprig)parentElement;
            return sprig.getTypeSprigs().toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof TypeSprig) {
            TypeSprig sprig = (TypeSprig)element;
            return sprig.getType();
        }
        if (element instanceof ElementSprig) {
            ElementSprig sprig = (ElementSprig)element;
            return sprig.getTypeSprig();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TypeSprig) {
            return true;
        }
        return element instanceof CtrlSprig;
    }

    public Object[] getElements(Object inputElement) {
        Set planElements = (Set)inputElement;
        ArrayList<IConstructionElementTypeDescription> planTypes = new ArrayList<IConstructionElementTypeDescription>();
        for (IConstructionElementTypeDescription ct : planElements) {
            if (ct.isOfCategoryNeverUnique()) continue;
            planTypes.add(ct);
        }
        ArrayList<CtrlSprig> result = new ArrayList<CtrlSprig>();
        Iterator<Plan> iterator = this.plansCollection.iterator();
        while (iterator.hasNext()) {
            Plan element;
            Plan plan = element = iterator.next();
            CtrlSprig sprig = new CtrlSprig(plan, planTypes);
            result.add(sprig);
        }
        return result.toArray();
    }

    public void dispose() {
        Iterator<Image> i = this.icons.values().iterator();
        while (i.hasNext()) {
            Image image = i.next();
            image.dispose();
            i.remove();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        Object sprig;
        if (element instanceof TypeSprig) {
            TypeSprig sprig2 = (TypeSprig)element;
            IConstructionElementTypeDescription td = sprig2.getType();
            if (!this.icons.containsKey(td)) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)td.getIconURL());
                this.icons.put(td, imageDescriptor.createImage());
            }
            return this.icons.get(td);
        }
        if (element instanceof CtrlSprig) {
            sprig = (CtrlSprig)element;
            try {
                PlanTypeDescription planType = ((CtrlSprig)sprig).getPlanType();
                if (!this.icons.containsKey(planType)) {
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)planType.getIconURL());
                    this.icons.put(planType, imageDescriptor.createImage());
                }
                return this.icons.get(planType);
            }
            catch (EXPlanTypeUnknown imageDescriptor) {
                // empty catch block
            }
        }
        if (element instanceof ElementSprig) {
            sprig = (ElementSprig)element;
            String planElementType = ((ElementSprig)sprig).getPlanElement().getPlanElementTypeID();
            IConstructionElementTypeDescription cetd = ExtensionMgr.getDefault().getDefaultConstructionElementTypeDescription(planElementType);
            if (!this.icons.containsKey(cetd)) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)cetd.getIconURL());
                this.icons.put(planElementType, imageDescriptor.createImage());
            }
            return this.icons.get(cetd);
        }
        return null;
    }

    public String getText(Object element) {
        String text = "unknown";
        if (element instanceof TypeSprig) {
            TypeSprig sprig = (TypeSprig)element;
            IConstructionElementTypeDescription td = sprig.getType();
            text = td.getConstructionElementTypeNameInPlural(Locale.getDefault());
        } else if (element instanceof CtrlSprig) {
            CtrlSprig sprig = (CtrlSprig)element;
            text = sprig.getPlanName();
        } else if (element instanceof ElementSprig) {
            ElementSprig sprig = (ElementSprig)element;
            text = sprig.getPlanElementName();
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Map<Plan, ArrayList<IPlanAgentPlanElement>> getPlanElementsFromSelection(Collection<?> result) {
        HashMap<Plan, ArrayList<IPlanAgentPlanElement>> selectedElements = new HashMap<Plan, ArrayList<IPlanAgentPlanElement>>();
        for (Object entry : result) {
            Object sprig;
            if (entry instanceof ElementSprig) {
                sprig = (ElementSprig)entry;
                this.addElementSprig((ElementSprig)sprig, selectedElements);
                continue;
            }
            if (entry instanceof TypeSprig) {
                TypeSprig typeSprig = (TypeSprig)entry;
                this.addTypeSprig(typeSprig, selectedElements);
                continue;
            }
            if (!(entry instanceof CtrlSprig)) continue;
            sprig = (CtrlSprig)entry;
            this.addCtrlSprig((CtrlSprig)sprig, selectedElements);
        }
        return selectedElements;
    }

    private void addElementSprig(ElementSprig sprig, Map<Plan, ArrayList<IPlanAgentPlanElement>> selectedElements) {
        Collection planElements;
        if (!selectedElements.containsKey(sprig.getTypeSprig().getCtrl())) {
            selectedElements.put(sprig.getTypeSprig().getCtrl(), new ArrayList());
        }
        if (!(planElements = (Collection)selectedElements.get(sprig.getTypeSprig().getCtrl())).contains(sprig.getPlanElement())) {
            planElements.add(sprig.getPlanElement());
        }
    }

    private void addTypeSprig(TypeSprig sprig, Map<Plan, ArrayList<IPlanAgentPlanElement>> selectedElements) {
        Collection<ElementSprig> elementSprigs = sprig.getElementSprigs();
        for (ElementSprig elementSprig : elementSprigs) {
            this.addElementSprig(elementSprig, selectedElements);
        }
    }

    private void addCtrlSprig(CtrlSprig sprig, Map<Plan, ArrayList<IPlanAgentPlanElement>> selectedElements) {
        Collection<TypeSprig> typeSprigs = sprig.getTypeSprigs();
        for (TypeSprig typeSprig : typeSprigs) {
            this.addTypeSprig(typeSprig, selectedElements);
        }
    }

    private static class CtrlSprig {
        private final Plan ctrl;
        private final Collection<TypeSprig> typeSprigs;

        CtrlSprig(Plan ctrl, Collection<IConstructionElementTypeDescription> types) {
            this.ctrl = ctrl;
            this.typeSprigs = new ArrayList<TypeSprig>();
            for (IConstructionElementTypeDescription type : types) {
                TypeSprig sprig = new TypeSprig(type, ctrl);
                if (sprig.isEmpty()) continue;
                this.typeSprigs.add(sprig);
            }
        }

        Collection<TypeSprig> getTypeSprigs() {
            return this.typeSprigs;
        }

        PlanTypeDescription getPlanType() throws EXPlanTypeUnknown {
            IPMPlanRO loadedPlan = this.ctrl.getLoadedPlan();
            return PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptionForType(loadedPlan.getType());
        }

        String getPlanName() {
            return this.ctrl.getName();
        }
    }

    private static class ElementSprig {
        private final TypeSprig typeSprig;
        private final IPlanAgentPlanElement planElement;

        ElementSprig(TypeSprig typeSprig, IPlanAgentPlanElement planElement) {
            this.typeSprig = typeSprig;
            this.planElement = planElement;
        }

        TypeSprig getTypeSprig() {
            return this.typeSprig;
        }

        String getPlanElementName() {
            return this.planElement.getPlanElementName();
        }

        IPlanAgentPlanElement getPlanElement() {
            return this.planElement;
        }
    }

    private static class TypeSprig {
        private final Plan ctrl;
        private final IConstructionElementTypeDescription type;
        private final Collection<ElementSprig> elements;

        TypeSprig(IConstructionElementTypeDescription type, Plan ctrl) {
            this.ctrl = ctrl;
            this.type = type;
            this.elements = new ArrayList<ElementSprig>();
            for (IPlanAgentPlanElement element : ctrl.getPlanStructure()) {
                IPlanAgentPlanElement pe = element;
                if (this.alreadyContainSameElement(pe.getPlanElementUID()) || pe.getPlanElementName().trim().equals("") || !this.belongsToType(pe)) continue;
                ElementSprig elementSprig = new ElementSprig(this, pe);
                this.elements.add(elementSprig);
            }
        }

        private boolean alreadyContainSameElement(String elementUID) {
            for (ElementSprig eSprig : this.elements) {
                String eSprigElementUID = eSprig.getPlanElement().getPlanElementUID();
                if (!eSprigElementUID.equals(elementUID)) continue;
                return true;
            }
            return false;
        }

        private boolean belongsToType(IPlanAgentPlanElement planElement) {
            Collection possibleTypes;
            try {
                possibleTypes = ExtensionMgr.getDefault().getConstructionElementTypeDescriptionForPlanElementType(planElement.getPlanElementTypeID());
            }
            catch (EXPlanElementTypeUnknown e) {
                return false;
            }
            return possibleTypes.contains(this.type);
        }

        IConstructionElementTypeDescription getType() {
            return this.type;
        }

        Collection<ElementSprig> getElementSprigs() {
            return this.elements;
        }

        boolean isEmpty() {
            return this.elements.isEmpty();
        }

        Plan getCtrl() {
            return this.ctrl;
        }
    }
}

