/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.util;

import de.plans.lib.localisation.ILabelProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocalisedLabelWithKey {
    private final String key;
    private final Map<String, String> localisationMap;

    public LocalisedLabelWithKey(String key) {
        this.key = key;
        this.localisationMap = new HashMap<String, String>();
    }

    public void addLocalisation(String languageCode, String label) {
        this.localisationMap.put(languageCode, label);
    }

    public void extendAllLabels(ILabelProvider pre, ILabelProvider post) {
        for (Map.Entry<String, String> language_label_entry : this.localisationMap.entrySet()) {
            String language = language_label_entry.getKey();
            String label = language_label_entry.getValue();
            Locale locale = new Locale(language != null ? language : "");
            String newlabel = String.valueOf(pre != null ? pre.getLabel(locale) : "") + label + (post != null ? post.getLabel(locale) : "");
            language_label_entry.setValue(newlabel);
        }
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, String> getLocalisationMap() {
        return this.localisationMap;
    }
}

