/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.AbstractLinkManagerAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModulePlanElementLinkTypeDescriptionForPlatformAdapter;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;
import com.arcway.repository.cockpit.interFace.declaration.frame.infolink.CRTIDsInfoLink;
import com.arcway.repository.cockpit.interFace.declaration.frame.modelelement.COTIDsModelElement;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;

public class LinkManagerAdapter_PlanElementLink
extends AbstractLinkManagerAdapter {
    private final IModulePlanElementLinkTypeDescriptionForPlatformAdapter linkTypeDescription;
    private final ILicenseTypeProvider licenseTypeProvider;
    private final IFrameProjectAgent projectAgent;

    public LinkManagerAdapter_PlanElementLink(IFrameProjectAgent projectAgent_, ILinkManagerInterfaceForPlatformAdapter linkManager, AbstractDataMgr dataManager, IModulePlanElementLinkTypeDescriptionForPlatformAdapter linkTypeDescription, ILinkTypeHelper linkTypeHelper, ILicenseTypeProvider licenseTypeProvider, RepositoryIDCreator repositoryIDCreator) {
        super(linkManager, dataManager, linkTypeHelper, repositoryIDCreator);
        this.linkTypeDescription = linkTypeDescription;
        this.licenseTypeProvider = licenseTypeProvider;
        this.projectAgent = projectAgent_;
    }

    public IRepositoryRelationTypeID getRepositorySuperRelationTypeID() {
        return CRTIDsInfoLink.RELATION_TYPE_ID;
    }

    @Override
    protected String getCockpitLinkTypeID() {
        return this.linkTypeDescription.getCockpitLinkTypeID();
    }

    @Override
    protected CardinalityType getLinkableObjectCardinality() {
        return CardinalityType.C0_n_NOT_CONFLICTING;
    }

    @Override
    protected IRepositoryObjectTypeID getLinkableObjectObjectTypeID() {
        switch (this.linkTypeDescription.getType()) {
            case 1: {
                return COTIDsModelElement.OBJECT_TYPE_ID;
            }
        }
        assert (false);
        return null;
    }

    @Override
    protected String getLinkableObjectRoleID() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected IRepositoryRelationContributionRoleID getRelationContributionRoleIDForLinkableObject() {
        return CRTIDsInfoLink.RELATION_CONTRIBUTION_ROLE_ID_MODELELEMENT;
    }

    @Override
    protected CardinalityType getModuleDataCardinality() {
        return this.linkTypeDescription.getModuleDataCardinality();
    }

    @Override
    protected IRepositoryObjectTypeID getModuleDataObjectTypeID() {
        return this.repositoryIDCreator.createObjectTypeIDForRealType(this.linkTypeDescription.getModuleDataDataTypeID());
    }

    @Override
    protected String getModuleDataRoleID() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected IRepositoryRelationContributionRoleID getRelationContributionRoleIDForModuleData() {
        return CRTIDsInfoLink.RELATION_CONTRIBUTION_ROLE_ID_MODULEDATA;
    }

    public ILabel[] getLabels() {
        return new ILabel[0];
    }

    public boolean isCreatableAndDeletableGenerically() {
        return true;
    }

    @Override
    protected ILabel[] getLinkableObjectRoleLabels() {
        return new ILabel[0];
    }

    @Override
    protected ILabel[] getModuleDataRoleLabels() {
        return new ILabel[0];
    }

    @Override
    protected boolean isPropertyOfModuleDataItems() {
        return false;
    }

    public void checkPermissionForCreateOrDeleteLink(IRelationContributionForPermissionCheck[] relationContributions) throws EXCockpitPermissionDenied {
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getInfoLinkLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        IRelationContributionForPermissionCheck[] iRelationContributionForPermissionCheckArray = relationContributions;
        int n = relationContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IRelationContributionForPermissionCheck relationContribution = iRelationContributionForPermissionCheckArray[n2];
            boolean isModuleDataContribution = IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)relationContribution.getRepositoryRelationContributionRoleID(), (Object)this.getRelationContributionRoleIDForModuleData());
            if (isModuleDataContribution) {
                if (relationContribution.getDataTypeIDOfTheDatasAncestor() == null) {
                    IModuleData item = (IModuleData)this.dataManager.getItem(this.linkTypeDescription.getModuleDataDataTypeID(), relationContribution.getCockpitDataUID());
                    if (this.permissionMgr.mayLinkItemToPlanElement(this.linkTypeDescription.getModuleDataDataTypeID(), item)) {
                        return;
                    }
                } else {
                    return;
                }
                throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
            }
            ++n2;
        }
    }
}

