/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.platformadapter;

import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.AbstractLinkManagerAdapter_ModuleDataLinks;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.LabelHelper;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILicenseTypeProvider;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.ILinkManagerInterfaceForPlatformAdapter;
import com.arcway.cockpit.modulelib2.client.platformadapter.interFace.IModuleLinkTypeDescriptionForPlatformAdapter;
import com.arcway.repository.clientadapter.interFace.CardinalityType;
import com.arcway.repository.clientadapter.interFace.EXCockpitPermissionDenied;
import com.arcway.repository.clientadapter.interFace.ILabel;
import com.arcway.repository.clientadapter.interFace.IRelationContributionForPermissionCheck;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;

public class LinkManagerAdapter_ObjectLink
extends AbstractLinkManagerAdapter_ModuleDataLinks {
    public static final String MODULEDATA_ROLE_ID = "moduledata";
    public static final String LINKABLEOBJECT_ROLE_ID = "linkableobject";
    private final IModuleLinkTypeDescriptionForPlatformAdapter linkTypeDescription;
    private final ILicenseTypeProvider licenseTypeProvider;
    private final IFrameProjectAgent projectAgent;

    public LinkManagerAdapter_ObjectLink(IFrameProjectAgent projectAgent_, ILinkManagerInterfaceForPlatformAdapter linkManager, AbstractDataMgr dataManager, IModuleLinkTypeDescriptionForPlatformAdapter linkTypeDescription, ILinkTypeHelper linkTypeHelper, ILicenseTypeProvider licenseTypeProvider, RepositoryIDCreator repositoryIDCreator) {
        super(linkManager, dataManager, linkTypeHelper, repositoryIDCreator);
        this.linkTypeDescription = linkTypeDescription;
        this.licenseTypeProvider = licenseTypeProvider;
        this.projectAgent = projectAgent_;
    }

    @Override
    protected String getCockpitLinkTypeID() {
        return this.linkTypeDescription.getCockpitLinkTypeID();
    }

    @Override
    protected CardinalityType getLinkableObjectCardinality() {
        return this.linkTypeDescription.getLinkableObjectCardinality();
    }

    @Override
    protected String getLinkableObjectDataTypeID() {
        return this.linkTypeDescription.getLinkableObjectDataTypeID();
    }

    @Override
    protected String getLinkableObjectRoleID() {
        return LINKABLEOBJECT_ROLE_ID;
    }

    @Override
    protected CardinalityType getModuleDataCardinality() {
        return this.linkTypeDescription.getModuleDataCardinality();
    }

    @Override
    protected String getModuleDataDataTypeID() {
        return this.linkTypeDescription.getModuleDataDataTypeID();
    }

    @Override
    protected String getModuleDataRoleID() {
        return MODULEDATA_ROLE_ID;
    }

    public ILabel[] getLabels() {
        return LabelHelper.getLabelsForModuleDataLinkType(this.linkTypeDescription);
    }

    public boolean isCreatableAndDeletableGenerically() {
        return this.linkTypeDescription.isCreatableAndDeletableGenerically();
    }

    @Override
    protected ILabel[] getLinkableObjectRoleLabels() {
        return LabelHelper.getLabelsForModuleDataLinkTypeLORole(this.linkTypeDescription);
    }

    @Override
    protected ILabel[] getModuleDataRoleLabels() {
        return LabelHelper.getLabelsForModuleDataLinkTypeMDRole(this.linkTypeDescription);
    }

    @Override
    protected boolean isPropertyOfModuleDataItems() {
        return false;
    }

    public void checkPermissionForCreateOrDeleteLink(IRelationContributionForPermissionCheck[] relationContributions) throws EXCockpitPermissionDenied {
        IClientFunctionLicenseType2 licenseType = this.licenseTypeProvider.getModificationLicenseType();
        if (licenseType != null && !this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed((IClientFunctionLicenseType)licenseType)) {
            throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied.NoLicense")});
        }
        IRelationContributionForPermissionCheck[] iRelationContributionForPermissionCheckArray = relationContributions;
        int n = relationContributions.length;
        int n2 = 0;
        while (n2 < n) {
            IRelationContributionForPermissionCheck relationContribution = iRelationContributionForPermissionCheckArray[n2];
            boolean isModuleDataContribution = IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)relationContribution.getRepositoryRelationContributionRoleID(), (Object)this.getRelationContributionRoleIDForModuleData());
            if (relationContribution.getDataTypeIDOfTheDatasAncestor() == null) {
                int relationContributionIndex;
                IModuleData item = (IModuleData)this.dataManager.getItem(isModuleDataContribution ? this.linkTypeDescription.getModuleDataDataTypeID() : this.linkTypeDescription.getLinkableObjectDataTypeID(), relationContribution.getCockpitDataUID());
                int n3 = relationContributionIndex = isModuleDataContribution ? 0 : 1;
                if (item != null && !this.permissionMgr.mayLinkItem(item, this.linkTypeDescription.getCockpitLinkTypeID(), relationContributionIndex)) {
                    throw new EXCockpitPermissionDenied(new String[]{Messages.getString("EXPermissionDenied")});
                }
            }
            ++n2;
        }
    }
}

