/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.version3.framework;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttribute_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkLog_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainerEncoder;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version3.EOUserDefinedAttributeType_V3;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_;
import com.arcway.cockpit.modulelib2.client.migration.log.DumpLogFileEncoder;
import com.arcway.cockpit.modulelib2.client.migration.log.IDumpLogMigrator;
import com.arcway.cockpit.modulelib2.client.migration.log.version0.DumpLogMigratorHelpers_V0;
import com.arcway.cockpit.modulelib2.client.migration.log.version0.IDumpLogFileProcessor_V0;
import com.arcway.cockpit.modulelib2.client.migration.log.version0.IDumpLogMigrator_V0;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.HistoricDumpViewAccessor_3_;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.HistoryProjectFileViewAccessor_3_;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ICommonModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IGenericItemMigratorTask;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IHistoryViewAccessor_3_;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ILinkScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrationProcessor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrationProcessorConstructor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigratorExtension;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedItemMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedModuleDataScanner;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.VersionedModuleDataID;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.java.collectionmaps.CollectionMap;
import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ModuleDataMigrationProcessor
implements IModuleDataMigrationProcessorConstructor,
IModuleDataMigrationProcessor {
    private static final ILogger LOGGER = Logger.getLogger(ModuleDataMigrationProcessor.class);
    private final IHistoryViewAccessor_3_ historicViewFileProvider;
    private final Locale projectLanguage;
    private final List<IModuleDataScanner> moduleDataScannersForAllData = new ArrayList<IModuleDataScanner>();
    private final List<IVersionedModuleDataScanner> versionedModuleDataScannersForAllData = new ArrayList<IVersionedModuleDataScanner>();
    private final CollectionMap<String, IModuleDataScanner> dataTypeID_2_moduleDataScanners = new ListMap();
    private final CollectionMap<String, ILinkScanner> linkTypeID_2_linkScanners = new ListMap();
    private final CollectionMap<String, IVersionedModuleDataScanner> dataTypeID_2_versionedModuleDataScanners = new ListMap();
    private final List<ICommonModuleDataMigrator> commonModuleDataListeners = new ArrayList<ICommonModuleDataMigrator>();
    private final List<IModuleDataMigrator> moduleDataMigratorsForAllData = new ArrayList<IModuleDataMigrator>();
    private final List<IVersionedItemMigrator> versionedModuleDataMigratorsForAllData = new ArrayList<IVersionedItemMigrator>();
    private final CollectionMap<String, IModuleDataMigrator> dataTypeID_2_moduleDataMigrators = new ListMap();
    private final CollectionMap<String, IVersionedItemMigrator> dataTypeID_2_versionedModuleDataMigrators = new ListMap();
    private EOList<EOModuleDataContainer_V0<EOModuleData_V0>> moduleDataContainers;
    private EOList<EOLink_V0> links;
    private EOList<EOUserDefinedAttributeType_V3> userDefinedAttributeTypes;
    private final Map<String, String> oldDataTypeID_2_newDataTypeID = new HashMap<String, String>();
    private final Map<String, LinkTypeIDChange> oldLinkTypeID_2_linkTypeIDChange = new HashMap<String, LinkTypeIDChange>();
    private final Set<String> dataTypeIDsWithChangedLinkTypes = new HashSet<String>();
    private final CollectionMap<String, EOModuleData_V0> dataTypeID_2_createdModuleData = new ListMap();
    private final Collection<EOLink_V0> createdLinks = new ArrayList<EOLink_V0>();
    private final CollectionMap<String, EOVersionedModuleData_V0> dataTypeID_2_createdVersionedModuleData = new ListMap();
    private final Set<String> dataTypeIDsToDelete = new HashSet<String>();
    private final Set<String> linkTypeIDsToDelete = new HashSet<String>();
    private final Map<String, Map<String, String>> dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID = new HashMap<String, Map<String, String>>();
    private final Set<String> uidsOfDataToDelete = new HashSet<String>();

    public static void setCustomProperty(EOModuleData_V0 item, EOAttributeTypeID_V0 customPropertyTypeID, EOEncodableObject customPropertyValue) {
        EOAttribute_V0 customProperty = new EOAttribute_V0();
        customProperty.setAttributeTypeID(customPropertyTypeID);
        customProperty.setValueAsEO(customPropertyValue);
        ArrayList<EOAttribute_V0> customProperties = new ArrayList<EOAttribute_V0>((Collection<EOAttribute_V0>)item.getCustomAttributes());
        customProperties.add(customProperty);
        item.setCustomAttributes(customProperties);
    }

    public static Map<String, Map<String, String>> migrateProjectDump(HistoricProjectDumpView_3_ historicView, EOProject_V0 currentProject, IEncodableObjectFactory eoFactory, Collection<IModuleDataMigratorExtension> moduleDataMigratorExtensions) throws MigrationFailedException {
        HistoricDumpViewAccessor_3_ historicViewFileProvider = new HistoricDumpViewAccessor_3_(historicView, currentProject, eoFactory);
        return ModuleDataMigrationProcessor.migrateProject(historicViewFileProvider, currentProject, moduleDataMigratorExtensions);
    }

    public static Map<String, Map<String, String>> migrateProjectFile(HistoricProjectFileView_3_ historicView, Collection<IModuleDataMigratorExtension> moduleDataMigratorExtensions) throws MigrationFailedException {
        EOProject_V0 currentProject;
        try {
            currentProject = historicView.getProjectMetaData();
        }
        catch (ProjectFileAccess.ProjectFileAccessException e) {
            throw new MigrationFailedException((Throwable)e);
        }
        HistoryProjectFileViewAccessor_3_ historicViewFileProvider = new HistoryProjectFileViewAccessor_3_(historicView, currentProject);
        return ModuleDataMigrationProcessor.migrateProject(historicViewFileProvider, currentProject, moduleDataMigratorExtensions);
    }

    private static Map<String, Map<String, String>> migrateProject(IHistoryViewAccessor_3_ historicViewFileProvider, EOProject_V0 currentProject, Collection<IModuleDataMigratorExtension> moduleDataMigratorExtensions) throws MigrationFailedException {
        ModuleDataMigrationProcessor migrator = new ModuleDataMigrationProcessor(historicViewFileProvider, currentProject);
        for (IModuleDataMigratorExtension moduleDataMigratorExtension : moduleDataMigratorExtensions) {
            moduleDataMigratorExtension.constructMigrator(migrator);
        }
        migrator.process();
        return migrator.getDataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID();
    }

    private ModuleDataMigrationProcessor(IHistoryViewAccessor_3_ historicViewFileProvider, EOProject_V0 currentProject) {
        this.historicViewFileProvider = historicViewFileProvider;
        this.projectLanguage = new Locale(currentProject.getProjectLanguage());
    }

    private void process() throws MigrationFailedException {
        this.read();
        this.scan();
        this.migrate();
        this.write();
    }

    private void read() throws MigrationFailedException {
        this.moduleDataContainers = this.historicViewFileProvider.readModuleDataContainers();
        this.links = this.historicViewFileProvider.readLinks();
        this.userDefinedAttributeTypes = this.historicViewFileProvider.readUserDefinedAttributeTypes();
    }

    private void scan() throws MigrationFailedException {
        this.scanModuleData();
        this.scanVersionedModuleData();
        this.scanLinks();
    }

    private void migrate() throws MigrationFailedException {
        this.migrateCommon();
        this.migrateModuleData();
        this.migrateVersionedModuleData();
        this.deleteModuleData();
        this.deleteCustomPropertyTypes();
        this.deleteLinks();
        this.addCreatedModuleData();
        this.addCreatedLinks();
        this.changeDataTypeIDsInModuleData();
        this.changeDataTypeIDsInCustomProperyTypes();
        this.changeLinkTypeIDs();
    }

    private void write() {
        this.historicViewFileProvider.writeModuleDataContainers(this.moduleDataContainers);
        this.historicViewFileProvider.writeUserDefinedAttributeTypes(this.userDefinedAttributeTypes);
    }

    private void scanModuleData() throws MigrationFailedException {
        for (EOModuleDataContainer_V0 moduleDataContainer : this.moduleDataContainers) {
            String dataTypeID = moduleDataContainer.getDataTypeUID();
            for (EOModuleData_V0 moduleData : moduleDataContainer.getModuleDataItems()) {
                if (!moduleData.getDataTypeUid().equals(dataTypeID)) {
                    throw new MigrationFailedException("Data of type " + moduleData.getDataTypeUid() + " found in module data container for type " + dataTypeID);
                }
                for (IModuleDataScanner moduleDataScanner : this.moduleDataScannersForAllData) {
                    moduleDataScanner.scanModuleData(moduleData);
                }
                for (IModuleDataScanner moduleDataScanner : this.dataTypeID_2_moduleDataScanners.get((Object)dataTypeID)) {
                    moduleDataScanner.scanModuleData(moduleData);
                }
            }
        }
    }

    private void scanVersionedModuleData() throws MigrationFailedException {
        this.historicViewFileProvider.readLogFile(new IDumpLogFileProcessor_V0(){
            private String dataTypeID;

            public void nextModuleDataContainer(String dataTypeUID) throws EXEncoderException {
                this.dataTypeID = dataTypeUID;
            }

            public void nextItem(EOVersionedModuleData_V0 item) throws EXEncoderException {
                for (IVersionedModuleDataScanner versionedModuleDataScanner : ModuleDataMigrationProcessor.this.versionedModuleDataScannersForAllData) {
                    versionedModuleDataScanner.scanVersionedModuleData(item);
                }
                for (IVersionedModuleDataScanner versionedModuleDataScanner : ModuleDataMigrationProcessor.this.dataTypeID_2_versionedModuleDataScanners.get((Object)this.dataTypeID)) {
                    versionedModuleDataScanner.scanVersionedModuleData(item);
                }
            }

            public void end() {
            }
        });
    }

    private void scanLinks() {
        for (EOLink_V0 link : this.links) {
            String linkTypeID = link.getLinkTypeID();
            for (ILinkScanner linkScanner : this.linkTypeID_2_linkScanners.get((Object)linkTypeID)) {
                linkScanner.scanLink(link.getModuleDataUID(), link.getLinkableObjectUID());
            }
        }
    }

    private void migrateCommon() {
        for (ICommonModuleDataMigrator commonModuleDataMigrator : this.commonModuleDataListeners) {
            commonModuleDataMigrator.migrateModuleData();
        }
    }

    private void migrateModuleData() throws MigrationFailedException {
        for (EOModuleDataContainer_V0 moduleDataContainer : this.moduleDataContainers) {
            String dataTypeID = moduleDataContainer.getDataTypeUID();
            Iterator i = moduleDataContainer.getModuleDataItems().iterator();
            while (i.hasNext()) {
                boolean keepItemCurrent;
                EOModuleData_V0 moduleData = (EOModuleData_V0)i.next();
                if (!moduleData.getDataTypeUid().equals(dataTypeID)) {
                    throw new MigrationFailedException("Data of type " + moduleData.getDataTypeUid() + " found in module data container for type " + dataTypeID);
                }
                boolean keepItem = true;
                for (IModuleDataMigrator moduleDataMigrator : this.moduleDataMigratorsForAllData) {
                    keepItemCurrent = moduleDataMigrator.migrateModuleData(moduleData);
                    keepItem &= keepItemCurrent;
                }
                for (IModuleDataMigrator moduleDataMigrator : this.dataTypeID_2_moduleDataMigrators.get((Object)dataTypeID)) {
                    keepItemCurrent = moduleDataMigrator.migrateModuleData(moduleData);
                    keepItem &= keepItemCurrent;
                }
                if (keepItem) continue;
                this.uidsOfDataToDelete.add(moduleData.getUid());
                LOGGER.debug("Module data deleted due to migration: \n" + this.getStringRepresentationOfEOForLogging((EncodableObjectBase)moduleData));
                i.remove();
            }
        }
    }

    private void migrateVersionedModuleData() throws MigrationFailedException {
        this.historicViewFileProvider.migrateLogFile(new IDumpLogMigrator_V0(){

            public IDumpLogMigrator.IIsInterested isInterestedInContainer(String oldDataTypeID) {
                String newDataTypeID = (String)ModuleDataMigrationProcessor.this.oldDataTypeID_2_newDataTypeID.get(oldDataTypeID);
                if (newDataTypeID == null) {
                    boolean isIntersted = false;
                    isIntersted = isIntersted || !ModuleDataMigrationProcessor.this.uidsOfDataToDelete.isEmpty();
                    isIntersted = isIntersted || ModuleDataMigrationProcessor.this.dataTypeIDsToDelete.contains(oldDataTypeID);
                    isIntersted = isIntersted || !ModuleDataMigrationProcessor.this.versionedModuleDataMigratorsForAllData.isEmpty();
                    isIntersted = isIntersted || !ModuleDataMigrationProcessor.this.dataTypeID_2_versionedModuleDataMigrators.get((Object)oldDataTypeID).isEmpty();
                    isIntersted = isIntersted || ModuleDataMigrationProcessor.this.dataTypeIDsWithChangedLinkTypes.contains(oldDataTypeID);
                    boolean bl = isIntersted = isIntersted || !ModuleDataMigrationProcessor.this.dataTypeID_2_createdVersionedModuleData.get((Object)oldDataTypeID).isEmpty();
                    if (isIntersted) {
                        newDataTypeID = oldDataTypeID;
                    }
                }
                Object iisInterested = newDataTypeID == null ? DumpLogMigratorHelpers_V0.IS_NOT_INTERESTED : new IDumpLogMigrator.IsInterested(newDataTypeID);
                return iisInterested;
            }

            public EOVersionedModuleData_V0 migrateModuleData(EOVersionedModuleData_V0 item) {
                EOVersionedModuleData_V0 migratedItem;
                String dataTypeID = item.getDataTypeUid();
                if (ModuleDataMigrationProcessor.this.dataTypeIDsToDelete.contains(dataTypeID)) {
                    migratedItem = null;
                } else if (ModuleDataMigrationProcessor.this.uidsOfDataToDelete.contains(item.getUid())) {
                    migratedItem = null;
                    LOGGER.debug("Versioned module data deleted due to migration: \n" + ModuleDataMigrationProcessor.this.getStringRepresentationOfEOForLogging((EncodableObjectBase)item));
                } else {
                    boolean keepItemCurrent;
                    boolean keepItem = true;
                    for (IVersionedItemMigrator versionedModuleDataMigrator : ModuleDataMigrationProcessor.this.versionedModuleDataMigratorsForAllData) {
                        keepItemCurrent = versionedModuleDataMigrator.migrateVersionedModuleData(item);
                        keepItem &= keepItemCurrent;
                    }
                    for (IVersionedItemMigrator versionedModuleDataMigrator : ModuleDataMigrationProcessor.this.dataTypeID_2_versionedModuleDataMigrators.get((Object)dataTypeID)) {
                        keepItemCurrent = versionedModuleDataMigrator.migrateVersionedModuleData(item);
                        keepItem &= keepItemCurrent;
                    }
                    if (keepItem) {
                        migratedItem = item;
                        if (ModuleDataMigrationProcessor.this.dataTypeIDsWithChangedLinkTypes.contains(dataTypeID)) {
                            Iterator<Object> i = migratedItem.getInLinks().iterator();
                            while (i.hasNext()) {
                                this.migrateLinkLog(i);
                            }
                            i = migratedItem.getOutLinks().iterator();
                            while (i.hasNext()) {
                                this.migrateLinkLog(i);
                            }
                        }
                    } else {
                        LOGGER.debug("Versioned module data deleted due to migration: \n" + ModuleDataMigrationProcessor.this.getStringRepresentationOfEOForLogging((EncodableObjectBase)item));
                        migratedItem = null;
                    }
                }
                return migratedItem;
            }

            private void migrateLinkLog(Iterator<EOLinkLog_V0> i) {
                EOLinkLog_V0 link = i.next();
                String linkTypeID = link.getLinkTypeID();
                if (ModuleDataMigrationProcessor.this.linkTypeIDsToDelete.contains(linkTypeID) || ModuleDataMigrationProcessor.this.uidsOfDataToDelete.contains(link.getModuleDataUID()) || ModuleDataMigrationProcessor.this.uidsOfDataToDelete.contains(link.getLinkableObjectUID())) {
                    i.remove();
                } else {
                    LinkTypeIDChange linkTypeIDChange = (LinkTypeIDChange)ModuleDataMigrationProcessor.this.oldLinkTypeID_2_linkTypeIDChange.get(linkTypeID);
                    if (linkTypeIDChange != null) {
                        link.setModuleID(linkTypeIDChange.moduleID);
                        link.setLinkTypeID(linkTypeIDChange.linkTypeID);
                    }
                }
            }

            public void addFurtherModuleData(String dataTypeID, EOModuleDataContainerEncoder<EOVersionedModuleData_V0, EOModuleDataContainer_V0<EOVersionedModuleData_V0>> moduleDataEncoder) throws EXEncoderException {
                Collection createdDataCollection = ModuleDataMigrationProcessor.this.dataTypeID_2_createdVersionedModuleData.remove((Object)dataTypeID);
                if (createdDataCollection != null && !createdDataCollection.isEmpty()) {
                    for (EOVersionedModuleData_V0 createdData : createdDataCollection) {
                        moduleDataEncoder.writeItem((EncodableObjectBase)createdData);
                    }
                }
            }

            public void addFurtherModuleDataContainers(DumpLogFileEncoder<EOVersionedModuleData_V0, EOModuleDataContainer_V0<EOVersionedModuleData_V0>> dumpLogFileEncoder) throws EXEncoderException {
                for (String dataTypeID : ModuleDataMigrationProcessor.this.dataTypeID_2_createdVersionedModuleData.keySet()) {
                    Collection createdDataCollection = ModuleDataMigrationProcessor.this.dataTypeID_2_createdVersionedModuleData.get((Object)dataTypeID);
                    if (createdDataCollection.isEmpty()) continue;
                    EOModuleDataContainerEncoder moduleDataEncoder = dumpLogFileEncoder.beginModuleDataContainer(dataTypeID);
                    for (EOVersionedModuleData_V0 createdData : createdDataCollection) {
                        moduleDataEncoder.writeItem((EncodableObjectBase)createdData);
                    }
                    moduleDataEncoder.end();
                }
                ModuleDataMigrationProcessor.this.dataTypeID_2_createdVersionedModuleData.clear();
            }
        });
    }

    private void deleteModuleData() {
        Iterator i = this.moduleDataContainers.iterator();
        while (i.hasNext()) {
            EOModuleDataContainer_V0 moduleDataContainer = (EOModuleDataContainer_V0)i.next();
            String dataTypeID = moduleDataContainer.getDataTypeUID();
            if (!this.dataTypeIDsToDelete.contains(dataTypeID)) continue;
            i.remove();
        }
    }

    private void deleteCustomPropertyTypes() {
        Iterator i = this.userDefinedAttributeTypes.iterator();
        while (i.hasNext()) {
            EOUserDefinedAttributeType_V3 userDefinedAttributeType = (EOUserDefinedAttributeType_V3)i.next();
            String dataTypeID = userDefinedAttributeType.getCockpitDataTypeID();
            if (!this.dataTypeIDsToDelete.contains(dataTypeID)) continue;
            i.remove();
        }
    }

    private void addCreatedModuleData() {
        for (EOModuleDataContainer_V0 moduleDataContainer : this.moduleDataContainers) {
            String dataTypeID = moduleDataContainer.getDataTypeUID();
            Collection createdModuleData = this.dataTypeID_2_createdModuleData.remove((Object)dataTypeID);
            if (createdModuleData == null || createdModuleData.isEmpty()) continue;
            moduleDataContainer.getModuleDataItems().addAll(createdModuleData);
        }
        for (String dataTypeID : this.dataTypeID_2_createdModuleData.keySet()) {
            Collection createdModuleData = this.dataTypeID_2_createdModuleData.get((Object)dataTypeID);
            if (!createdModuleData.isEmpty()) {
                EOList moduleDataList = new EOList(createdModuleData);
                EOModuleDataContainer_V0 moduleDataContainer = new EOModuleDataContainer_V0();
                moduleDataContainer.setDataTypeUID(dataTypeID);
                moduleDataContainer.setModuleDataItems(moduleDataList);
                this.moduleDataContainers.add((EncodableObjectBase)moduleDataContainer);
            }
            this.dataTypeID_2_createdModuleData.remove((Object)dataTypeID);
        }
    }

    private void changeDataTypeIDsInModuleData() throws MigrationFailedException {
        for (EOModuleDataContainer_V0 moduleDataContainer : this.moduleDataContainers) {
            String oldDataTypeID = moduleDataContainer.getDataTypeUID();
            String newDataTypeID = this.oldDataTypeID_2_newDataTypeID.get(oldDataTypeID);
            if (newDataTypeID == null) continue;
            moduleDataContainer.setDataTypeUID(newDataTypeID);
            for (EOModuleData_V0 moduleData : moduleDataContainer.getModuleDataItems()) {
                if (!moduleData.getDataTypeUid().equals(oldDataTypeID)) {
                    throw new MigrationFailedException("Data of type " + moduleData.getDataTypeUid() + " found in module data container for type " + oldDataTypeID);
                }
                moduleData.setDatatypeUID(newDataTypeID);
            }
        }
    }

    private void changeDataTypeIDsInCustomProperyTypes() {
        for (EOUserDefinedAttributeType_V3 userDefinedAttributeType : this.userDefinedAttributeTypes) {
            String oldDataTypeID = userDefinedAttributeType.getCockpitDataTypeID();
            String newDataTypeID = this.oldDataTypeID_2_newDataTypeID.get(oldDataTypeID);
            if (newDataTypeID == null) continue;
            userDefinedAttributeType.setCockpitDataTypeID(newDataTypeID);
        }
    }

    private void deleteLinks() {
        Iterator i = this.links.iterator();
        while (i.hasNext()) {
            EOLink_V0 link = (EOLink_V0)i.next();
            String linkTypeID = link.getLinkTypeID();
            if (!this.linkTypeIDsToDelete.contains(linkTypeID) && !this.uidsOfDataToDelete.contains(link.getModuleDataUID()) && !this.uidsOfDataToDelete.contains(link.getLinkableObjectUID())) continue;
            i.remove();
        }
    }

    private void addCreatedLinks() {
        this.links.addAll(this.createdLinks);
        this.createdLinks.clear();
    }

    private void changeLinkTypeIDs() {
        for (EOLink_V0 link : this.links) {
            String oldLinkTypeID = link.getLinkTypeID();
            LinkTypeIDChange linkTypeIDChange = this.oldLinkTypeID_2_linkTypeIDChange.get(oldLinkTypeID);
            if (linkTypeIDChange == null) continue;
            link.setLinkTypeID(linkTypeIDChange.linkTypeID);
            link.setModuleID(linkTypeIDChange.moduleID);
        }
    }

    public Map<String, Map<String, String>> getDataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID() {
        return this.dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID;
    }

    @Override
    public String getProjectUID() {
        return this.historicViewFileProvider.getProjectUID();
    }

    @Override
    public Locale getProjectLanguage() {
        return this.projectLanguage;
    }

    @Override
    public void addItemScanner(String dataTypeID, IModuleDataScanner itemScanner) {
        if (dataTypeID == null) {
            this.moduleDataScannersForAllData.add(itemScanner);
        } else {
            this.dataTypeID_2_moduleDataScanners.add((Object)dataTypeID, (Object)itemScanner);
        }
    }

    @Override
    public void addLinkScanner(String linkTypeID, ILinkScanner linkScanner) {
        this.linkTypeID_2_linkScanners.add((Object)linkTypeID, (Object)linkScanner);
    }

    @Override
    public void addVersionedItemScanner(String dataTypeID, IVersionedModuleDataScanner itemScanner) {
        if (dataTypeID == null) {
            this.versionedModuleDataScannersForAllData.add(itemScanner);
        } else {
            this.dataTypeID_2_versionedModuleDataScanners.add((Object)dataTypeID, (Object)itemScanner);
        }
    }

    @Override
    public void addCommonMigrator(ICommonModuleDataMigrator scanner) {
        this.commonModuleDataListeners.add(scanner);
    }

    @Override
    public void addItemMigrator(String dataTypeID, IModuleDataMigrator itemMigrator) {
        if (dataTypeID == null) {
            this.moduleDataMigratorsForAllData.add(itemMigrator);
        } else {
            this.dataTypeID_2_moduleDataMigrators.add((Object)dataTypeID, (Object)itemMigrator);
        }
    }

    @Override
    public void addVersionedItemMigrator(String dataTypeID, IVersionedItemMigrator itemMigrator) {
        if (dataTypeID == null) {
            this.versionedModuleDataMigratorsForAllData.add(itemMigrator);
        } else {
            this.dataTypeID_2_versionedModuleDataMigrators.add((Object)dataTypeID, (Object)itemMigrator);
        }
    }

    @Override
    public void changeDataTypeID(String oldDataTypeID, String newDataTypeID) {
        this.oldDataTypeID_2_newDataTypeID.put(oldDataTypeID, newDataTypeID);
    }

    @Override
    public void changeLinkTypeID(String oldLinkTypeID, String moduleID, String newLinkTypeID, String moduleDataTypeID, String linkedObjectDataTypeID) {
        this.oldLinkTypeID_2_linkTypeIDChange.put(oldLinkTypeID, new LinkTypeIDChange(moduleID, newLinkTypeID));
        this.dataTypeIDsWithChangedLinkTypes.add(moduleDataTypeID);
        this.dataTypeIDsWithChangedLinkTypes.add(linkedObjectDataTypeID);
    }

    @Override
    public void addTask(IGenericItemMigratorTask task) {
        task.installMigratorProcessors(this);
    }

    @Override
    public EOModuleData_V0 createData(String dataTypeID) {
        EOModuleData_V0 newData = new EOModuleData_V0();
        this.initializeCreatedData(newData, dataTypeID, UUIDGenerator.getUniqueID(), 1);
        this.dataTypeID_2_createdModuleData.add((Object)dataTypeID, (Object)newData);
        return newData;
    }

    @Override
    public EOVersionedModuleData_V0 createVersionedData(String dataTypeID) {
        EOVersionedModuleData_V0 newData = new EOVersionedModuleData_V0();
        this.initializeCreatedData((EOModuleData_V0)newData, dataTypeID, UUIDGenerator.getUniqueID(), 1);
        this.dataTypeID_2_createdVersionedModuleData.add((Object)dataTypeID, (Object)newData);
        return newData;
    }

    @Override
    public EOVersionedModuleData_V0 createVersionedData(EOModuleData_V0 template, int modCount) {
        EOVersionedModuleData_V0 newData = new EOVersionedModuleData_V0(template);
        newData.setModCount(modCount);
        this.dataTypeID_2_createdVersionedModuleData.add((Object)newData.getDataTypeUid(), (Object)newData);
        return newData;
    }

    private void initializeCreatedData(EOModuleData_V0 newData, String dataTypeID, String uid, int version) {
        long currentTime = System.currentTimeMillis();
        newData.setUid(uid);
        newData.setProjectUID(this.getProjectUID());
        newData.setDatatypeUID(dataTypeID);
        newData.setModCount(version);
        newData.setModTime(currentTime);
        newData.setAttribute("abstractmoduledata_modificationCount", Integer.toString(version));
        newData.setAttribute("abstractmoduledata_modificationDate", Long.toString(currentTime));
        newData.setAttribute("abstractmoduledata_modifier", "ARCWAY");
        newData.setAttribute("abstractmoduledata_creationDate", Long.toString(currentTime));
        newData.setAttribute("abstractmoduledata_creator", "ARCWAY");
    }

    @Override
    public void createLink(String moduleID, String linkTypeID, String moduleDataUID, String linkedObjectUID) {
        EOLink_V0 link = new EOLink_V0(this.getProjectUID(), linkedObjectUID, moduleDataUID, moduleID, linkTypeID);
        this.createdLinks.add(link);
    }

    @Override
    public void createVersionedLink(String moduleID, String linkTypeID, EOVersionedModuleData_V0 moduleData, VersionedModuleDataID linkedObjectID) {
        EOLinkLog_V0 linkLog = new EOLinkLog_V0(this.getProjectUID(), linkedObjectID.getUid(), linkedObjectID.getModCount(), moduleData.getUid(), moduleData.getModCount(), moduleID, linkTypeID);
        moduleData.addOutLink(linkLog);
    }

    @Override
    public void createCustomPropertyType(String dataTypeID, String replacingAttributeTypeID, EOAttributeTypeID_V0 id, String displayName, int position, String attributeTypeDataType, EOEncodableObject eoValueRange) {
        AttributeTypeSortCriterium sortCriteriumTmp = new AttributeTypeSortCriterium(position, IAttributeTypeSortCriterium.CATEGORY_USERDEFINED_ATTRIBUTE);
        AttributeTypeSortCriterium sortCriterium = new AttributeTypeSortCriterium(sortCriteriumTmp.getCategory(), String.valueOf('@') + sortCriteriumTmp.getSortString());
        EOUserDefinedAttributeType_V3 customPropertyType = new EOUserDefinedAttributeType_V3(this.getProjectUID(), id, displayName, sortCriterium.getCategory(), sortCriterium.getSortString(), dataTypeID, attributeTypeDataType, eoValueRange, new Timestamp(System.currentTimeMillis()), 1);
        this.userDefinedAttributeTypes.add((EncodableObjectBase)customPropertyType);
        if (replacingAttributeTypeID != null) {
            Map<String, String> oldAttributeTypeID_2_newCustomPropertyUID = this.dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID.get(dataTypeID);
            if (oldAttributeTypeID_2_newCustomPropertyUID == null) {
                oldAttributeTypeID_2_newCustomPropertyUID = new HashMap<String, String>();
                this.dataTypeID_2_oldAttributeTypeID_2_newCustomPropertyUID.put(dataTypeID, oldAttributeTypeID_2_newCustomPropertyUID);
            }
            oldAttributeTypeID_2_newCustomPropertyUID.put(replacingAttributeTypeID, id.getUID());
        }
    }

    @Override
    public void deleteDataType(String dataTypeID) {
        this.dataTypeIDsToDelete.add(dataTypeID);
    }

    @Override
    public void deleteLinks(String linkTypeID, String moduleDataTypeID, String linkedObjectDataTypeID) {
        this.linkTypeIDsToDelete.add(linkTypeID);
        this.dataTypeIDsWithChangedLinkTypes.add(moduleDataTypeID);
        this.dataTypeIDsWithChangedLinkTypes.add(linkedObjectDataTypeID);
    }

    private String getStringRepresentationOfEOForLogging(EncodableObjectBase eo) {
        try {
            return eo.toXMLString(true);
        }
        catch (EXEncoderException e) {
            return "<unable to create text representation of " + eo.getClass() + ">";
        }
    }

    private static class LinkTypeIDChange {
        private final String moduleID;
        private final String linkTypeID;

        private LinkTypeIDChange(String moduleID, String linkTypeID) {
            this.moduleID = moduleID;
            this.linkTypeID = linkTypeID;
        }
    }
}

