/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.migration.version3.framework;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOAttributeTypeID_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOModuleData_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOVersionedModuleData_V0;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IAttributeValueConverter;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ICommonModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IGenericItemMigratorTask;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrationProcessor;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IModuleDataMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.IVersionedItemMigrator;
import com.arcway.cockpit.modulelib2.client.migration.version3.framework.ModuleDataMigrationProcessor;
import com.arcway.lib.UUIDGenerator;
import de.plans.lib.xml.encoding.EOEncodableObject;

public class AttributeToCustomPropertyMigrator
implements IGenericItemMigratorTask {
    private final String dataTypeID;
    private final String attributeTypeID;
    private final String humanreadableID;
    private final String displayName;
    private final int position;
    private final String attributeTypeDataType;
    private final IAttributeValueConverter attributeValueConverter;
    private EOAttributeTypeID_V0 customPropertyTypeID = null;

    public AttributeToCustomPropertyMigrator(String dataTypeID, String attributeTypeID, String humanreadableID, String displayName, int position, String attributeTypeDataType, IAttributeValueConverter attributeValueConverter) {
        this.dataTypeID = dataTypeID;
        this.attributeTypeID = attributeTypeID;
        this.humanreadableID = humanreadableID;
        this.displayName = displayName;
        this.position = position;
        this.attributeTypeDataType = attributeTypeDataType;
        this.attributeValueConverter = attributeValueConverter;
    }

    @Override
    public void installMigratorProcessors(final IModuleDataMigrationProcessor genericItemMigrator) {
        genericItemMigrator.addCommonMigrator(new ICommonModuleDataMigrator(){

            @Override
            public void migrateModuleData() {
                AttributeToCustomPropertyMigrator.this.customPropertyTypeID = new EOAttributeTypeID_V0(UUIDGenerator.getUniqueID(), AttributeToCustomPropertyMigrator.this.humanreadableID);
                EOEncodableObject eoValueRange = AttributeToCustomPropertyMigrator.this.attributeValueConverter.getValueRange();
                genericItemMigrator.createCustomPropertyType(AttributeToCustomPropertyMigrator.this.dataTypeID, AttributeToCustomPropertyMigrator.this.attributeTypeID, AttributeToCustomPropertyMigrator.this.customPropertyTypeID, AttributeToCustomPropertyMigrator.this.displayName, AttributeToCustomPropertyMigrator.this.position, AttributeToCustomPropertyMigrator.this.attributeTypeDataType, eoValueRange);
            }
        });
        genericItemMigrator.addItemMigrator(this.dataTypeID, new IModuleDataMigrator(){

            @Override
            public boolean migrateModuleData(EOModuleData_V0 item) {
                AttributeToCustomPropertyMigrator.this.transformAttributeToCustomProperty(item);
                boolean keepItem = true;
                return keepItem;
            }
        });
        genericItemMigrator.addVersionedItemMigrator(this.dataTypeID, new IVersionedItemMigrator(){

            @Override
            public boolean migrateVersionedModuleData(EOVersionedModuleData_V0 item) {
                AttributeToCustomPropertyMigrator.this.transformAttributeToCustomProperty((EOModuleData_V0)item);
                boolean keepItem = true;
                return keepItem;
            }
        });
    }

    private void transformAttributeToCustomProperty(EOModuleData_V0 item) {
        String value = item.getAttribute(this.attributeTypeID);
        if (!this.attributeValueConverter.isEmptyValue(value)) {
            EOEncodableObject customPropertyValue = this.attributeValueConverter.transformAttributeValue(value);
            ModuleDataMigrationProcessor.setCustomProperty(item, this.customPropertyTypeID, customPropertyValue);
        }
        item.setAttribute(this.attributeTypeID, null);
    }
}

