/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.messages.valuerangehelper;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IPermissionChecker;
import com.arcway.cockpit.modulelib2.client.messages.ModuleDataReference;
import de.plans.lib.util.valueranges.ValueRangeHelperListElement;
import java.util.ArrayList;
import java.util.Collection;

public class ValueRangeHelperModuleData
extends ValueRangeHelperListElement {
    protected String dataTypeUidList;
    private final IModuleData factoryInstanceOfModuleDataType;
    protected IPermissionChecker permissionChecker;
    protected IModelController modelController;
    private final boolean mayBeEmpty;
    private final ModuleDataReference persistentLocation;
    private final boolean creationOfNewObjectsAllowed;

    public ValueRangeHelperModuleData(String dataTypeUidList, IModuleData factoryInstanceOfModuleDataType, IPermissionChecker permissionChecker, IModelController modelController, boolean mayBeEmpty, ModuleDataReference associatedPersistentLocation, boolean shallUseEmptyStringSymbol) {
        assert (modelController != null) : "modelController must not be null";
        this.dataTypeUidList = dataTypeUidList;
        this.factoryInstanceOfModuleDataType = factoryInstanceOfModuleDataType;
        this.permissionChecker = permissionChecker;
        this.modelController = modelController;
        this.mayBeEmpty = mayBeEmpty;
        this.creationOfNewObjectsAllowed = true;
        this.persistentLocation = associatedPersistentLocation;
        this.isUsingEmptyStringSymbol = shallUseEmptyStringSymbol;
    }

    public ValueRangeHelperModuleData(String dataTypeUidList, IModuleData factoryInstanceOfModuleDataType, IModelController modelController, boolean mayBeEmpty, ModuleDataReference associatedPersistentLocation, boolean shallUseEmptyStringSymbol) {
        assert (modelController != null) : "modelController must not be null";
        this.dataTypeUidList = dataTypeUidList;
        this.factoryInstanceOfModuleDataType = factoryInstanceOfModuleDataType;
        this.permissionChecker = null;
        this.modelController = modelController;
        this.mayBeEmpty = mayBeEmpty;
        this.creationOfNewObjectsAllowed = false;
        this.persistentLocation = associatedPersistentLocation;
        this.isUsingEmptyStringSymbol = shallUseEmptyStringSymbol;
    }

    protected String[] getList() {
        ArrayList<? extends IModuleData> moduleDataList = new ArrayList<IModuleData>(this.modelController.getAllItems(this.dataTypeUidList));
        return this.createList(moduleDataList);
    }

    protected String[] createList(Collection moduleDataList) {
        ArrayList<String> moduleDataNames = new ArrayList<String>(moduleDataList.size());
        for (IModuleData element : moduleDataList) {
            if (this.permissionChecker != null && !this.permissionChecker.hasAccessPermission(element)) continue;
            moduleDataNames.add(element.getDisplayRepresentation());
        }
        String[] names = new String[moduleDataNames.size()];
        int c = 0;
        while (c < moduleDataNames.size()) {
            names[c] = (String)moduleDataNames.get(c);
            ++c;
        }
        return names;
    }

    protected String getThisElement() {
        IModuleData moduleData = this.persistentLocation.getItem();
        if (moduleData == null) {
            if (this.isUsingEmptyStringSymbol) {
                return "";
            }
            return "";
        }
        return moduleData.getDisplayRepresentation();
    }

    protected void setThisElement(String displayRepresentation) {
        assert (displayRepresentation != null);
        ArrayList<? extends IModuleData> moduleDataList = new ArrayList<IModuleData>(this.modelController.getAllItems(this.dataTypeUidList));
        for (AbstractModuleData abstractModuleData : moduleDataList) {
            if (!displayRepresentation.equals(abstractModuleData.getDisplayRepresentation())) continue;
            this.persistentLocation.setItem(abstractModuleData);
            return;
        }
        this.persistentLocation.setItem(null);
    }

    protected void createNewListElement(String displayRepresentation) {
        assert (displayRepresentation != null);
        IModuleData newElement = null;
        if (!displayRepresentation.equals("")) {
            newElement = this.factoryInstanceOfModuleDataType.getTypeDescription().getNewInstance();
            newElement.setDisplayRepresentation(displayRepresentation);
            newElement.setProjectUID(this.modelController.getProjectUID());
            final IModuleData newElementFinal = newElement;
            this.modelController.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    ValueRangeHelperModuleData.this.modelController.addItem(newElementFinal);
                }
            });
        }
        this.persistentLocation.setItem(newElement);
    }

    public boolean acceptsNewValues() {
        return this.creationOfNewObjectsAllowed && (this.permissionChecker == null || this.permissionChecker.hasCreatePermission());
    }

    public boolean acceptsEmptyString() {
        return this.mayBeEmpty;
    }
}

