/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.filters;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.AbstractFilterItem;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.gui.filters.AbstractStringValueFilter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StringValueFilterItem
extends AbstractFilterItem {
    private final String name;
    private final AbstractStringValueFilter filter;
    private Text txtString;
    private String value;

    public StringValueFilterItem(String name, AbstractStringValueFilter filter) {
        super(name, (AbstractFilter)filter);
        this.name = name;
        this.filter = filter;
        this.value = filter.getUIRepresentation();
    }

    public String getName() {
        return this.name;
    }

    public void refresh() {
        if (this.value != null) {
            this.txtString.setText(this.value);
        } else {
            this.txtString.setText("");
        }
    }

    public String getFilterInfo() {
        String textString = this.txtString.getText();
        if (textString != null) {
            return textString;
        }
        return null;
    }

    public Control createContent(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout groupLayout = new GridLayout(2, false);
        groupLayout.verticalSpacing = 2;
        groupLayout.horizontalSpacing = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupGD = new GridData(1808);
        group.setLayoutData((Object)groupGD);
        group.setText(this.getName());
        Label lbl = new Label((Composite)group, 0);
        lbl.setText(Messages.getString("StringValueFilterItem.Substring"));
        this.txtString = new Text((Composite)group, 2052);
        this.txtString.setLayoutData((Object)new GridData(768));
        this.txtString.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                StringValueFilterItem.this.txtString.selectAll();
            }

            public void focusLost(FocusEvent e) {
                StringValueFilterItem.this.updateFilter();
                StringValueFilterItem.this.fireValueChanged();
            }
        });
        this.refresh();
        return group;
    }

    public boolean isNoFilterValuesSet() {
        return this.txtString.getText().trim().length() == 0;
    }

    public boolean isAllFilterValuesSet() {
        return this.txtString.getText().trim().length() > 0;
    }

    private void updateFilter() {
        this.value = this.txtString.getText().trim();
        this.setSelected(this.value.length() > 0);
        if (!this.isUserConfirmationNecessary()) {
            this.confirmSelection();
        }
    }

    public void doConfirmSelection() {
        this.filter.setFilterFromUI(this.value);
    }

    public void resetFilterValueToFilterState() {
        this.value = this.filter.getUIRepresentation();
    }

    public void filterHasChanged() {
        this.value = this.filter.getFilterValue();
    }
}

