/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.editdialogs.itemeditors;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.modulelib2.shared.messages.ILinkTypeHelper_Shared;
import com.arcway.frontend.definition.lib.ui.editor.repository.RepositoryEditorFactory;
import com.arcway.lib.eclipse.uiframework.editors.EclipseWindow;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.clientadapter.interFace.CockpitDataID;
import com.arcway.repository.clientadapter.interFace.ICockpitDataID;
import com.arcway.repository.cockpit.interFace.declaration.frame.infolink.CRTIDsInfoLink;
import com.arcway.repository.interFace.data.RepositoryObjects;
import com.arcway.repository.interFace.data.RepositorySamples;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReference;
import com.arcway.repository.interFace.data.relation.ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.lib.high.declaration.type.object.RepositoryObjectTypeID;
import com.arcway.repository.lib.high.declaration.type.relation.RepositoryRelationTypeID;
import com.arcway.repository.lib.high.declaration.type.relationcontribution.RepositoryRelationContributionRoleID;
import com.arcway.repository.lib.high.implementation.access.CrossLinkRepositoryRelationsReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import java.util.Collection;
import org.eclipse.ui.PlatformUI;

public class ItemEditorManager {
    private static final ILogger logger = Logger.getLogger(ItemEditorManager.class);

    public static void openEditorForCreatingRootItem(IModelController modelController, String moduleID, String childCockpitDataTypeID, Collection uniqueElementUIDs) {
        IRepositoryInterfaceRO repository = modelController.getProjectAgent().getRepositoryInterface();
        RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(RepositoryIDCreator.getCoreTypeID(moduleID), "declaration_module_coremodule");
        RepositoryObjectTypeID childRepositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(childCockpitDataTypeID);
        try {
            IRepositorySnapshotRO snapshot = repository.openSnapshot(RepositorySamples.getSnapshotID((IRepositoryObjectSample)repository.sampleCurrentSnapshotInformation(), (IRepositoryTypeManagerRO)repository.getTypeManager()));
            try {
                try {
                    IRepositoryObject parentRepositoryObject = snapshot.getRepositoryRootObject();
                    RepositoryObjectReference parentObjectReference = new RepositoryObjectReference(parentRepositoryObject);
                    ICollection_<ICrossLinkRepositoryRelationsReference> relationReferencesForModelElementRelations = ItemEditorManager.getRelationsReferencesForModelElementLinks(modelController, childCockpitDataTypeID, uniqueElementUIDs, snapshot, repositoryIDCreator);
                    RepositoryEditorFactory.Input input = RepositoryEditorFactory.createEditorInputForObjectCreation((IRepositoryInterfaceRO)repository, (IRepositoryObjectReference)parentObjectReference, (IRepositoryObjectTypeID)childRepositoryObjectTypeID, relationReferencesForModelElementRelations);
                    EclipseWindow window = new EclipseWindow(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
                    window.openEditor((Object)input);
                }
                catch (Exception e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    snapshot.closeSnapshot();
                }
            }
            finally {
                snapshot.closeSnapshot();
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
    }

    public static void openEditorForCreatingChildItem(IModelController modelController, String moduleID, String childCockpitDataTypeID, IModuleData parentItem, Collection uniqueElementUIDs) {
        IModuleProjectAgent projectAgent = modelController.getProjectAgent();
        IRepositoryInterfaceRO repository = projectAgent.getRepositoryInterface();
        RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(RepositoryIDCreator.getCoreTypeID(moduleID), "declaration_module_coremodule");
        RepositoryObjectTypeID childRepositoryObjectTypeID = repositoryIDCreator.createObjectTypeIDForRealType(childCockpitDataTypeID);
        try {
            IRepositorySnapshotRO snapshot = repository.openSnapshot(RepositorySamples.getSnapshotID((IRepositoryObjectSample)repository.sampleCurrentSnapshotInformation(), (IRepositoryTypeManagerRO)repository.getTypeManager()));
            try {
                try {
                    IRepositoryObject cockpitParentRepositoryObject;
                    IRepositoryObject parentRepositoryObject = cockpitParentRepositoryObject = projectAgent.findRepositoryObject(snapshot, (ICockpitDataID)new CockpitDataID(parentItem.getTypeID(), parentItem.getUID()));
                    RepositoryObjectReference parentObjectReference = new RepositoryObjectReference(parentRepositoryObject);
                    ICollection_<ICrossLinkRepositoryRelationsReference> relationReferencesForModelElementRelations = ItemEditorManager.getRelationsReferencesForModelElementLinks(modelController, childCockpitDataTypeID, uniqueElementUIDs, snapshot, repositoryIDCreator);
                    RepositoryEditorFactory.Input input = RepositoryEditorFactory.createEditorInputForObjectCreation((IRepositoryInterfaceRO)repository, (IRepositoryObjectReference)parentObjectReference, (IRepositoryObjectTypeID)childRepositoryObjectTypeID, relationReferencesForModelElementRelations);
                    EclipseWindow window = new EclipseWindow(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
                    window.openEditor((Object)input);
                }
                catch (Exception e) {
                    logger.error("unhandled catch block", (Throwable)e);
                    snapshot.closeSnapshot();
                }
            }
            finally {
                snapshot.closeSnapshot();
            }
        }
        catch (EXNotReproducibleSnapshot e) {
            logger.error("unhandled catch block", (Throwable)e);
        }
    }

    private static ICollection_<ICrossLinkRepositoryRelationsReference> getRelationsReferencesForModelElementLinks(IModelController modelController, String moduleDataTypeID, Collection uniqueElementUIDs, IRepositorySnapshotRO snapshot, RepositoryIDCreator repositoryIDCreator) {
        ArrayList_ repositoryRelationsReferencesRW = new ArrayList_(uniqueElementUIDs.size());
        for (String uniqueElementUID : uniqueElementUIDs) {
            ICrossLinkRepositoryRelationsReference repositoryRelationsReference = ItemEditorManager.getRelationsReferenceForModelElementLink(modelController, moduleDataTypeID, uniqueElementUID, snapshot, repositoryIDCreator);
            if (repositoryRelationsReference == null) continue;
            repositoryRelationsReferencesRW.add((Object)repositoryRelationsReference);
        }
        return repositoryRelationsReferencesRW;
    }

    private static ICrossLinkRepositoryRelationsReference getRelationsReferenceForModelElementLink(IModelController modelController, String moduleDataTypeID, String uniqueElementUID, IRepositorySnapshotRO snapshot, RepositoryIDCreator repositoryIDCreator) {
        ICrossLinkRepositoryRelationsReferenceWithOnlyOneContribution repositoryRelationsReference;
        if (uniqueElementUID != null) {
            IRepositoryPropertySetSample uniqueElementID = ItemEditorManager.getModelElementID(modelController.getProjectAgent(), snapshot, uniqueElementUID);
            if (uniqueElementID != null) {
                ILinkTypeHelper_Shared linkTypeHelper = modelController.getLinkTypeHelper();
                String linkTypeID = linkTypeHelper.getModelElementLinkTypeIDForModuleDataDataType(moduleDataTypeID);
                RepositoryRelationTypeID relationTypeID = repositoryIDCreator.createRelationTypeID(CRTIDsInfoLink.RELATION_TYPE_ID, linkTypeID);
                RepositoryRelationContributionRoleID uniqueElementRoleID = CRTIDsInfoLink.RELATION_CONTRIBUTION_ROLE_ID_MODELELEMENT;
                repositoryRelationsReference = CrossLinkRepositoryRelationsReference.createWithOnlyOneContribution((IRepositoryRelationTypeID)relationTypeID, (IRepositoryRelationContributionRoleID)uniqueElementRoleID, (IRepositoryPropertySetSample)uniqueElementID);
            } else {
                repositoryRelationsReference = null;
            }
        } else {
            repositoryRelationsReference = null;
        }
        return repositoryRelationsReference;
    }

    private static IRepositoryPropertySetSample getModelElementID(IModuleProjectAgent projectAgent, IRepositorySnapshotRO snapshot, String uniqueElementUID) {
        IRepositoryPropertySetSample repositoryObjectID;
        block5: {
            IUniqueElement uniqueElement = projectAgent.getModuleUniqueElementManager().getUniqueElement(uniqueElementUID);
            if (uniqueElement != null) {
                try {
                    IRepositoryObject repositoryObject = projectAgent.findRepositoryObject(snapshot, (ICockpitDataID)new CockpitDataID((ICockpitProjectData)uniqueElement));
                    if (repositoryObject != null) {
                        repositoryObjectID = RepositoryObjects.getObjectID((IRepositoryObject)repositoryObject);
                        break block5;
                    }
                    repositoryObjectID = null;
                }
                catch (EXNotReproducibleSnapshot e) {
                    repositoryObjectID = null;
                }
            } else {
                repositoryObjectID = null;
            }
        }
        return repositoryObjectID;
    }
}

