/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.detailsviewprovider;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.CockpitProjectDataSelector;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementExpandableList;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSingle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.AbstractDetailsProvider2;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSingle;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.UnlinkAction;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElement;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.crossmodulelinks.CrossModuleLinkManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ViewModuleAttributeAgent;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData_CustomPropertiesExtension;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public abstract class ModuleDetailsProvider
extends AbstractDetailsProvider2 {
    private final ProjectTreeContentProvider frameLabelProvider = new ProjectTreeContentProvider(null);
    private boolean isForHistoryViewer = false;

    public void setIsForHistoryViewer(boolean isForHistoryViewer) {
        this.isForHistoryViewer = isForHistoryViewer;
    }

    public final Image getImage(ICockpitProjectData itemToBeDisplayed) {
        boolean categoryStillExists;
        ObjectTypeCategoryID categoryID;
        if (this.isForHistoryViewer && (categoryID = ((IModuleData)itemToBeDisplayed).getCategoryID()) != null && !(categoryStillExists = this.getModelController(itemToBeDisplayed.getProjectUID()).getProjectAgent().getObjectTypeCategoriesManager().itemExists(categoryID.getUID()))) {
            return ((IModuleData)itemToBeDisplayed).getTypeDescription().getTypeIcon().getImage();
        }
        return ((IModuleData)itemToBeDisplayed).getStatusDependentIcon().getImage();
    }

    public final String getTypeName(ICockpitProjectData itemToBeDisplayed) {
        return ((IModuleData)itemToBeDisplayed).getTypeDescription().getTypeName(Locale.getDefault());
    }

    protected final Image getTitleImage(ICockpitProjectData itemToBeDisplayed) {
        return this.getImage(itemToBeDisplayed);
    }

    public List<DetailsElement> getCurrentDetailsElementsForComparison() {
        if (this.isForHistoryViewer) {
            return this.getCurrentlyDisplayedDetailsElements();
        }
        throw new UnsupportedOperationException();
    }

    protected final IAttributeOwner getAttributeOwner(ICockpitProjectData itemToShow) {
        if (itemToShow instanceof IModuleData_CustomPropertiesExtension) {
            IModelController modelController = this.getModelController(itemToShow.getProjectUID());
            return new ViewModuleAttributeAgent((IModuleData_CustomPropertiesExtension)itemToShow, modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager(), modelController);
        }
        return null;
    }

    protected final List<DetailsElement> getTitleDetailsElements(ICockpitProjectData itemToShow) {
        List<DetailsElement> titleDetailsElements = this.getTitleDetailsElements_internal(itemToShow);
        if (this.isForHistoryViewer && ((IModuleData)itemToShow).getTypeDescription().isSupportingCategories()) {
            ObjectTypeCategory category;
            titleDetailsElements = new ArrayList<DetailsElement>(titleDetailsElements);
            ObjectTypeCategoryID categoryID = ((IModuleData)itemToShow).getCategoryID();
            String categoryLabel = categoryID != null ? ((category = this.getModelController(itemToShow.getProjectUID()).getProjectAgent().getObjectTypeCategoriesManager().getCategory(categoryID)) != null ? category.getDisplayName() : ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY) : ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY;
            titleDetailsElements.add((DetailsElement)new DetailsElementSingle("mlb2.md.category", ObjectTypeCategoryLabels.LABEL_CATEGORY, new DetailsValueSingle(categoryLabel, 0, 100)));
            titleDetailsElements.add((DetailsElement)new DetailsElementSeparator("mlb2.md.category.sep", 8, new DetailsValueSeparator()));
        }
        return titleDetailsElements;
    }

    protected abstract List<DetailsElement> getTitleDetailsElements_internal(ICockpitProjectData var1);

    protected final List<DetailsElement> getCustomPropertyDetailsElements(ICockpitProjectData itemToShow) {
        return super.getDefaultCustomPropertyDetailsElements(itemToShow, this.isForHistoryViewer);
    }

    protected final List<DetailsElement> getAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        if (!this.isForHistoryViewer) {
            detailsElements.addAll(this.getTypeSpecificAdditionalInformationDetailsElements(itemToShow));
            if (this.hasLinkedIssues(itemToShow)) {
                if (!detailsElements.isEmpty()) {
                    detailsElements.add((DetailsElement)new DetailsElementSeparator("mlb2.md.issues.sep", 8, new DetailsValueSeparator()));
                }
                detailsElements.addAll(this.addLinkedIssuesDetailsElements((IModuleData)itemToShow));
            }
            if (this.hasLinkedModelElements(itemToShow)) {
                if (!detailsElements.isEmpty()) {
                    detailsElements.add((DetailsElement)new DetailsElementSeparator("mlb2.md.modelelements.sep", 8, new DetailsValueSeparator()));
                }
                detailsElements.addAll(this.addLinkedModelElementsDetailsElements((IModuleData)itemToShow));
            }
        }
        return detailsElements;
    }

    protected List<DetailsElement> getTypeSpecificAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        return Collections.emptyList();
    }

    protected final List<DetailsElement> getFooterDetailsElements(ICockpitProjectData itemToShow) {
        IModuleData moduleDataToShow = (IModuleData)itemToShow;
        ArrayList<DetailsElement> detailsElements_ = new ArrayList<DetailsElement>(4);
        if (!this.isForHistoryViewer) {
            detailsElements_.add((DetailsElement)new DetailsElementSingle("mlb2.md.footer.creator", AbstractModuleData.CREATOR_NAME, new DetailsValueSingle(moduleDataToShow.getAttribute("abstractmoduledata_creator").getDisplayStringRepresentation(), 0, 102)));
            detailsElements_.add((DetailsElement)new DetailsElementSingle("mlb2.md.footer.cdate", AbstractModuleData.CDATE_NAME, new DetailsValueSingle(moduleDataToShow.getAttribute("abstractmoduledata_creationDate").getDisplayStringRepresentation(), 0, 102)));
        }
        String modifierLabel = !this.isForHistoryViewer ? AbstractModuleData.MODIFIER_NAME : Messages.getString("HistoryViewer.ModifierLabel");
        detailsElements_.add((DetailsElement)new DetailsElementSingle("mlb2.md.footer.modifier", modifierLabel, new DetailsValueSingle(moduleDataToShow.getAttribute("abstractmoduledata_modifier").getDisplayStringRepresentation(), 0, 102)));
        String modificationDateLabel = !this.isForHistoryViewer ? AbstractModuleData.MDATE_NAME : Messages.getString("HistoryViewer.ModificationDateLabel");
        detailsElements_.add((DetailsElement)new DetailsElementSingle("mlb2.md.footer.mdate", modificationDateLabel, new DetailsValueSingle(moduleDataToShow.getAttribute("abstractmoduledata_modificationDate").getDisplayStringRepresentation(), 0, 102)));
        return detailsElements_;
    }

    private boolean hasLinkedIssues(ICockpitProjectData elementToShow) {
        CrossModuleLinkManager crossModuleLinkManager = CrossModuleLinkManager.getInstance(elementToShow.getProjectUID());
        if (!crossModuleLinkManager.isLinkTypeRegistered("crossmodulelink-genericmodule-issuemodule2--cross-module-issue-link")) {
            return false;
        }
        return !crossModuleLinkManager.getLinkableObjects((IModuleData)elementToShow, "crossmodulelink-genericmodule-issuemodule2--cross-module-issue-link").isEmpty();
    }

    private List<DetailsElement> addLinkedIssuesDetailsElements(IModuleData elementToShow) {
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        DetailsValueList issueListDetailsValue = new DetailsValueList();
        CrossModuleLinkManager crossModuleLinkManager = CrossModuleLinkManager.getInstance(elementToShow.getProjectUID());
        Collection<IModuleData> linkedIssues = crossModuleLinkManager.getLinkableObjects(elementToShow, "crossmodulelink-genericmodule-issuemodule2--cross-module-issue-link");
        for (IModuleData linkedIssue : linkedIssues) {
            issueListDetailsValue.addListElement(linkedIssue.getDisplayRepresentation(), linkedIssue.getStatusDependentIcon().getImage(), new ListEntryParameter((Runnable)new CockpitProjectDataSelector((ICockpitProjectData)linkedIssue, this.getContainingDetailsView()), null, null));
        }
        String label = NLS.bind((String)Messages.getString("ModuleDetailsView.Issues"), (Object)new Integer(linkedIssues.size()));
        detailsElements.add((DetailsElement)new DetailsElementExpandableList("mlb2.md.issues", label, issueListDetailsValue));
        return detailsElements;
    }

    private boolean hasLinkedModelElements(ICockpitProjectData elementToShow) {
        IModelController modelController = this.getModelController(elementToShow.getProjectUID());
        String modelElementLinkType = modelController.getLinkTypeHelper().getModelElementLinkTypeIDForModuleDataDataType(elementToShow.getTypeID());
        if (modelElementLinkType == null) {
            return false;
        }
        return !modelController.getLinksForModuleDataItem((IModuleData)elementToShow, modelElementLinkType).isEmpty();
    }

    private List<DetailsElement> addLinkedModelElementsDetailsElements(IModuleData elementToShow) {
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>();
        DetailsValueList modelelementListDetailsValue = new DetailsValueList();
        IModelController modelController = this.getModelController(elementToShow.getProjectUID());
        String modelElementLinkType = modelController.getLinkTypeHelper().getModelElementLinkTypeIDForModuleDataDataType(elementToShow.getTypeID());
        Collection<ICockpitProjectData> linkedModelElements = modelController.getLinkableObjects(elementToShow, modelElementLinkType);
        for (ICockpitProjectData linkedModelElementCockpitData : linkedModelElements) {
            UniqueElement linkedModelElement = (UniqueElement)linkedModelElementCockpitData;
            UnlinkAction unlinkAction = new UnlinkAction(new ModuleLinkViewContribution(this.getContainingDetailsView().getSite()), this.getContainingDetailsView().getSite());
            unlinkAction.update((ICockpitProjectData)linkedModelElement, (ICockpitProjectData)elementToShow);
            modelelementListDetailsValue.addListElement(linkedModelElement.getElementName(), this.frameLabelProvider.getImage((Object)linkedModelElement), new ListEntryParameter((Runnable)new CockpitProjectDataSelector((ICockpitProjectData)linkedModelElement, this.getContainingDetailsView()), Collections.singletonList(new ActionContributionItem((IAction)unlinkAction)), null));
        }
        String label = NLS.bind((String)Messages.getString("ModuleDetailsView.ModelElements"), (Object)new Integer(linkedModelElements.size()));
        detailsElements.add((DetailsElement)new DetailsElementExpandableList("mlb2.md.modelelements", label, modelelementListDetailsValue));
        return detailsElements;
    }

    protected static final String getLinkedAttribute(IModuleData moduleData, String linkTypeID, IModelController modelController) {
        String attributeValue;
        Collection<ICockpitProjectData> linkableObjects = modelController.getLinkableObjects(moduleData, linkTypeID);
        if (linkableObjects.isEmpty()) {
            attributeValue = "";
        } else {
            assert (linkableObjects.size() == 1);
            attributeValue = ((IModuleData)linkableObjects.iterator().next()).getDisplayRepresentation();
        }
        return attributeValue;
    }

    protected abstract IModelController getModelController(String var1);

    protected final boolean isForHistoryViewer() {
        return this.isForHistoryViewer;
    }

    protected void disposeResources() {
        this.frameLabelProvider.dispose();
    }
}

