/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AbstractModuleAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.DiscreteValueWithFrameObject;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.frontend.definition.lib.interFace.label.IExpiringFrontendLabel;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import de.plans.lib.localisation.ILabelProvider;
import de.plans.lib.localisation.LabelProviderUnlocalisedString;
import de.plans.lib.resources.IIconResource;
import de.plans.lib.resources.StreamIconResource;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AttributeHandlerForLinkedFrameDataAttributes
extends AbstractModuleAttributeHandler {
    private static final ILogger logger = Logger.getLogger(AttributeHandlerForLinkedFrameDataAttributes.class);
    public static final Comparator<IRepositoryObjectReference> REPOSITORYOBJECT_LABEL_COMPARATOR = new Comparator<IRepositoryObjectReference>(){

        @Override
        public int compare(IRepositoryObjectReference o1, IRepositoryObjectReference o2) {
            return 0;
        }
    };
    private final String frameCockpitTypeID;
    private Comparator<? super IRepositoryObjectReference> comparator;
    private final boolean allowEmptyAttributeValue;
    private List<DiscreteValueWithFrameObject> lastReturnedValueRange = null;

    public AttributeHandlerForLinkedFrameDataAttributes(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String attributeID, String attributeName, String dataTypeID, String frameCockpitTypeID, Comparator<? super IRepositoryObjectReference> comparator, boolean allowEmptyAttributeValue, boolean checkPermission) {
        super(projectSwitchListenerManager, modelControllerProvider, attributeID, attributeName, dataTypeID, checkPermission);
        this.frameCockpitTypeID = frameCockpitTypeID;
        this.allowEmptyAttributeValue = allowEmptyAttributeValue;
        this.comparator = comparator == REPOSITORYOBJECT_LABEL_COMPARATOR ? new RepositoryObjectLabelComparator() : comparator;
    }

    @Override
    public void changeValue(final Object domainItem, int index, DiscreteValue value) {
        final IModelController modelCtrl = this.getModelController();
        final IModuleData item = (IModuleData)domainItem;
        final IRepositoryObjectReference newValue = ((DiscreteValueWithFrameObject)value).getLinkedObject();
        modelCtrl.executeTransaction(new Runnable(){

            @Override
            public void run() {
                boolean success = modelCtrl.getPlatformAccessAgent().changeLinkToFrameItem(item, AttributeHandlerForLinkedFrameDataAttributes.this.getAttributeID(), newValue).hasNewValueBeenApplied();
                if (!success) {
                    logger.warn("Linked frame data item could not be linked to module data item via \"Change discrete value action\"");
                } else {
                    modelCtrl.itemPropertiesModified((IModuleData)domainItem, null);
                }
            }
        });
    }

    @Override
    public List<? extends DiscreteValue> getValueRange() {
        IModelController modelController = this.getModelController();
        if (modelController != null) {
            ArrayList<IRepositoryObjectReference> objects = new ArrayList<IRepositoryObjectReference>(this.getModelController().getPlatformAccessAgent().getAllFrameDataItems(this.frameCockpitTypeID));
            if (this.comparator != null) {
                Collections.sort(objects, this.comparator);
            }
            ArrayList<DiscreteValueWithFrameObject> valueRange = new ArrayList<DiscreteValueWithFrameObject>(objects.size() + 1);
            if (this.allowEmptyAttributeValue) {
                valueRange.add(new DiscreteValueWithFrameObject((ILabelProvider)new LabelProviderUnlocalisedString(""), null));
            }
            for (IRepositoryObjectReference element : objects) {
                IExpiringFrontendLabel label = modelController.getPlatformAccessAgent().getLabelForPlatformObject(element);
                StreamIconResource inputStreamIconResource = null;
                if (label.getIcon16x16() != null) {
                    inputStreamIconResource = new StreamIconResource(label.getIcon16x16());
                }
                valueRange.add(new DiscreteValueWithFrameObject((ILabelProvider)new LabelProviderUnlocalisedString(label.getText() != null ? label.getText() : ""), (IIconResource)inputStreamIconResource, element));
            }
            this.lastReturnedValueRange = valueRange;
            return valueRange;
        }
        this.lastReturnedValueRange = Collections.emptyList();
        return Collections.emptyList();
    }

    @Override
    public int getCurrentValueIndex(Object item) {
        assert (item instanceof IModuleData);
        if (!(item instanceof IModuleData)) {
            return -1;
        }
        if (this.lastReturnedValueRange == null) {
            return -1;
        }
        IRepositoryObjectReference currentlyLinkedAttributeItem = this.getModelController().getPlatformAccessAgent().getLinkedFrameDataItem((IModuleData)item, this.getAttributeID());
        if (currentlyLinkedAttributeItem != null) {
            int index = 0;
            for (DiscreteValueWithFrameObject value : this.lastReturnedValueRange) {
                IRepositoryObjectReference linkedAttributeItemAtIndex = value.getLinkedObject();
                if (linkedAttributeItemAtIndex != null && IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER.isEqual((Object)linkedAttributeItemAtIndex, (Object)currentlyLinkedAttributeItem)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
        return this.allowEmptyAttributeValue ? 0 : -1;
    }

    class RepositoryObjectLabelComparator
    implements Comparator<IRepositoryObjectReference> {
        RepositoryObjectLabelComparator() {
        }

        @Override
        public int compare(IRepositoryObjectReference o1, IRepositoryObjectReference o2) {
            IModelController modelController = AttributeHandlerForLinkedFrameDataAttributes.this.getModelController();
            String label1 = null;
            IExpiringFrontendLabel repositoryLabel1 = modelController.getPlatformAccessAgent().getLabelForPlatformObject(o1);
            if (repositoryLabel1 != null) {
                label1 = repositoryLabel1.getText();
            }
            String label2 = null;
            IExpiringFrontendLabel repositoryLabel2 = modelController.getPlatformAccessAgent().getLabelForPlatformObject(o2);
            if (repositoryLabel2 != null) {
                label2 = repositoryLabel2.getText();
            }
            if (label1 == null && label2 == null) {
                return 0;
            }
            if (label1 == null) {
                return 1;
            }
            if (label2 == null) {
                return -1;
            }
            return label1.compareToIgnoreCase(label2);
        }
    }
}

