/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes;

import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.ModuleLib2Plugin;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AbstractModuleHandler;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractModuleAttributeHandler
extends AbstractModuleHandler {
    private final String attributeTypeID;
    private static final IStatus STATUS_NO_PERMISSION = new Status(4, ModuleLib2Plugin.getDefault().getBundle().getSymbolicName(), 0, Messages.getString("AbstractModuleAttributeHandler.ErrMsgPermission"), null);
    private static final IStatus STATUS_NO_LOCK = new Status(4, ModuleLib2Plugin.getDefault().getBundle().getSymbolicName(), 0, Messages.getString("AbstractModuleAttributeHandler.ErrMsgLock"), null);

    public AbstractModuleAttributeHandler(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String attributeTypeID, String attributeName, String dataTypeID) {
        this(projectSwitchListenerManager, modelControllerProvider, attributeTypeID, attributeName, dataTypeID, true);
    }

    public AbstractModuleAttributeHandler(IModuleProjectSwitchListenerManager projectSwitchListenerManager, IModelControllerProvider modelControllerProvider, String attributeTypeID, String attributeName, String dataTypeID, boolean checkAttributePermission) {
        super(projectSwitchListenerManager, modelControllerProvider, attributeName, dataTypeID, checkAttributePermission);
        this.attributeTypeID = attributeTypeID;
    }

    @Override
    public IStatus canChangeValue(Object domainItem, int value) {
        if (this.isCheckPermissions() && !this.getModelController().getPermissionMgr().mayEditAttribute((IModuleData)domainItem, this.attributeTypeID)) {
            return STATUS_NO_PERMISSION;
        }
        if (!this.getModelController().getLockMgr().acquireEditLock((ICockpitProjectData)((IModuleData)domainItem)).hasLock()) {
            return STATUS_NO_LOCK;
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean enableFor(Object domainItem) {
        return !this.isCheckPermissions() || this.getModelController().getPermissionMgr().mayEditAttribute((IModuleData)domainItem, this.attributeTypeID);
    }

    @Override
    public String getID() {
        return this.attributeTypeID;
    }

    @Override
    public boolean registerFor(Object domainItem) {
        return ((IModuleData)domainItem).getTypeID().equals(this.getDataTypeID());
    }

    protected final String getAttributeID() {
        return this.attributeTypeID;
    }
}

