/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.compare.ModuleDataEditionSelectionDialogue;
import com.arcway.cockpit.modulelib2.client.gui.compare.ModuleDataRevision;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.java.locale.resourcebundles.ArcwayStandardResourceBundleLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.compare.ITypedElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractActionDelegateShowHistory
extends ModuleActionDelegate {
    private static final String BUNDLE_NAME = "com.arcway.cockpit.modulelib2.client.gui.actions.ShowHistory";
    private IModuleData selectedItem;
    private IModelController modelController;
    private boolean enablement = false;

    public final void run(IAction action) {
        if (this.selectedItem != null) {
            final List<? extends IModuleData> versions = this.modelController.getVersionsOfItem(this.selectedItem);
            this.selectedItem = this.modelController.getItem(this.selectedItem.getTypeID(), this.selectedItem.getUID());
            if (this.selectedItem == null) {
                MessageDialog.openWarning((Shell)this.getIssuingShell(), (String)Messages.getString("ActionDelegateShowVersions.ItemDeletedTitle"), (String)Messages.getString("ActionDelegateShowVersions.ItemDeletedText"));
                return;
            }
            this.modelController.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    ResourceBundle bundle = ArcwayStandardResourceBundleLoader.getBundle((String)AbstractActionDelegateShowHistory.BUNDLE_NAME, (Locale)Locale.getDefault(), AbstractActionDelegateShowHistory.class);
                    ModuleDataEditionSelectionDialogue dialog = new ModuleDataEditionSelectionDialogue(AbstractActionDelegateShowHistory.this.getIssuingShell(), bundle);
                    dialog.setCompareMode(true);
                    dialog.setHideIdenticalEntries(true);
                    dialog.selectEdition(AbstractActionDelegateShowHistory.this.getRevisionObjectForCurrentItem(AbstractActionDelegateShowHistory.this.selectedItem), AbstractActionDelegateShowHistory.this.getRevisionObjectsForVersions(versions), "Root");
                }
            });
        }
    }

    private ITypedElement[] getRevisionObjectsForVersions(Collection<? extends IModuleData> itemVersions) {
        ArrayList<ModuleDataRevision> revisionObjects = new ArrayList<ModuleDataRevision>(itemVersions.size());
        for (IModuleData iModuleData : itemVersions) {
            revisionObjects.add(new ModuleDataRevision(iModuleData, this.modelController));
        }
        return revisionObjects.toArray(new ITypedElement[itemVersions.size()]);
    }

    private ITypedElement getRevisionObjectForCurrentItem(IModuleData item) {
        return new ModuleDataRevision(item, this.modelController);
    }

    public final boolean determineEnabledStatus(ISelection selectionObject) {
        IStructuredSelection selection;
        this.enablement = false;
        this.selectedItem = null;
        if (selectionObject instanceof IStructuredSelection && (selection = (IStructuredSelection)selectionObject).size() == 1) {
            this.selectedItem = this.getItemForSelectedObject(selection.getFirstElement());
            if (this.selectedItem != null) {
                this.modelController = this.getModelController(this.selectedItem.getProjectUID());
                this.enablement = true;
            }
        }
        return this.enablement;
    }

    protected final boolean determineEnabledStatus(String modelController_) {
        return this.enablement;
    }

    protected final <T> boolean determineEnabledStatus(IPropertyChanges<T> changes, Class<T> clazz) {
        return this.enablement;
    }

    protected IModuleData getItemForSelectedObject(Object selectedObject) {
        return (IModuleData)selectedObject;
    }

    protected abstract IModelController getModelController(String var1);
}

