/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.modulelib2.client.Messages;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.gui.AbstractCopyManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractActionDelegatePaste
extends ModuleActionDelegate {
    private static final ILogger LOGGER = Logger.getLogger(AbstractActionDelegatePaste.class);
    private AbstractCopyManager copyManager;
    private IModelController modelController;
    private final Collection<IModuleData> selectedElements = new HashSet<IModuleData>();
    private boolean enablement = false;

    protected void init() {
        this.copyManager = this.getCopyManager();
    }

    protected boolean determineEnabledStatus(String projectUID) {
        this.modelController = projectUID != null ? this.getModelController(projectUID) : null;
        this.enablement = false;
        return this.enablement;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.selectedElements.removeAll(changes.getDeletedElements());
        return this.enablement;
    }

    public void run(IAction action) {
        final Shell shell = this.getIssuingShell();
        if (!this.selectedElements.isEmpty()) {
            ArrayList<LockAccess> acquiredLocks = new ArrayList<LockAccess>(this.selectedElements.size());
            LockAccessWrapper lockAccessWrapper = new LockAccessWrapper();
            for (IModuleData selectedItem : this.selectedElements) {
                String virtualParentTypeOfClipboardData = this.copyManager.isCopiedDataInClipboard(selectedItem.getTypeID());
                if (!this.copyManager.doCheckPermissions(virtualParentTypeOfClipboardData, selectedItem, this.modelController, shell) || !this.copyManager.doAcquireLocks(selectedItem, this.modelController, shell, lockAccessWrapper)) {
                    for (LockAccess lock : acquiredLocks) {
                        lock.releaseLocks();
                    }
                    return;
                }
                acquiredLocks.add(lockAccessWrapper.getLockAccess());
            }
            this.modelController.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    for (IModuleData selectedItem : AbstractActionDelegatePaste.this.selectedElements) {
                        Object copiedData = AbstractActionDelegatePaste.this.copyManager.retrieveFromClipboard(selectedItem.getTypeID());
                        if (copiedData != null) {
                            Collection<IModuleData> pastedItems = AbstractActionDelegatePaste.this.copyManager.paste(copiedData, selectedItem, AbstractActionDelegatePaste.this.modelController, shell);
                            if (pastedItems != null) continue;
                            MessageDialog.openWarning((Shell)shell, (String)Messages.getString("CopyPaste.CopyNotPossible.Title"), (String)Messages.getString("CopyPaste.CopyNotPossible.Message"));
                            continue;
                        }
                        LOGGER.warn("Skipped pasting <null> clipboard content.");
                    }
                }
            });
        } else {
            LockAccessWrapper lockAccessWrapper = new LockAccessWrapper();
            String virtualParentTypeOfClipboardData = this.copyManager.isCopiedDataInClipboard("hierarchyroot");
            if (!this.copyManager.doCheckPermissions(virtualParentTypeOfClipboardData, null, this.modelController, shell) || !this.copyManager.doAcquireLocks(null, this.modelController, shell, lockAccessWrapper)) {
                lockAccessWrapper.getLockAccess().releaseLocks();
                return;
            }
            this.modelController.executeTransaction(new Runnable(){

                @Override
                public void run() {
                    Object copiedData = AbstractActionDelegatePaste.this.copyManager.retrieveFromClipboard("hierarchyroot");
                    if (copiedData != null) {
                        Collection<IModuleData> pastedItems = AbstractActionDelegatePaste.this.copyManager.paste(copiedData, null, AbstractActionDelegatePaste.this.modelController, shell);
                        if (pastedItems == null) {
                            MessageDialog.openWarning((Shell)shell, (String)Messages.getString("CopyPaste.CopyNotPossible.Title"), (String)Messages.getString("CopyPaste.CopyNotPossible.Message"));
                        }
                    } else {
                        LOGGER.warn("Skipped pasting <null> clipboard content to root.");
                    }
                }
            });
        }
    }

    public boolean determineEnabledStatus(ISelection selection) {
        this.enablement = false;
        this.selectedElements.clear();
        if (selection instanceof IStructuredSelection) {
            if (!selection.isEmpty()) {
                String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
                if (projectUID != null) {
                    this.modelController = this.getModelController(projectUID);
                    if (this.modelController != null) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        boolean pastable = true;
                        for (Object selectedObject : structuredSelection.toList()) {
                            if (!(selectedObject instanceof IModuleData)) {
                                pastable = false;
                                break;
                            }
                            IModuleData selectedItem = (IModuleData)selectedObject;
                            String virtualParentTypeOfClipboardData = this.copyManager.isCopiedDataInClipboard(selectedItem.getTypeID());
                            if (virtualParentTypeOfClipboardData != null && this.copyManager.doCheckPermissions(virtualParentTypeOfClipboardData, selectedItem, this.modelController)) continue;
                            pastable = false;
                            break;
                        }
                        if (pastable) {
                            this.enablement = true;
                            this.selectedElements.addAll(structuredSelection.toList());
                        }
                    }
                }
            } else if (this.modelController != null) {
                String virtualParentTypeOfClipboardData = this.copyManager.isCopiedDataInClipboard("hierarchyroot");
                boolean pastable = true;
                if (virtualParentTypeOfClipboardData == null || !this.copyManager.doCheckPermissions(virtualParentTypeOfClipboardData, null, this.modelController)) {
                    pastable = false;
                }
                if (pastable) {
                    this.enablement = true;
                    this.selectedElements.clear();
                }
            }
        }
        return this.enablement;
    }

    protected abstract AbstractCopyManager getCopyManager();

    protected abstract IModelController getModelController(String var1);
}

