/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.core.project;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.modules.ProjectionIdentifier;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionMgr;
import com.arcway.cockpit.frame.client.project.planeditors.projections.IProjectionReceiver;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbenchPage;

public abstract class ProjectionMgr
implements IProjectionMgr,
IPropertyChangesListener,
IPropertyChangeListener,
IProjectCloseListener {
    protected IModuleProjectAgent projectAgent;
    protected IModel model;
    protected LinkMgr linkManager;
    private Collection<String> availableProjectionTypes;
    private Collection<Class<?>> updateTriggeringDataTypes;
    private Collection<String> updateTriggeringLinkTypes;
    private static final Map<IProjectionReceiver, ProjectionIdentifier> activeProjections = new HashMap<IProjectionReceiver, ProjectionIdentifier>();
    private static final Map<IProjectionReceiver, ProjectionMgr> map_projectionReceiver_responsibleProjectionManagers = new HashMap<IProjectionReceiver, ProjectionMgr>();
    private static final Map<IProjectionReceiver, IWorkbenchPage> map_projectionReceiver_workbenchPage = new HashMap<IProjectionReceiver, IWorkbenchPage>();

    public void construct(IModuleProjectAgent project, IModel model_, LinkMgr linkManager_) {
        this.projectAgent = project;
        this.model = model_;
        this.linkManager = linkManager_;
        this.availableProjectionTypes = new HashSet<String>();
        for (ProjectionIdentifier projectionIdentifier : this.getAvailableProjections()) {
            this.availableProjectionTypes.add(projectionIdentifier.getProjectionID());
        }
        this.projectAgent.addProjectCloseListener((IProjectCloseListener)this);
        this.updateTriggeringDataTypes = this.getDatatypesWhichTriggerUpdate();
        if (this.updateTriggeringDataTypes != null) {
            for (Class clazz : this.updateTriggeringDataTypes) {
                project.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, clazz);
            }
        }
        this.updateTriggeringLinkTypes = this.getLinktypesWhichTriggerUpdate();
    }

    public final void closeProject(IFrameProjectAgent projectAgent_) {
        if (this.projectAgent.getProjectUID().equals(projectAgent_.getProjectUID())) {
            projectAgent_.removeProjectCloseListener((IProjectCloseListener)this);
            this.projectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
            this.closeProject_();
        }
    }

    protected abstract void closeProject_();

    public final boolean startProjection(ProjectionIdentifier projectionID, IProjectionReceiver projectionReceiver, IWorkbenchPage page) {
        assert (projectionID != null);
        if (projectionReceiver != null && this.availableProjectionTypes.contains(projectionID.getProjectionID())) {
            this.stopProjection_internal(projectionReceiver, true);
            this.doProject(projectionID, projectionReceiver, page);
            activeProjections.put(projectionReceiver, projectionID);
            map_projectionReceiver_responsibleProjectionManagers.put(projectionReceiver, this);
            map_projectionReceiver_workbenchPage.put(projectionReceiver, page);
            return true;
        }
        return false;
    }

    public final boolean stopProjection(IProjectionReceiver projectionReceiver) {
        return this.stopProjection_internal(projectionReceiver, false);
    }

    private boolean stopProjection_internal(IProjectionReceiver projectionReceiver, boolean executeForOtherProjectionManager) {
        assert (projectionReceiver != null);
        if (activeProjections.containsKey(projectionReceiver)) {
            ProjectionMgr responsibleProjectionManager = map_projectionReceiver_responsibleProjectionManagers.get(projectionReceiver);
            IWorkbenchPage page = map_projectionReceiver_workbenchPage.get(projectionReceiver);
            if (executeForOtherProjectionManager || responsibleProjectionManager == this) {
                responsibleProjectionManager.doStopProjection(projectionReceiver, page);
                activeProjections.remove(projectionReceiver);
                map_projectionReceiver_responsibleProjectionManagers.remove(projectionReceiver);
                map_projectionReceiver_workbenchPage.remove(projectionReceiver);
                return true;
            }
            return false;
        }
        return false;
    }

    public final void updateProjections(IWorkbenchPage page) {
        for (Map.Entry<IProjectionReceiver, ProjectionIdentifier> entry : activeProjections.entrySet()) {
            ProjectionMgr responsibleProjectionManager;
            IWorkbenchPage receiverPage = map_projectionReceiver_workbenchPage.get(entry.getKey());
            if (page != null && !page.equals(receiverPage) || (responsibleProjectionManager = map_projectionReceiver_responsibleProjectionManagers.get(entry.getKey())) != this) continue;
            this.doProject(entry.getValue(), entry.getKey(), receiverPage);
        }
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        if (EOLink.class.isAssignableFrom(clazz)) {
            HashSet links = new HashSet();
            links.addAll(changes.getCreatedElements());
            links.addAll(changes.getModifiedElements());
            links.addAll(changes.getDeletedElements());
            for (Object link : links) {
                if (!this.updateTriggeringLinkTypes.contains(((EOLink)link).getLinkTypeID())) continue;
                this.updateProjections(null);
                break;
            }
        } else if (this.updateTriggeringDataTypes.contains(clazz)) {
            this.updateProjections(null);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getPreferences().contains(event.getProperty())) {
            this.updateProjections(null);
        }
    }

    protected abstract Collection<ProjectionIdentifier> getAvailableProjections();

    protected abstract Collection<String> getLinktypesWhichTriggerUpdate();

    protected abstract Collection<Class<?>> getDatatypesWhichTriggerUpdate();

    protected abstract Set<String> getPreferences();

    protected abstract ProjectionIdentifier getProjectionIdentifierForHighlighting();

    protected abstract void doProject(ProjectionIdentifier var1, IProjectionReceiver var2, IWorkbenchPage var3);

    protected abstract void doStopProjection(IProjectionReceiver var1, IWorkbenchPage var2);

    public boolean canHandleProjection(ProjectionIdentifier projectionIdentifier) {
        return this.availableProjectionTypes.contains(projectionIdentifier.getProjectionID());
    }
}

