/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel;

import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel.Messages;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.DataPotEnumValue;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.importer.MappableDataPotDescription;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.lib.eclipse.adapter.excel.imports.ColumnDescription;
import com.arcway.lib.eclipse.adapter.excel.imports.GenericExcelListImporter;
import com.arcway.lib.eclipse.adapter.excel.imports.ImportedSheetType;
import com.arcway.lib.java.New;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMap_;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class ModuleExcelListImporter
extends GenericExcelListImporter {
    private static IMap_<String, ISet_<Integer>> allowedAttributeMappings = null;
    private static IMap_<String, IMap_<Integer, String>> warningsForMappings = null;

    private static void initializeAllowedAttributeMappings() {
        HashMap_ allowedAttributeMappings_ = new HashMap_(IHasher_.EQUALS_HASHER);
        allowedAttributeMappings_.put((Object)"MultiLineString", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(13), new Integer(10), new Integer(12), new Integer(9), new Integer(11)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings_.put((Object)"SingleLineString", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(13), new Integer(10), new Integer(12), new Integer(9), new Integer(11)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings_.put((Object)"Real", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(10), new Integer(12), new Integer(9), new Integer(11), new Integer(8), new Integer(5)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings_.put((Object)"Integer", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(10), new Integer(12), new Integer(9), new Integer(11), new Integer(8), new Integer(7), new Integer(5)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings_.put((Object)"Date", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(10), new Integer(12), new Integer(9), new Integer(11), new Integer(6)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings_.put((Object)"Boolean", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(10), new Integer(12), new Integer(9), new Integer(11), new Integer(3)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings_.put((Object)"Any", (Object)new HashSet_((Collection)New.hashSet((Object[])new Integer[]{new Integer(2), new Integer(1), new Integer(13), new Integer(10), new Integer(12), new Integer(9), new Integer(11), new Integer(8), new Integer(7), new Integer(5), new Integer(6), new Integer(3)}), IHasher_.EQUALS_HASHER));
        allowedAttributeMappings = allowedAttributeMappings_;
    }

    private static void initializeWarningsForMappings() {
        String multilineImportWarningMessage = Messages.getString("ModuleExcelListImporter.Warning.MultilineImportIntoSingleLineAttribute");
        HashMap_ warningsForMultilineStringImport = new HashMap_(IHasher_.EQUALS_HASHER);
        warningsForMultilineStringImport.put((Object)new Integer(1), (Object)multilineImportWarningMessage);
        warningsForMultilineStringImport.put((Object)new Integer(13), (Object)multilineImportWarningMessage);
        HashMap_ warningsForMappings_ = new HashMap_(IHasher_.EQUALS_HASHER);
        warningsForMappings_.put((Object)"MultiLineString", (Object)warningsForMultilineStringImport);
        warningsForMappings = warningsForMappings_;
    }

    public ModuleExcelListImporter(String applicationName) {
        super(applicationName);
    }

    public List<List<MappableDataPotDescription>> getDataPotDescriptions() {
        LinkedList<List<MappableDataPotDescription>> allDataPotDescriptions = new LinkedList<List<MappableDataPotDescription>>();
        for (ImportedSheetType sheetType : this.getSheetTypes()) {
            LinkedList<MappableDataPotDescription> dataPotDescriptionsForSheetType = new LinkedList<MappableDataPotDescription>();
            int index = 0;
            for (ColumnDescription columnDescription : sheetType.getColumnDescriptions()) {
                ArrayList<DataPotEnumValue> valueRange = new ArrayList<DataPotEnumValue>(columnDescription.getValueRange().size());
                for (String valueRangeElement : columnDescription.getValueRange()) {
                    valueRange.add(new DataPotEnumValue(valueRangeElement, valueRangeElement));
                }
                dataPotDescriptionsForSheetType.add(new MappableDataPotDescription((Object)columnDescription.getColumnKey(), columnDescription.getColumnDataType(), valueRange, columnDescription.getColumnName(), columnDescription.getColumnDataTypeName(), null, null));
                ++index;
            }
            allDataPotDescriptions.add(dataPotDescriptionsForSheetType);
        }
        return allDataPotDescriptions;
    }

    public static IMap_<String, ISet_<Integer>> getAllowedAttributeMappings() {
        if (allowedAttributeMappings == null) {
            ModuleExcelListImporter.initializeAllowedAttributeMappings();
        }
        return allowedAttributeMappings;
    }

    public static IMap_<String, IMap_<Integer, String>> getWarningsForMappings() {
        if (warningsForMappings == null) {
            ModuleExcelListImporter.initializeWarningsForMappings();
        }
        return warningsForMappings;
    }

    protected Collection<String> getAlternativeStringRepresentationsForFalse(Locale locale) {
        return Arrays.asList(ModuleDataAttributeBoolean.getStringRepresentationForFalse((Locale)locale), DataTypeBoolean.getSingleInstance().getValueAsSingleLineString((Object)Boolean.FALSE, null, null, locale));
    }

    protected Collection<String> getAlternativeStringRepresentationsForTrue(Locale locale) {
        return Arrays.asList(ModuleDataAttributeBoolean.getStringRepresentationForTrue((Locale)locale), DataTypeBoolean.getSingleInstance().getValueAsSingleLineString((Object)Boolean.TRUE, null, null, locale));
    }
}

