/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel;

import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel.ExcelFileSelectionWithMultiSheetOption;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel.Messages;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.util.ModuleFileSelectionPage;
import com.arcway.lib.eclipse.ole.excel.util.MSExcelVersionAndSettingsHelper;
import com.arcway.lib.memento.IArcwayMemento;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ExcelFileSelectionPageWithMultiSheetOption
extends ModuleFileSelectionPage {
    private final String parentDataName;
    private Button checkBox;
    private Boolean multiSheetOptionFromSettingsStore;
    private static final String SETTING_KEY_MULTISHEETOPTION = "excelFileSelectionPageWithMultisheetOption.multiSheetOption";

    public ExcelFileSelectionPageWithMultiSheetOption(String title, String parentDataName) {
        this(title, parentDataName, null);
    }

    public ExcelFileSelectionPageWithMultiSheetOption(String title, String parentDataName, String pageID) {
        super(title, Messages.getString("ExcelFileSelectionPageWithMultiSheetOption.Instruction"), Collections.singletonList(MSExcelVersionAndSettingsHelper.getInstalledVersionOfMSExcel() >= 12 ? "xlsx" : "xls"), false, true, false, pageID);
        this.parentDataName = parentDataName;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite baseComposite = (Composite)this.getControl();
        Composite singlePageOptionComposite = new Composite(baseComposite, 0);
        singlePageOptionComposite.setLayout((Layout)new GridLayout(2, false));
        singlePageOptionComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.checkBox = new Button(singlePageOptionComposite, 32);
        this.checkBox.setLayoutData((Object)new GridData(2, 2, false, false));
        this.checkBox.setSelection(true);
        StyledText label = new StyledText(singlePageOptionComposite, 0);
        label.setLayoutData((Object)new GridData(4, 2, true, false));
        label.setBackground(parent.getDisplay().getSystemColor(22));
        label.setText(NLS.bind((String)Messages.getString("ExcelFileSelectionPageWithMultiSheetOption.MultiSheetOption.Label"), (Object)this.parentDataName));
        if (this.multiSheetOptionFromSettingsStore != null) {
            this.checkBox.setSelection(this.multiSheetOptionFromSettingsStore.booleanValue());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.checkBox.setEnabled(enabled);
    }

    public boolean isMultiSheetOptionSelected() {
        return this.checkBox.getSelection();
    }

    public Object getParameter() {
        return new ExcelFileSelectionWithMultiSheetOption(this.getFileName(), this.isMultiSheetOptionSelected());
    }

    public void readSettings(IArcwayMemento settingsStore) {
        super.readSettings(settingsStore);
        Integer multiSheetOptionAsInteger = settingsStore.getInteger(SETTING_KEY_MULTISHEETOPTION);
        if (multiSheetOptionAsInteger != null) {
            this.multiSheetOptionFromSettingsStore = multiSheetOptionAsInteger == 2;
        }
    }

    public void storeSettings(IArcwayMemento settingsStore) {
        super.storeSettings(settingsStore);
        settingsStore.putInteger(SETTING_KEY_MULTISHEETOPTION, this.isMultiSheetOptionSelected() ? 2 : 1);
    }
}

