/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.issuemodule1migrator.dumps;

import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLinkDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOLink_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOProject_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.V0_EOFactory;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.EOModuleDataContainer_V0;
import com.arcway.cockpit.frame.client.project.migration.access_both.version0.modules.V0_EOFactory_ForModules;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_;
import com.arcway.cockpit.issuemodule1migrator.core.ISM1MigratorCore;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EOIssue;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EOIssueClientContainer;
import com.arcway.cockpit.issuemodule1migrator.core.messages.EONote;
import com.arcway.cockpit.issuemodule1migrator.core.messages.MessageDataFactory;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForBasicEOs;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collection;

public class ISM1Migrator_ForDumps {
    private static final String DATAFILE_NAME_ISM1 = "issues.xml";
    private static final String MODULE_ID_ISM1 = "ISM";

    public static void migrateProject(EOProject_V0 project, HistoricProjectDumpView_0_ historicViewOnDumpFile) throws MigrationFailedException {
        try {
            String projectUID = project.getProjectUID();
            EncodableObjectBase rootElement = historicViewOnDumpFile.readDataFile(project, DATAFILE_NAME_ISM1, MODULE_ID_ISM1, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{new MessageDataFactory(), MessageDataFactoryForBasicEOs.getDefault()}));
            if (rootElement == null) {
                return;
            }
            if (!(rootElement instanceof EOIssueClientContainer)) {
                throw new MigrationFailedException("Unexpected format of ISM1 data");
            }
            EOIssueClientContainer ism1Data = (EOIssueClientContainer)rootElement;
            EOList eoIssues = ism1Data.getIssues();
            EOList eoIssueNotes = ism1Data.getNotes();
            EOLinkDataContainer_V0 linkData = historicViewOnDumpFile.readLinks(project);
            if (linkData == null) {
                throw new MigrationFailedException("Can't read link data.");
            }
            ArrayList<EOLink_V0> oldIssueModelElementLinks = new ArrayList<EOLink_V0>();
            ArrayList<EOLink_V0> oldIssueNoteIssueLinks = new ArrayList<EOLink_V0>();
            for (EOLink_V0 link : linkData.getLinks()) {
                if ("LinkIssueUniqueElement".equals(link.getLinkTypeID())) {
                    oldIssueModelElementLinks.add(link);
                }
                if (!"LinkNoteIssue".equals(link.getLinkTypeID())) continue;
                oldIssueNoteIssueLinks.add(link);
            }
            ISM1MigratorCore ism1Migrator = new ISM1MigratorCore();
            ism1Migrator.migrateData((Collection<EOIssue>)eoIssues, (Collection<EONote>)eoIssueNotes, oldIssueModelElementLinks, oldIssueNoteIssueLinks, projectUID);
            EOList moduleData = (EOList)historicViewOnDumpFile.readDataFile(project, "cmm_data.xml", "cmm", (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{V0_EOFactory_ForModules.getDefault(), V0_EOFactory.getDefault(), MessageDataFactoryForBasicEOs.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
            EOModuleDataContainer_V0 issueSetContainer = new EOModuleDataContainer_V0();
            issueSetContainer.setDataTypeUID("com.arcway.cockpit.genericmodule.issuemodule2.issueSet");
            issueSetContainer.setModuleDataItems(new EOList(ism1Migrator.getIssueSets()));
            moduleData.add((EncodableObjectBase)issueSetContainer);
            EOModuleDataContainer_V0 issueContainer = new EOModuleDataContainer_V0();
            issueContainer.setDataTypeUID("com.arcway.cockpit.genericmodule.issuemodule2.issue");
            issueContainer.setModuleDataItems(new EOList(ism1Migrator.getMigratedIssues()));
            moduleData.add((EncodableObjectBase)issueContainer);
            EOModuleDataContainer_V0 issueNoteContainer = new EOModuleDataContainer_V0();
            issueNoteContainer.setDataTypeUID("com.arcway.cockpit.genericmodule.issuemodule2.issueNote");
            issueNoteContainer.setModuleDataItems(new EOList(ism1Migrator.getMigratedIssueNotes()));
            moduleData.add((EncodableObjectBase)issueNoteContainer);
            linkData.getLinks().removeAll(ism1Migrator.getLinksToBeDeleted());
            linkData.getLinks().addAll(ism1Migrator.getNewLinks());
            boolean success = historicViewOnDumpFile.writeDataFile(project, "cmm_data.xml", "cmm", (EncodableObjectBase)moduleData);
            if (!success) {
                throw new MigrationFailedException("Can't write back migrated issue data.");
            }
            historicViewOnDumpFile.deleteDataDirectory(project, MODULE_ID_ISM1);
        }
        catch (EXDecoderException e) {
            throw new MigrationFailedException((Throwable)e);
        }
    }
}

