/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenIDFormatAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.StatusHelper;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeBoolean;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeIDFormat;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeString;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.resources.IIconResource;
import java.util.Locale;

public class GenericModuleData
extends AbstractModuleData
implements IPermissionOperand {
    private static final ILogger logger = Logger.getLogger(GenericModuleData.class);
    public static final String ACTION_FILTER_ATTRIBUTE_MODULEID = "moduleID";
    public static final String ACTION_FILTER_ATTRIBUTE_OBJECTTYPEID = "objectTypeID";
    private String moduleID;
    private ObjectType objectTypeSpecification;

    public GenericModuleData(String moduleID, ObjectType objectTypeSpecification) {
        this(moduleID, objectTypeSpecification, false);
    }

    public GenericModuleData(String moduleID, ObjectType objectTypeSpecification, boolean doNotInheritParentIDFormat) {
        this.init(moduleID, objectTypeSpecification, doNotInheritParentIDFormat);
    }

    public GenericModuleData(EOModuleData eo, String moduleID, ObjectType objectTypeSpecification) {
        this.init(moduleID, objectTypeSpecification, false);
        this.fillWithEncodableObject(eo);
    }

    private void init(String moduleID_, ObjectType objectTypeSpecification_, boolean doNotInheritParentIDFormat) {
        IModuleDataAttribute mdAttribute;
        this.moduleID = moduleID_;
        this.objectTypeSpecification = objectTypeSpecification_;
        for (IDAttribute iDAttribute : this.objectTypeSpecification.getAttributeListOfType(IDAttribute.class)) {
            mdAttribute = AttributeHelper.createModuleDataAttribute("datatype_mda_string_single", true);
            if (mdAttribute == null) {
                logger.warn("Unknown attribute data type: object type: " + objectTypeSpecification_.getObjectTypeID() + " / attribute id: " + iDAttribute.getAttributeID() + " / attribute data type: id attribute");
            }
            this.moduleAttributes.put(iDAttribute.getAttributeID(), mdAttribute);
        }
        for (SimpleAttribute simpleAttribute : this.objectTypeSpecification.getAttributeListOfType(SimpleAttribute.class)) {
            mdAttribute = AttributeHelper.createModuleDataAttribute(simpleAttribute.getAttributeDataType(), simpleAttribute.isMandatory());
            if (mdAttribute == null) {
                logger.warn("Unknown attribute data type: object type: " + objectTypeSpecification_.getObjectTypeID() + " / attribute id: " + simpleAttribute.getAttributeID() + " / attribute data type: " + simpleAttribute.getAttributeDataType());
            }
            this.moduleAttributes.put(simpleAttribute.getAttributeID(), mdAttribute);
        }
        for (ChildrenIDFormatAttribute childrenIDFormatAttribute : this.objectTypeSpecification.getAttributeListOfType(ChildrenIDFormatAttribute.class)) {
            this.moduleAttributes.put(String.valueOf(childrenIDFormatAttribute.getAttributeID()) + "-overrideparentsettings", new ModuleDataAttributeBoolean(doNotInheritParentIDFormat));
            this.moduleAttributes.put(String.valueOf(childrenIDFormatAttribute.getAttributeID()) + "-usedefaultprefix", new ModuleDataAttributeBoolean(true));
            this.moduleAttributes.put(String.valueOf(childrenIDFormatAttribute.getAttributeID()) + "-prefix", new ModuleDataAttributeString(1));
            this.moduleAttributes.put(String.valueOf(childrenIDFormatAttribute.getAttributeID()) + "-pattern", new ModuleDataAttributeDiscrete(AttributeHelper.VALUENAMES_CHILDRENIDFORMAT_PATTERNS, 2));
        }
        for (EnumerationAttribute enumerationAttribute : this.objectTypeSpecification.getAttributeListOfType(EnumerationAttribute.class)) {
            mdAttribute = AttributeHelper.createModuleDataAttributeDiscrete(enumerationAttribute, moduleID_);
            this.moduleAttributes.put(enumerationAttribute.getAttributeID(), mdAttribute);
        }
    }

    public String getDisplayRepresentation() {
        if (!this.objectTypeSpecification.getLabelAttributeID().equals("none")) {
            return this.getAttribute(this.objectTypeSpecification.getLabelAttributeID()).getDisplayStringRepresentation();
        }
        return this.getTypeDescription().getTypeName(Locale.getDefault());
    }

    public String getDisplayRepresentation(Locale locale) {
        if (!this.objectTypeSpecification.getLabelAttributeID().equals("none")) {
            return this.getAttribute(this.objectTypeSpecification.getLabelAttributeID()).getDisplayStringRepresentation(locale);
        }
        return this.getTypeDescription().getTypeName(locale);
    }

    public void setDisplayRepresentation(String displayRepresentation) {
        if (!this.objectTypeSpecification.getLabelAttributeID().equals("none")) {
            this.getAttribute(this.objectTypeSpecification.getLabelAttributeID()).setValueViaDisplayStringRepresentation(displayRepresentation);
        } else assert (false);
    }

    public String getStatus() {
        String status = StatusHelper.getStatus(this.objectTypeSpecification, this);
        if (status == null) {
            status = "MD_STATUS_DEFAULT";
        }
        return status;
    }

    public IIconResource getStatusDependentIconDecorator() {
        IIconResource icon = StatusHelper.getStatusDependentIconDecoratorForObject(this.moduleID, this.objectTypeSpecification, this);
        return icon;
    }

    public IIconResource getAttributeIcon(String attributeID) {
        return StatusHelper.getStatusDependentIconForAttribute(this.moduleID, this.objectTypeSpecification, attributeID, this);
    }

    protected final IModuleDataTypeDescription getTypeDescription_internal() {
        return GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, this.objectTypeSpecification, false);
    }

    public boolean isIsomorphic(IModuleData item) {
        return this.getDisplayRepresentation().equals(item.getDisplayRepresentation());
    }

    public String getGenericModuleID() {
        return this.moduleID;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (name.equals(ACTION_FILTER_ATTRIBUTE_MODULEID)) {
            return this.moduleID.equals(value);
        }
        if (name.equals(ACTION_FILTER_ATTRIBUTE_OBJECTTYPEID)) {
            return this.objectTypeSpecification.getObjectTypeID().equals(value);
        }
        return super.testAttribute(target, name, value);
    }

    public IModuleDataAttribute getAttribute(String role) {
        Attribute attribute = this.objectTypeSpecification.getAttribute(role);
        if (attribute instanceof ChildrenIDFormatAttribute) {
            return new ModuleDataAttributeIDFormat((ModuleDataAttributeBoolean)this.moduleAttributes.get(String.valueOf(((ChildrenIDFormatAttribute)attribute).getAttributeID()) + "-overrideparentsettings"), (ModuleDataAttributeBoolean)this.moduleAttributes.get(String.valueOf(((ChildrenIDFormatAttribute)attribute).getAttributeID()) + "-usedefaultprefix"), (ModuleDataAttributeString)this.moduleAttributes.get(String.valueOf(((ChildrenIDFormatAttribute)attribute).getAttributeID()) + "-prefix"), (ModuleDataAttributeDiscrete)this.moduleAttributes.get(String.valueOf(((ChildrenIDFormatAttribute)attribute).getAttributeID()) + "-pattern"));
        }
        return super.getAttribute(role);
    }

    protected IModuleDataAttribute getCalculatedAttribute(String role) {
        Attribute attribute = this.objectTypeSpecification.getAttribute(role);
        return AttributeHelper.calculateAttribute((IModuleData)this, (CalculatedAttribute)attribute);
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getPermissionOperandType() {
        return this.getTypeID();
    }

    public String getPermissionOperandDisplayName() {
        return this.getDisplayRepresentation();
    }
}

