/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.messages;

import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ParentType;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.modulelib2.client.messages.DataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper_Core;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class GMDataTypesHelper
implements IDataTypesHelper_Core {
    private static final Map<String, IDataTypesHelper> singletons = new HashMap<String, IDataTypesHelper>();
    private final Collection<String> administrativeDataTypes = new HashSet<String>();
    private final Collection<String> documentationDataTypes = new HashSet<String>();
    private final Collection<String> virtualDataTypes = new HashSet<String>();
    private final SetMap<String, String> map_childTypeID_parentTypeIDs = new SetMap();
    private final Map<String, IModuleDataTypeDescription> map_typeID_typeDescription = new HashMap<String, IModuleDataTypeDescription>();

    public static IDataTypesHelper getDefault(String moduleID) {
        IDataTypesHelper singleton = singletons.get(moduleID);
        if (singleton == null) {
            singleton = new DataTypesHelper((IDataTypesHelper_Core)new GMDataTypesHelper(moduleID));
            singletons.put(moduleID, singleton);
        }
        return singleton;
    }

    private GMDataTypesHelper(String moduleID) {
        this.construct(moduleID);
    }

    private void construct(String moduleID) {
        ModuleDataSpecification dataSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID).getModuleDataSpecification();
        for (ObjectType objectType : dataSpecification.getObjectTypeList()) {
            boolean isAdministrative = false;
            String dataTypeID = ClientDataFactory_TypesHelper.getDataTypeID(moduleID, objectType.getObjectTypeID());
            for (ParentType parentType : objectType.getParentTypeList()) {
                if (parentType.getParentObjectTypeID().equals("noparent")) {
                    isAdministrative = true;
                    continue;
                }
                if (parentType.getParentObjectTypeID().equals("hierarchyroot")) {
                    this.map_childTypeID_parentTypeIDs.add((Object)dataTypeID, (Object)"hierarchyroot");
                    continue;
                }
                this.map_childTypeID_parentTypeIDs.add((Object)dataTypeID, (Object)ClientDataFactory_TypesHelper.getDataTypeID(moduleID, parentType.getParentObjectTypeID()));
            }
            if (isAdministrative) {
                this.administrativeDataTypes.add(dataTypeID);
            } else {
                this.documentationDataTypes.add(dataTypeID);
            }
            GenericModuleDataTypeDescription typeDescription = GenericModuleDataTypeDescription.getTypeDescription(moduleID, objectType);
            this.map_typeID_typeDescription.put(dataTypeID, (IModuleDataTypeDescription)typeDescription);
            IModuleDataTypeDescriptionForFrame naturalOrderTypeDescription = typeDescription.getDataTypeForNaturalOrdering();
            this.virtualDataTypes.add(naturalOrderTypeDescription.getCockpitDataTypeID());
        }
        this.virtualDataTypes.removeAll(this.administrativeDataTypes);
        this.virtualDataTypes.removeAll(this.documentationDataTypes);
    }

    public Collection<String> getAdministrativeDataTypes() {
        return this.administrativeDataTypes;
    }

    public Collection<String> getDocumentationDataTypes() {
        return this.documentationDataTypes;
    }

    public Collection<String> getVirtualDataTypes() {
        return this.virtualDataTypes;
    }

    public Collection<String> getParentTypeIDs(String childTypeID) {
        return this.map_childTypeID_parentTypeIDs.get((Object)childTypeID);
    }

    public IModuleDataTypeDescription getTypeDescription(String typeID) {
        return this.map_typeID_typeDescription.get(typeID);
    }
}

