/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure;

import com.arcway.cockpit.genericmodule.client.infrastructure.specification.AbstractModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.IModuleSpecificationPart;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Condition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Status
extends AbstractModuleSpecificationPart {
    private final String statusID;
    private final Map<String, Condition> conditionMap;
    private final List<Condition> conditionList;

    public Status(String statusID, List<Condition> conditionList) {
        this.statusID = statusID;
        this.conditionMap = new HashMap<String, Condition>();
        this.conditionList = new ArrayList<Condition>();
        int conditionListCounter = 1;
        for (Condition part : conditionList) {
            part.setIndex(conditionListCounter);
            String partID = part.getID();
            this.conditionMap.put(partID, part);
            this.conditionList.add(part);
            ++conditionListCounter;
        }
    }

    public String getStatusID() {
        return this.statusID;
    }

    public List<Condition> getConditionList() {
        return this.conditionList;
    }

    public Condition getCondition(String id) {
        return this.conditionMap.get(id);
    }

    public Condition getCondition(int index) {
        return this.getConditionList().get(index);
    }

    @Override
    public String getID() {
        return this.statusID;
    }

    @Override
    public List<IModuleSpecificationPart> getChildren() {
        ArrayList<IModuleSpecificationPart> children = new ArrayList<IModuleSpecificationPart>();
        children.addAll(this.getConditionList());
        return children;
    }

    @Override
    public String getTypeID() {
        return "Status";
    }
}

