/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.genericmodule.client.GenericModulePlugin;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.licensetypes.ClientFunctionLicenseTypeGMModifyItems;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionManager;
import com.arcway.cockpit.genericmodule.client.gui.actions.GenericModuleAction;
import com.arcway.cockpit.genericmodule.client.infrastructure.ResourceConstants;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.Messages;
import com.arcway.cockpit.genericmodule.client.infrastructure.resources.ResourceManager;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationLabelHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.IActionRunNotifier;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.itemeditors.ItemEditorManager;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class ActionNewRootItem
extends GenericModuleAction
implements IActionRunNotifier {
    private final String moduleID;
    private final ObjectType objectType;
    private IModelController modelCtrl;

    public ActionNewRootItem(String moduleID, ObjectType objectType) {
        this.moduleID = moduleID;
        this.objectType = objectType;
        String label = SpecificationLabelHelper.getLabel(objectType.getObjectTypeName());
        if (ClientDataFactory_TypesHelper.isHierarchyType(objectType) && objectType.getParentTypeList().size() > 1) {
            label = String.valueOf(label) + " " + Messages.getString("ActionNewRootItem.Label.Root");
        }
        label = String.valueOf(label) + "...";
        String tooltip = String.valueOf(Messages.getString("ActionNewRootItem.Tooltip.Pre")) + " " + SpecificationLabelHelper.getLabel(objectType.getObjectTypeName()) + " " + Messages.getString("ActionNewRootItem.Tooltip.Post");
        ImageDescriptor imageDescriptor = null;
        if (objectType.getObjectTypeIcon() != null && objectType.getObjectTypeIcon().length() > 0) {
            imageDescriptor = ResourceManager.getDefault().getImageDescriptor(moduleID, ResourceConstants.getDecoratedImageFilename(objectType.getObjectTypeIcon(), "new_decorator.gif", 1), true);
        }
        this.setText(label);
        this.setToolTipText(tooltip);
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
        this.setEnabled(false);
    }

    protected void handleProjectChanged(String projectUID) {
        boolean hasPermission = false;
        this.modelCtrl = GenericModulePlugin.getDefault().getProjectManager(this.moduleID).getModelController(projectUID);
        if (this.modelCtrl != null) {
            PermissionManager permissionMgr = (PermissionManager)this.modelCtrl.getPermissionMgr();
            hasPermission = permissionMgr.mayCreateRootItemsOfType(this.objectType.getObjectTypeID());
        }
        this.setEnabled(hasPermission);
    }

    public <T> void modelRefreshed(IPropertyChanges<T> changes, Class<T> clazz) {
        assert (clazz != null);
        assert (changes != null);
        if (this.modelCtrl != null) {
            this.projectSwitched(this.modelCtrl.getProjectUID());
        }
    }

    public void run() {
        ItemEditorManager.openEditorForCreatingRootItem((IModelController)this.modelCtrl, (String)ModuleIdentification.getModuleIDForPlatform(this.moduleID), (String)ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, this.objectType.getObjectTypeID()), (Collection)Collections.EMPTY_LIST);
        this.notifyRunListeners();
    }

    protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeGMModifyItems.getInstance(this.moduleID);
    }

    @Override
    protected String getModuleID() {
        return this.moduleID;
    }
}

