/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.permissions;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.project.core.permissions.ProjectPermissionChecker;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionConstants;
import com.arcway.cockpit.genericmodule.client.core.permissions.PermissionTemplateProvider;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PermissionManager
extends AbstractPermissionMgr
implements IPropertyChangesListener {
    private PermissionTemplateProvider permissionTemplateProvider;
    private IPermissionOperandTreeContentProvider permissionOperandTree;
    private PropertyChangesManager propertyChangesManager;

    public void construct(PropertyChangesManager propertyChangesManager_, AbstractPermissionTemplateProvider permissionTemplateProvider_, IModuleProjectAgent projectP, AbstractDataMgr dataMgrP) {
        super.construct(propertyChangesManager_, permissionTemplateProvider_, projectP, dataMgrP);
        this.permissionTemplateProvider = (PermissionTemplateProvider)permissionTemplateProvider_;
        this.permissionOperandTree = permissionTemplateProvider_.getTreeContentProvider(projectP);
        this.propertyChangesManager = propertyChangesManager_;
        this.propertyChangesManager.registerPropertyChangesListener((IPropertyChangesListener)this, IAttributeType.class);
    }

    private ProjectPermissionChecker.CurrentUserInfo getCurrentUserInfoForComplexPermissionCheck() {
        return this.getProjectAgent().getModulePermissionChecker().getCurrentUserInfoForComplexPermissionCheck();
    }

    public boolean mayCreateChildItemsBelow(GenericModuleData item, String childObjectTypeID) {
        String operationTypeID = PermissionConstants.getOperationType_CreateChild(childObjectTypeID);
        return this.checkPermissionRecursively_adv(this.getProjectAgent(), item, operationTypeID, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    public boolean mayCreateRootItemsOfType(String rootObjectTypeID) {
        String operationTypeID = PermissionConstants.getOperationType_CreateChild(rootObjectTypeID);
        return this.checkPermissionRecursively_adv(this.getProjectAgent(), PermissionConstants.TREE_ROOT_NODE, operationTypeID, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    public boolean mayEditStructurally(GenericModuleData item) {
        return this.mayEditStructurally_adv(item, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    private boolean mayEditStructurally_adv(GenericModuleData item, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        if (this.getDataMgr().isNew((ICockpitProjectData)item)) {
            return true;
        }
        String operationTypeID = PermissionConstants.getOperationType_EditItem(ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID()));
        return this.checkPermissionRecursively_adv(this.getProjectAgent(), item, operationTypeID, currentUserInfo);
    }

    public boolean mayEditContainedItemsStructurally(GenericModuleData parent, String childrenCockpitTypeID) {
        if (this.getDataMgr().isNew((ICockpitProjectData)parent)) {
            return true;
        }
        String operationTypeID = PermissionConstants.getOperationType_EditItem(ClientDataFactory_TypesHelper.getShortTypeID(childrenCockpitTypeID));
        return this.checkPermissionRecursively_adv(this.getProjectAgent(), parent, operationTypeID, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    public boolean mayDelete(GenericModuleData item) {
        return this.mayDelete_adv(item, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    private boolean mayDelete_adv(GenericModuleData item, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        if (this.getDataMgr().isNew((ICockpitProjectData)item)) {
            return true;
        }
        HashSet<String> checkedTypes = new HashSet<String>();
        checkedTypes.add(item.getTypeID());
        return this.mayEditStructurally_adv(item, currentUserInfo) && this.mayDeleteSubItems_adv(item, checkedTypes, currentUserInfo);
    }

    private boolean mayDeleteSubItems_adv(GenericModuleData item, Set<String> checkedTypes, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        Collection childItems = this.getDataMgr().getChildren((IModuleData)item);
        Iterator iterator = childItems.iterator();
        while (iterator.hasNext()) {
            HashSet<String> checkedTypesForCurrentItem = new HashSet<String>(checkedTypes);
            IModuleData childItem = (IModuleData)iterator.next();
            GenericModuleData gmChildItem = (GenericModuleData)childItem;
            if (!checkedTypesForCurrentItem.contains(gmChildItem.getTypeID())) {
                if (!this.mayEditStructurally_adv(gmChildItem, currentUserInfo)) {
                    return false;
                }
                checkedTypesForCurrentItem.add(gmChildItem.getTypeID());
            }
            if (this.mayDeleteSubItems_adv(gmChildItem, new HashSet<String>(checkedTypesForCurrentItem), currentUserInfo)) continue;
            return false;
        }
        return true;
    }

    public boolean mayDeleteItem(IModuleData moduleData) {
        if (moduleData instanceof GenericModuleData) {
            return this.mayDelete_adv((GenericModuleData)moduleData, this.getCurrentUserInfoForComplexPermissionCheck());
        }
        return false;
    }

    public boolean mayDelete(Collection<? extends IModuleData> items) {
        assert (items != null);
        for (IModuleData iModuleData : items) {
            if (iModuleData instanceof GenericModuleData) {
                if (this.mayDelete_adv((GenericModuleData)iModuleData, this.getCurrentUserInfoForComplexPermissionCheck())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean mayLinkItemToPlanElement(String linkableItemTypeID, IModuleData permissionOperand) {
        return true;
    }

    public boolean mayAdministrateLinkedModuleDataAttributeValueRange(String objectTypeID) {
        String operationTypeID = PermissionConstants.getOperationType_AdministrateType(objectTypeID);
        return this.checkPermissionRecursively_adv(this.getProjectAgent(), PermissionConstants.GENERAL_ROOT_NODE, operationTypeID, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    private boolean checkPermissionRecursively_adv(IModuleProjectAgent projectAgent, IPermissionOperand permissionTreeLeaveItem, String operationTypeID, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        if (permissionTreeLeaveItem == null) {
            return false;
        }
        return this.checkPermissionRecursively_adv(projectAgent, permissionTreeLeaveItem, operationTypeID, false, currentUserInfo);
    }

    private boolean checkPermissionRecursively_adv(IModuleProjectAgent projectAgent, IPermissionOperand permissionOperand, String operationTypeID, boolean foundPermissionOperandWithMatchingTemplate_, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        if (permissionOperand == null) {
            return !foundPermissionOperandWithMatchingTemplate_;
        }
        boolean foundPermissionOperandWithMatchingTemplate = foundPermissionOperandWithMatchingTemplate_;
        if (this.permissionTemplateProvider.isTemplateDefined(projectAgent, permissionOperand, operationTypeID, null)) {
            foundPermissionOperandWithMatchingTemplate = true;
            if (this.getProjectAgent().getModulePermissionChecker().hasPermission_adv(operationTypeID, null, permissionOperand, currentUserInfo)) {
                return true;
            }
        }
        return this.checkPermissionRecursively_adv(projectAgent, this.permissionOperandTree.getParent(permissionOperand), operationTypeID, foundPermissionOperandWithMatchingTemplate, currentUserInfo);
    }

    public boolean mayEditItemStructurally(IModuleData moduleData, IModuleData parent) {
        assert (moduleData instanceof GenericModuleData);
        return this.mayEditStructurally((GenericModuleData)moduleData);
    }

    public boolean mayCreateChildren(IModuleData parent, String childDataType) {
        assert (parent == null || parent instanceof GenericModuleData);
        if (parent != null) {
            return this.mayCreateChildItemsBelow((GenericModuleData)parent, ClientDataFactory_TypesHelper.getShortTypeID(childDataType));
        }
        return this.mayCreateRootItemsOfType(ClientDataFactory_TypesHelper.getShortTypeID(childDataType));
    }

    public boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, IAttributeType type) {
        if (this.checkForAttributeModificationPermissionDefinitionRecursively((GenericModuleData)moduleData, (GenericModuleData)parent)) {
            return super.mayEditAttribute(moduleData, parent, type);
        }
        return true;
    }

    public boolean mayEditAttribute(IModuleData moduleData, IModuleData parent, String attributeType) {
        if (this.checkForAttributeModificationPermissionDefinitionRecursively((GenericModuleData)moduleData, (GenericModuleData)parent)) {
            return super.mayEditAttribute(moduleData, parent, attributeType);
        }
        return true;
    }

    public boolean mayEditAttribute(IModuleData moduleData, String attributeType) {
        if (this.checkForAttributeModificationPermissionDefinitionRecursively((GenericModuleData)moduleData, (GenericModuleData)null)) {
            return super.mayEditAttribute(moduleData, attributeType);
        }
        return true;
    }

    private boolean checkForAttributeModificationPermissionDefinitionRecursively(GenericModuleData item, GenericModuleData parent) {
        if (this.getDataMgr().itemExists((Object)item.getUID(), (Object)item.getTypeID())) {
            return this.checkForAttributeModificationPermissionDefinitionRecursively((IPermissionOperand)item, item.getTypeID());
        }
        if (parent != null) {
            return this.checkForAttributeModificationPermissionDefinitionRecursively((IPermissionOperand)parent, item.getTypeID());
        }
        return this.checkForAttributeModificationPermissionDefinitionRecursively(PermissionConstants.TREE_ROOT_NODE, item.getTypeID());
    }

    private boolean checkForAttributeModificationPermissionDefinitionRecursively(IPermissionOperand permissionOperand, String cockpitTypeID) {
        if (permissionOperand == null) {
            return false;
        }
        if (this.permissionTemplateProvider.isTemplateDefined(this.getProjectAgent(), permissionOperand, "modifyAllAttributes", cockpitTypeID)) {
            return true;
        }
        return this.checkForAttributeModificationPermissionDefinitionRecursively(this.permissionOperandTree.getParent(permissionOperand), cockpitTypeID);
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        this.permissionTemplateProvider.clearPermissionTemplatesCache();
    }

    public void projectClosed() {
        this.propertyChangesManager.deregisterPropertyChangesListener((IPropertyChangesListener)this);
        super.projectClosed();
    }

    public boolean mayLinkItem(IModuleData item, String relationLinkTypeID, int relationContributionIndex) {
        assert (item instanceof GenericModuleData);
        return this.mayLinkItem_adv((GenericModuleData)item, relationLinkTypeID, relationContributionIndex, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    public boolean mayLinkItem_adv(GenericModuleData item, String relationLinkTypeID, int relationContributionIndex, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        if (this.getDataMgr().isNew((ICockpitProjectData)item)) {
            return true;
        }
        String relationContributionID = Integer.toString(relationContributionIndex);
        String linkableObjectOperationTypeID = PermissionConstants.getOperationType_AdministrateRelationContribution(relationLinkTypeID, relationContributionID);
        boolean hasLinkPermission = this.checkPermissionRecursively_adv(this.getProjectAgent(), item, linkableObjectOperationTypeID, currentUserInfo);
        if (hasLinkPermission) {
            return true;
        }
        return this.mayEditStructurally(item);
    }

    public boolean mayLinkItems(Collection<GenericModuleData> srcItems_moduleDatas, GenericModuleData targetItem_linkableObject, String relationLinkTypeID) {
        return this.mayLinkItems_adv(srcItems_moduleDatas, targetItem_linkableObject, relationLinkTypeID, this.getCurrentUserInfoForComplexPermissionCheck());
    }

    private boolean mayLinkItems_adv(Collection<GenericModuleData> srcItems_moduleDatas, GenericModuleData targetItem_linkableObject, String relationLinkTypeID, ProjectPermissionChecker.CurrentUserInfo currentUserInfo) {
        boolean linkableObjectPermitted = this.mayLinkItem_adv(targetItem_linkableObject, relationLinkTypeID, 1, currentUserInfo);
        if (!linkableObjectPermitted) {
            return false;
        }
        for (GenericModuleData srcItem_moduleData : srcItems_moduleDatas) {
            boolean moduleDataPermitted;
            if (this.getDataMgr().isNew((ICockpitProjectData)srcItem_moduleData) || (moduleDataPermitted = this.mayLinkItem_adv(srcItem_moduleData, relationLinkTypeID, 0, currentUserInfo))) continue;
            return false;
        }
        return true;
    }
}

