/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.core.datamanagement;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.GMLinkTypeHelper_Shared;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataManager;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ImExGenericModuleData;
import com.arcway.cockpit.genericmodule.client.gui.AttributeUIHelper;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenIDFormatAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.IDAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedFrameDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataRelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.RelationType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.SimpleAttribute;
import com.arcway.cockpit.genericmodule.client.messages.AttributeHelper;
import com.arcway.cockpit.genericmodule.client.messages.GenericModuleData;
import com.arcway.cockpit.genericmodule.client.messages.description.GenericModuleDataTypeDescription;
import com.arcway.cockpit.genericmodule.client.messages.description.NaturalOrderDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.dataexchange.ExValue;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttribute;
import com.arcway.cockpit.modulelib2.client.messages.attributes.IModuleDataAttributeDiscrete;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.lib.java.collections.CollectionUtils;
import de.plans.lib.util.valueranges.DiscreteValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DataFacade
extends AbstractDataFacade {
    static final String CHILDRENIDPREFIX_ATTRIBUTEID_PREFIX = "childrenIDPrefix-";
    private final String moduleID;
    private final ModuleSpecification moduleSpecification;
    private DataManager concreteDataManager;
    private IClientDataFactory clientDataFactory;
    public static final int SORTING_DIRECTION_ASCENDING = 1;
    public static final int SORTING_DIRECTION_DESCENDING = -1;

    public DataFacade(String moduleID_, ModuleSpecification moduleSpecification_) {
        this.moduleID = moduleID_;
        this.moduleSpecification = moduleSpecification_;
    }

    public void construct(IModel dataManager_, IModelController modelController_, IClientDataFactory clientDataFactory_) {
        super.construct(dataManager_, modelController_, this.clientDataFactory);
        this.concreteDataManager = (DataManager)dataManager_;
        this.clientDataFactory = clientDataFactory_;
    }

    public List<? extends IAttributeType> getUserDefinedAttributesForObjectType(String objectTypeID) {
        IModuleUserDefinedAttributeTypesManager customPropertyTypesManager = this.modelController.getProjectAgent().getModuleUserDefinedAttributeTypesManager();
        return customPropertyTypesManager.getSortedAttributeTypes(ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID));
    }

    public Collection<ImExGenericModuleData> getAllObjects(String objectTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID);
        Collection<IModuleData> items = this.concreteDataManager.getAllItems(cockpitTypeID);
        return this.getFilteredExportableItems(items, filters, locale);
    }

    public ImExGenericModuleData getObjectByUID(String objectTypeID, String uid, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID);
        IModuleData item = this.concreteDataManager.getItem(cockpitTypeID, uid);
        if (item == null) {
            return null;
        }
        return this.getExportableItem((GenericModuleData)item, null, locale);
    }

    public int[] getCommitCountsOfAllVersions(String objectTypeID, String uid) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID);
        IModuleData item = this.concreteDataManager.getItem(cockpitTypeID, uid);
        if (item == null) {
            return null;
        }
        List versionsOfItem = this.concreteDataManager.getVersionsOfItem(item);
        int[] commitCountsOfAllVersions = new int[versionsOfItem.size()];
        int i = 0;
        for (IModuleData versionOfItem : versionsOfItem) {
            commitCountsOfAllVersions[i] = versionOfItem.getCommitCount();
            ++i;
        }
        return commitCountsOfAllVersions;
    }

    public List<ImExGenericModuleData> getAllRootObjects(String objectTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID);
        ArrayList<IModuleData> items = new ArrayList<IModuleData>(this.concreteDataManager.getAllItems(cockpitTypeID));
        Collection filteredItems = DataFacade.filter(items, filters);
        LinkedList<GenericModuleData> filteredRootItems = new LinkedList<GenericModuleData>();
        for (IModuleData filteredItem : filteredItems) {
            GenericModuleData item = (GenericModuleData)filteredItem;
            GenericModuleData parent = (GenericModuleData)this.concreteDataManager.getParent((IModuleData)item);
            if (parent != null && !DataFacade.filter(Collections.singleton(parent), filters).isEmpty()) continue;
            filteredRootItems.add(item);
        }
        this.sortByNaturalOrder(filteredRootItems);
        return this.getFilteredExportableItems(filteredRootItems, null, locale);
    }

    public ImExGenericModuleData getParentObject(ImExGenericModuleData item, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(cockpitTypeID, item.internalIdentifier);
        GenericModuleData parent = (GenericModuleData)this.concreteDataManager.getParent((IModuleData)realItem);
        if (parent != null) {
            return this.getExportableItem(parent, filters, locale);
        }
        return null;
    }

    public List<ImExGenericModuleData> getChildObjects(ImExGenericModuleData item, String objectTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String parentCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        String childrenCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(parentCockpitTypeID, item.internalIdentifier);
        ArrayList<IModuleData> children = new ArrayList<IModuleData>(this.concreteDataManager.getChildren((IModuleData)realItem, childrenCockpitTypeID));
        this.sortByNaturalOrder(children);
        return this.getFilteredExportableItems(children, filters, locale);
    }

    public List<ImExGenericModuleData> getChildObjects(ImExGenericModuleData item, int typeRank, Collection<AbstractFilter> filters, Locale locale) {
        String parentCockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        String childrenCockpitTypeID = NaturalOrderDataTypeDescriptionForFrame.getNaturalOrderDataTypeCockpitTypeID(this.moduleID, typeRank);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(parentCockpitTypeID, item.internalIdentifier);
        ArrayList<IModuleData> children = new ArrayList<IModuleData>(this.concreteDataManager.getChildren((IModuleData)realItem, childrenCockpitTypeID));
        this.sortByNaturalOrder(children);
        return this.getFilteredExportableItems(children, filters, locale);
    }

    public List<ImExGenericModuleData> getAncestorObjects(ImExGenericModuleData item, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(cockpitTypeID, item.internalIdentifier);
        return this.getFilteredExportableItems(this.concreteDataManager.getAllAscendants((IModuleData)realItem), filters, locale);
    }

    public Collection<ImExGenericModuleData> getRelatedLOObjects(ImExGenericModuleData item, String relationTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getRelationLinkTypeID(relationTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(cockpitTypeID, item.internalIdentifier);
        Collection linkedItems = this.concreteDataManager.getLinkableObjects((IModuleData)realItem, linkTypeID);
        return this.getFilteredExportableItems(CollectionUtils.getTypedCollection((Collection)linkedItems, IModuleData.class), filters, locale);
    }

    public Collection<ImExGenericModuleData> getRelatedMDObjects(ImExGenericModuleData item, String relationTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getRelationLinkTypeID(relationTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(cockpitTypeID, item.internalIdentifier);
        Collection linkedItems = this.concreteDataManager.getModuleData((IModuleData)realItem, linkTypeID);
        return this.getFilteredExportableItems(linkedItems, filters, locale);
    }

    public List<ImExGenericModuleData> getItemsForModelElement(String modelElementUID, String objectTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getModelElementLinkTypeID_forShortTypeID(objectTypeID);
        Collection linkedItems = this.concreteDataManager.getModuleData(modelElementUID, linkTypeID);
        return this.getFilteredExportableItems(linkedItems, filters, locale);
    }

    public List<ImExGenericModuleData> getItemsNotLinkedToAnyModelElement(String objectTypeID, Collection<AbstractFilter> filters, Locale locale) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, objectTypeID);
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getModelElementLinkTypeID_forShortTypeID(objectTypeID);
        Collection<IModuleData> unlinkedItems = this.concreteDataManager.getAllItems(cockpitTypeID);
        unlinkedItems.removeAll(this.concreteDataManager.getAllModuleData(linkTypeID));
        return this.getFilteredExportableItems(unlinkedItems, filters, locale);
    }

    public boolean isItemLinkedWithModelElements(ImExGenericModuleData item) {
        String linkTypeID;
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(cockpitTypeID, item.internalIdentifier);
        Collection modelElements = this.concreteDataManager.getLinkableObjects((IModuleData)realItem, linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getModelElementLinkTypeID_forShortTypeID(item.objectTypeID));
        return modelElements.size() > 0;
    }

    public Collection<IUniqueElement> getLinkedModelElements(ImExGenericModuleData item) {
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, item.objectTypeID);
        GenericModuleData realItem = (GenericModuleData)this.concreteDataManager.getItem(cockpitTypeID, item.internalIdentifier);
        String linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getModelElementLinkTypeID_forShortTypeID(item.objectTypeID);
        Collection modelElements = this.concreteDataManager.getLinkableObjects((IModuleData)realItem, linkTypeID);
        return CollectionUtils.getTypedCollection((Collection)modelElements, IUniqueElement.class);
    }

    public List<String> getKnownValuesForLinkedAttribute(String objectTypeID, String attributeID, Locale locale) {
        ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID);
        LinkedModuleDataAttribute linkedAttribute = (LinkedModuleDataAttribute)objectType.getAttribute(attributeID);
        String cockpitTypeID = ClientDataFactory_TypesHelper.getDataTypeID(this.moduleID, linkedAttribute.getObjectTypeID());
        HashSet<String> knownValuesSet = new HashSet<String>();
        for (IModuleData linkedAttributeValue : this.concreteDataManager.getAllItems(cockpitTypeID)) {
            knownValuesSet.add(linkedAttributeValue.getDisplayRepresentation(locale));
        }
        ArrayList<String> knownValuesList = new ArrayList<String>(knownValuesSet);
        Collections.sort(knownValuesList, new StringComparator());
        return knownValuesList;
    }

    public List<String> getKnownValuesForEnumerationAttribute(String objectTypeID, String attributeID, Locale locale) {
        ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID);
        EnumerationAttribute enumerationAttribute = (EnumerationAttribute)objectType.getAttribute(attributeID);
        IModuleDataAttributeDiscrete dummyModuleAttribute = AttributeHelper.createModuleDataAttributeDiscrete(enumerationAttribute, this.moduleID);
        return this.extractStringsFromDiscreteValueRange(dummyModuleAttribute.getValueRange(), locale);
    }

    public boolean isExistingObjectType(String objectTypeID) {
        return this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID) != null;
    }

    public boolean isExistingAttributeType(String objectTypeID, String attributeID) {
        ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID);
        if (objectType == null) {
            return false;
        }
        if (objectType.getAttribute(attributeID) != null) {
            return true;
        }
        return attributeID.equals("abstractmoduledata_creator") || attributeID.equals("abstractmoduledata_modifier") || attributeID.equals("abstractmoduledata_creationDate") || attributeID.equals("abstractmoduledata_modificationDate");
    }

    public boolean isExistingMDRelationType(String objectTypeID, String relationTypeID) {
        if (!this.isExistingObjectType(objectTypeID)) {
            return false;
        }
        RelationType relationType = this.moduleSpecification.getModuleDataSpecification().getRelationType(relationTypeID);
        return relationType instanceof ModuleDataRelationType && ((ModuleDataRelationType)relationType).getMDRelationParticipant(1).getObjectTypeIDOfParticipant().equals(objectTypeID);
    }

    public boolean isExistingLORelationType(String objectTypeID, String relationTypeID) {
        if (!this.isExistingObjectType(objectTypeID)) {
            return false;
        }
        RelationType relationType = this.moduleSpecification.getModuleDataSpecification().getRelationType(relationTypeID);
        return relationType instanceof ModuleDataRelationType && ((ModuleDataRelationType)relationType).getMDRelationParticipant(0).getObjectTypeIDOfParticipant().equals(objectTypeID);
    }

    public AbstractImExModuleData getExportableItem(IModuleData item, Locale locale, Collection<AbstractFilter> filters) {
        if (item instanceof GenericModuleData) {
            return this.getExportableItem((GenericModuleData)item, filters, locale);
        }
        return null;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public ModuleSpecification getModuleSpecification() {
        return this.moduleSpecification;
    }

    public IModelController getModelController() {
        return this.modelController;
    }

    private List<ImExGenericModuleData> getFilteredExportableItems(Collection<? extends IModuleData> itemCollection, Collection<AbstractFilter> filters, Locale locale) {
        ArrayList<ImExGenericModuleData> exportableItems = new ArrayList<ImExGenericModuleData>();
        Collection filteredItems = DataFacade.filter(itemCollection, filters);
        for (IModuleData filteredItem : filteredItems) {
            exportableItems.add(this.getExportableItem((GenericModuleData)filteredItem, null, locale));
        }
        return exportableItems;
    }

    private ImExGenericModuleData getExportableItem(GenericModuleData item, Collection<AbstractFilter> filters, Locale locale) {
        String value;
        IModuleDataAttribute attribute;
        if (DataFacade.filter(Arrays.asList(item), filters).isEmpty()) {
            return null;
        }
        ImExGenericModuleData exportableItem = new ImExGenericModuleData(item, this.concreteDataManager.getModelController(), item.getDisplayRepresentation(locale), item.getTypeDescription().getTypeName(locale), locale);
        exportableItem.internalIdentifier = item.getUID();
        String objectTypeID = ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID());
        ObjectType objectType = this.moduleSpecification.getModuleDataSpecification().getObjectType(ClientDataFactory_TypesHelper.getShortTypeID(item.getTypeID()));
        for (String attributeID : item.getTypeDescription().getSimpleAttributeIDs()) {
            Long timeStampInGMTPlus2;
            attribute = item.getAttribute(attributeID);
            value = attribute.getDisplayStringRepresentation(locale);
            Long valueAsInteger = null;
            if (attribute instanceof ModuleDataAttributeTimestamp && (timeStampInGMTPlus2 = ((ModuleDataAttributeTimestamp)attribute).getValue()) != null) {
                long localTimeDiffFromUTC = TimeZone.getDefault().getOffset(System.currentTimeMillis());
                valueAsInteger = timeStampInGMTPlus2 + localTimeDiffFromUTC - 0x6DDD00L;
            }
            exportableItem.addAttributeValue(attributeID, new ExValue(valueAsInteger, value, AttributeUIHelper.getExportFormatHint(this.moduleID, objectType, attributeID)));
        }
        for (String attributeID : item.getTypeDescription().getCalculatedAttributeIDs()) {
            attribute = item.getAttribute(attributeID);
            value = attribute.getDisplayStringRepresentation(locale);
            exportableItem.addAttributeValue(attributeID, new ExValue(null, value, AttributeUIHelper.getExportFormatHint(this.moduleID, objectType, attributeID)));
        }
        for (String attributeID : item.getTypeDescription().getLinkedModuleDataAttributeIDs()) {
            String linkTypeID = GMLinkTypeHelper_Shared.getDefault(this.moduleID).getAttributeLinkTypeID_forShortTypeID(objectTypeID, attributeID);
            Collection linkedAttributeCollection = this.concreteDataManager.getLinkableObjects((IModuleData)item, linkTypeID);
            int formatHint = AttributeUIHelper.getExportFormatHint(this.moduleID, objectType, attributeID);
            if (linkedAttributeCollection != null && linkedAttributeCollection.size() > 0) {
                GenericModuleData linkedAttribute = (GenericModuleData)((Object)linkedAttributeCollection.iterator().next());
                exportableItem.addAttributeValue(attributeID, new ExValue(null, linkedAttribute.getDisplayRepresentation(locale), formatHint));
                continue;
            }
            exportableItem.addAttributeValue(attributeID, new ExValue(null, "", formatHint));
        }
        for (String attributeID : item.getTypeDescription().getLinkedFrameDataAttributeIDs()) {
            int formatHint = AttributeUIHelper.getExportFormatHint(this.moduleID, objectType, attributeID);
            String label = this.modelController.getPlatformAccessAgent().getFullyQualifiedLabelOfLinkedFrameDataItem((IModuleData)item, attributeID, locale);
            if (label != null) {
                exportableItem.addAttributeValue(attributeID, new ExValue(null, label, formatHint));
                continue;
            }
            exportableItem.addAttributeValue(attributeID, new ExValue(null, "", formatHint));
        }
        for (ChildrenIDFormatAttribute attribute2 : objectType.getAttributeListOfType(ChildrenIDFormatAttribute.class)) {
            ObjectType childType = this.moduleSpecification.getModuleDataSpecification().getObjectType(attribute2.getChildObjectTypeID());
            String activePrefix = this.modelController.getIDPrefix((IModuleData)item, (IModuleDataTypeDescription)GenericModuleDataTypeDescription.getTypeDescription(this.moduleID, childType));
            exportableItem.addAttributeValue(CHILDRENIDPREFIX_ATTRIBUTEID_PREFIX + childType.getObjectTypeID(), new ExValue(null, activePrefix, 0));
        }
        return exportableItem;
    }

    private List<String> extractStringsFromDiscreteValueRange(DiscreteValue[] discreteValueRange, Locale locale) {
        ArrayList<String> typeStrings = new ArrayList<String>(discreteValueRange.length);
        DiscreteValue[] discreteValueArray = discreteValueRange;
        int n = discreteValueRange.length;
        int n2 = 0;
        while (n2 < n) {
            DiscreteValue type = discreteValueArray[n2];
            typeStrings.add(type.getName(locale));
            ++n2;
        }
        return typeStrings;
    }

    public void sortItemList(List<ImExGenericModuleData> itemList, String objectTypeID, String attributeID, final int sortingDirection) {
        String effectiveAttributeID;
        Attribute attributeToSortBy;
        if (attributeID == null) {
            attributeToSortBy = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID).getAttribute(0);
            effectiveAttributeID = attributeToSortBy.getID();
        } else {
            attributeToSortBy = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeID).getAttribute(attributeID);
            effectiveAttributeID = attributeID;
        }
        Comparator<Object> comparator = null;
        if (attributeToSortBy instanceof IDAttribute) {
            comparator = AttributeUIHelper.getComparator("datatype_mda_string_single");
        } else if (attributeToSortBy instanceof SimpleAttribute) {
            comparator = AttributeUIHelper.getComparator(((SimpleAttribute)attributeToSortBy).getAttributeDataType());
        } else if (attributeToSortBy instanceof EnumerationAttribute) {
            comparator = AttributeUIHelper.getComparator("datatype_meta_enumeration");
        } else if (attributeToSortBy instanceof LinkedModuleDataAttribute) {
            comparator = AttributeUIHelper.getComparator("datatype_meta_linkedmoduledata");
        } else if (attributeToSortBy instanceof LinkedFrameDataAttribute) {
            comparator = AttributeUIHelper.getComparator("datatype_virtual_linkedframedata");
        } else if (attributeToSortBy instanceof CalculatedAttribute) {
            comparator = AttributeUIHelper.getComparator(AttributeHelper.getDataTypeOfCalculatedAttribute(((CalculatedAttribute)attributeToSortBy).getCalculationTypeID()));
        }
        final Comparator<Object> comparator_final = comparator;
        GMLinkTypeHelper_Shared linkTypeHelper = GMLinkTypeHelper_Shared.getDefault(this.moduleID);
        final String linkTypeID = linkTypeHelper.getAttributeLinkTypeID_forShortTypeID(objectTypeID, effectiveAttributeID);
        Collections.sort(itemList, new Comparator<ImExGenericModuleData>(){

            @Override
            public int compare(ImExGenericModuleData e1, ImExGenericModuleData e2) {
                ICockpitProjectData objectToCompare2;
                ICockpitProjectData objectToCompare1;
                if (attributeToSortBy instanceof LinkedModuleDataAttribute) {
                    objectToCompare1 = this.getLinkedModuleDataAttributeObject(e1);
                    objectToCompare2 = this.getLinkedModuleDataAttributeObject(e2);
                } else if (attributeToSortBy instanceof LinkedFrameDataAttribute) {
                    objectToCompare1 = DataFacade.this.modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem(DataFacade.this.getModuleDataItemForImExItem(e1), effectiveAttributeID);
                    objectToCompare2 = DataFacade.this.modelController.getPlatformAccessAgent().getLabelOfLinkedFrameDataItem(DataFacade.this.getModuleDataItemForImExItem(e2), effectiveAttributeID);
                } else {
                    objectToCompare1 = DataFacade.this.getModuleDataItemForImExItem(e1).getAttribute(effectiveAttributeID);
                    objectToCompare2 = DataFacade.this.getModuleDataItemForImExItem(e2).getAttribute(effectiveAttributeID);
                }
                return sortingDirection * comparator_final.compare(objectToCompare1, objectToCompare2);
            }

            private ICockpitProjectData getLinkedModuleDataAttributeObject(ImExGenericModuleData e) {
                Collection los = DataFacade.this.modelController.getLinkableObjects(DataFacade.this.getModuleDataItemForImExItem(e), linkTypeID);
                if (los.size() == 1) {
                    return (ICockpitProjectData)los.iterator().next();
                }
                if (!$assertionsDisabled && !los.isEmpty()) {
                    throw new AssertionError();
                }
                return null;
            }
        });
    }

    public final int compareAccordingToNaturalOrder(ImExGenericModuleData item1, ImExGenericModuleData item2) {
        return this.compareAccordingToNaturalOrder(this.getModuleDataItemForImExItem(item1), this.getModuleDataItemForImExItem(item2));
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String string0, String string1) {
            return string0.compareToIgnoreCase(string1);
        }
    }
}

