/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.client.exceladapter.exporter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ImExGenericModuleData;
import com.arcway.cockpit.genericmodule.client.exceladapter.exporter.ExportWizardContribution;
import com.arcway.cockpit.genericmodule.client.exceladapter.exporter.Messages;
import com.arcway.cockpit.genericmodule.client.gui.AttributeUIHelper;
import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleExportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleExportAdapter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.CalculatedAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ChildrenIDFormatAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExportOrImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.excel.ExcelFileSelectionWithMultiSheetOption;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExportableData;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import com.arcway.lib.eclipse.adapter.excel.exports.GenericExcelListExporter;
import com.arcway.lib.eclipse.adapter.excel.exports.SheetDescription;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.stringtools.StringUtil;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class ExcelExporter
implements IGenericModuleExportAdapter {
    private static final ImExGenericModuleData singleSheetDummyParent = new ImExGenericModuleData(null, null){

        public String getUniqueIdentifier() {
            return "uniqueidentifier_of_singlesheetdummyparent";
        }
    };
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private ObjectType objectTypeSpecification;
    private String dataName;
    private ImageDescriptor dataIcon;
    private GenericExcelListExporter excelListExporter;
    private String fileName;
    private boolean multiSheetOptionSelected;

    public void construct(String moduleID_, Collection<String> objectTypeIDs, String dataName_, ImageDescriptor dataIcon_) {
        assert (objectTypeIDs != null && objectTypeIDs.size() == 1) : "Excel exporter can deal with one object type, only. Will ignore all but the first specified object type.";
        this.moduleID = moduleID_;
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID_);
        this.objectTypeSpecification = this.moduleSpecification.getModuleDataSpecification().getObjectType(objectTypeIDs.iterator().next());
        this.dataName = dataName_;
        this.dataIcon = dataIcon_;
        this.excelListExporter = new GenericExcelListExporter(ModuleIdentification.getFullModuleID((String)this.moduleID));
    }

    public void startExport(List<?> parameters, String configuration, PresentationContext presentationContext, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        assert (parameters != null && parameters.size() == 1 && parameters.get(0) instanceof ExcelFileSelectionWithMultiSheetOption);
        ExcelFileSelectionWithMultiSheetOption fileNameAndMultiSheetOption = (ExcelFileSelectionWithMultiSheetOption)parameters.get(0);
        assert (fileNameAndMultiSheetOption != null);
        this.fileName = fileNameAndMultiSheetOption.getExcelFileName();
        assert (this.fileName != null && this.fileName.length() > 0);
        Throwable result = this.excelListExporter.startExport(this.fileName);
        if (result != null) {
            throw new ExportOrImportFailedException(2, result.getMessage(), result.getCause());
        }
        this.multiSheetOptionSelected = fileNameAndMultiSheetOption.isMultiSheetOptionSelected();
    }

    public void export(IExportableData dataToExport, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        HashMap map_parentItem_childItemsToExport;
        assert (dataToExport instanceof GenericModuleExportableData);
        GenericModuleExportableData gmDataToExport = (GenericModuleExportableData)dataToExport;
        if (this.multiSheetOptionSelected) {
            map_parentItem_childItemsToExport = gmDataToExport.map_parentItem_childItemsToExport;
        } else {
            ArrayList itemsToExport = new ArrayList();
            for (Map.Entry entry : gmDataToExport.map_parentItem_childItemsToExport.entrySet()) {
                itemsToExport.addAll((Collection)entry.getValue());
                itemsToExport.add(null);
            }
            map_parentItem_childItemsToExport = new HashMap(1);
            map_parentItem_childItemsToExport.put(singleSheetDummyParent, itemsToExport);
        }
        ArrayList<SheetDescription> sheetDescriptions = new ArrayList<SheetDescription>(map_parentItem_childItemsToExport.size());
        List customProperties = gmDataToExport.userDefinedAttributesForChildType;
        String[] columnHeaders = this.determineColumnHeadings(gmDataToExport.map_attributeID_attributeName, customProperties);
        int[] columnFormatDefinitions = this.determineColumnFormatDefinitions(customProperties);
        if (!map_parentItem_childItemsToExport.isEmpty()) {
            for (Map.Entry entry : map_parentItem_childItemsToExport.entrySet()) {
                ObjectType parentTypeSpecification;
                ImExGenericModuleData parent = (ImExGenericModuleData)entry.getKey();
                List childItemsToExport = (List)entry.getValue();
                if (childItemsToExport.size() == 0) continue;
                String sheetName = parent == singleSheetDummyParent ? ExcelExporter.getLabelForSingleSheet() : (parent == null ? Messages.getString("ExcelExporter.LabelForRootItem") : (!(parentTypeSpecification = this.moduleSpecification.getModuleDataSpecification().getObjectType(parent.getObjectTypeID())).getLabelAttributeID().equals("none") ? parent.getAttributeValueAsString(parentTypeSpecification.getLabelAttributeID()) : new LabelProvider(parentTypeSpecification.getObjectTypeName()).getLabel(gmDataToExport.locale)));
                SheetDescription sheetDescription = new SheetDescription(sheetName, columnHeaders, columnFormatDefinitions);
                for (ImExGenericModuleData item : childItemsToExport) {
                    if (item != null) {
                        LinkedList<String> values_asList = new LinkedList<String>();
                        if (!this.objectTypeSpecification.isDisableObjectTypeCategories()) {
                            if (item.getCategoryID() != null) {
                                ObjectTypeCategory category = item.getProjectAgent().getObjectTypeCategoriesManager().getCategory(item.getCategoryID());
                                values_asList.add(category.getDisplayName());
                            } else {
                                values_asList.add("");
                            }
                        }
                        for (Attribute attribute : this.objectTypeSpecification.getAttributeList()) {
                            if (attribute instanceof CalculatedAttribute || attribute instanceof ChildrenIDFormatAttribute) continue;
                            String attributeID = attribute.getID();
                            String attributeValue = item.getAttributeValueAsString(attributeID);
                            if (item.getAttributeFormat(attributeID) == 1) {
                                attributeValue = StringUtil.removeCarriageReturns((String)attributeValue);
                                attributeValue = attributeValue.replaceAll("\\t", "    ");
                            }
                            values_asList.add(attributeValue);
                        }
                        GenericExcelListExporter.determineColumnContentsForCustomProperties((List)customProperties, values_asList, (IAttributeOwner)item.getCustomPropertiesExtension_forReading(), (Locale)gmDataToExport.locale);
                        values_asList.add(item.getCreator());
                        values_asList.add(item.getCreationDate());
                        String[] values = new String[values_asList.size()];
                        sheetDescription.addLineEntry(values_asList.toArray(values));
                        continue;
                    }
                    Object[] emptyLine = new String[columnHeaders.length];
                    Arrays.fill(emptyLine, "");
                    sheetDescription.addLineEntry((String[])emptyLine);
                }
                sheetDescriptions.add(sheetDescription);
            }
        } else {
            sheetDescriptions.add(new SheetDescription(ExcelExporter.getLabelForSingleSheet(), columnHeaders, columnFormatDefinitions));
        }
        Throwable result = this.excelListExporter.export(sheetDescriptions, monitor);
        if (result != null) {
            throw new ExportOrImportFailedException(2, result.getMessage(), result.getCause());
        }
    }

    private String[] determineColumnHeadings(Map<String, String> map_attributeID_attributeName, List<? extends IAttributeType> customProperties) {
        LinkedList<String> columnHeaders_asList = new LinkedList<String>();
        if (!this.objectTypeSpecification.isDisableObjectTypeCategories()) {
            columnHeaders_asList.add(ObjectTypeCategoryLabels.LABEL_CATEGORY);
        }
        for (Attribute attribute : this.objectTypeSpecification.getAttributeList()) {
            if (attribute instanceof CalculatedAttribute || attribute instanceof ChildrenIDFormatAttribute) continue;
            String attributeID = attribute.getID();
            String attributeName = map_attributeID_attributeName.get(attributeID);
            columnHeaders_asList.add(attributeName);
        }
        for (IAttributeType iAttributeType : customProperties) {
            columnHeaders_asList.add(iAttributeType.getDisplayName());
        }
        columnHeaders_asList.add(AbstractModuleData.CREATOR_NAME);
        columnHeaders_asList.add(AbstractModuleData.CDATE_NAME);
        String[] stringArray = new String[columnHeaders_asList.size()];
        columnHeaders_asList.toArray(stringArray);
        return stringArray;
    }

    private int[] determineColumnFormatDefinitions(List<? extends IAttributeType> customProperties) {
        int attributeCount = this.objectTypeSpecification.getAttributeList().size() - this.objectTypeSpecification.getAttributeListOfType(CalculatedAttribute.class).size() - this.objectTypeSpecification.getAttributeListOfType(ChildrenIDFormatAttribute.class).size() + customProperties.size() + 2;
        if (!this.objectTypeSpecification.isDisableObjectTypeCategories()) {
            ++attributeCount;
        }
        int[] multilineDefinitions = new int[attributeCount];
        int counter = 0;
        if (!this.objectTypeSpecification.isDisableObjectTypeCategories()) {
            multilineDefinitions[counter] = 0;
            ++counter;
        }
        for (Attribute attribute : this.objectTypeSpecification.getAttributeList()) {
            if (attribute instanceof CalculatedAttribute || attribute instanceof ChildrenIDFormatAttribute) continue;
            String attributeID = attribute.getID();
            multilineDefinitions[counter] = AttributeUIHelper.getExportFormatHint((String)this.moduleID, (ObjectType)this.objectTypeSpecification, (String)attributeID);
            ++counter;
        }
        GenericExcelListExporter.determineColumnFormatSpecificationsForCustomProperties(customProperties, (int[])multilineDefinitions, (int)counter);
        multilineDefinitions[multilineDefinitions.length - 2] = 0;
        multilineDefinitions[multilineDefinitions.length - 1] = 5;
        return multilineDefinitions;
    }

    private static String getLabelForSingleSheet() {
        return Messages.getString("ExcelExporter.LabelForSingleSheet");
    }

    public void closeExport(IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        Throwable result = this.excelListExporter.closeExport(monitor);
        if (result != null) {
            throw new ExportOrImportFailedException(2, result.getMessage(), result.getCause());
        }
    }

    public ExportOrImportResult.OpenExportConfiguration getOpenExportConfiguration() {
        return new ExportOrImportResult.OpenExportConfiguration("openExcelExportAfterCreation", Messages.getString("ExcelExport.OpenExportDialogue.Message"), new File(this.fileName));
    }

    public IExportOrImportWizardContribution getWizardContribution() {
        return new ExportWizardContribution(this.moduleSpecification, this.dataName, this.dataIcon);
    }

    public String getConfigurationKey() {
        return null;
    }
}

