/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.ReportDataProviderException;
import com.arcway.cockpit.docgen.provider.interfaces.IHistoryEntry;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataFacade;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.ImExGenericModuleData;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.Attribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.EnumerationAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.LinkedModuleDataAttribute;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModelElementLinkType;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleDataSpecification;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ObjectType;
import com.arcway.cockpit.genericmodule.docgen.Messages;
import com.arcway.cockpit.genericmodule.docgen.provider.GenericModuleDataDocGenProxy;
import com.arcway.cockpit.genericmodule.docgen.provider.interfaces.IGenericModuleReportDataProvider;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleReportDataProvider;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.ui.IWorkbenchPage;

public class ReportDataProvider
implements IModuleReportDataProvider,
IProjectRelatedReportProvider,
IGenericModuleReportDataProvider,
IExecutableExtension {
    private String moduleID;
    private ModuleDataSpecification moduleDataSpecification;
    private DataFacade dataFacade = null;
    private IProjectRelatedReportContext reportContext;
    private Locale locale;
    private IWorkbenchPage currentPage;
    private static final String REPLACEMENT_PATTERN_FOR_ESCAPED_SLASHES = "__temporary_replacement_pattern_for_slashes__must_be_long_to_be_sure_that_it_is_not_part_of_a_regular_item_name__";

    private Collection<AbstractFilter> getFilters() {
        return this.reportContext.getFilterCollection();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleDataSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID).getModuleDataSpecification();
    }

    public void setInitializationData(String moduleID) {
        this.moduleID = moduleID;
        this.moduleDataSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID).getModuleDataSpecification();
    }

    public void setup(IProjectRelatedReportContext reportContext) {
        IFMCAModule module = reportContext.getProjectAgent().getModule(ModuleIdentification.getFullModuleID((String)this.moduleID));
        this.locale = new Locale(reportContext.getProjectAgent().getLanguageID());
        this.dataFacade = (DataFacade)module.getModuleDataFacade();
        this.reportContext = reportContext;
        this.currentPage = reportContext.getCurrentPage();
    }

    public List<GenericModuleDataDocGenProxy> getAllObjects(String objectTypeID) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getAllObjects_Internal(objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_defaultSort(itemList, objectTypeID, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    public List<GenericModuleDataDocGenProxy> getAllObjectsWithCategory(String objectTypeID, String categoryID) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllObjects(objectTypeID), (String)categoryID);
    }

    public List<GenericModuleDataDocGenProxy> getAllObjectsWithDefaultCategory(String objectTypeID) {
        return this.getAllObjectsWithCategory(objectTypeID, null);
    }

    public List<GenericModuleDataDocGenProxy> getAllObjects(String objectTypeID, String attributeToSortBy) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        ReportDataProvider.checkAttributeType(objectTypeID, attributeToSortBy, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getAllObjects_Internal(objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_sortByAttribute(itemList, objectTypeID, attributeToSortBy, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    public List<GenericModuleDataDocGenProxy> getAllObjectsWithCategory(String objectTypeID, String categoryID, String attributeToSortBy) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllObjects(objectTypeID, attributeToSortBy), (String)categoryID);
    }

    public List<GenericModuleDataDocGenProxy> getAllObjectsWithDefaultCategory(String objectTypeID, String attributeToSortBy) {
        return this.getAllObjectsWithCategory(objectTypeID, null, attributeToSortBy);
    }

    private List<ImExGenericModuleData> getAllObjects_Internal(String objectTypeID) {
        return new ArrayList<ImExGenericModuleData>(this.dataFacade.getAllObjects(objectTypeID, this.getFilters(), this.locale));
    }

    public List<GenericModuleDataDocGenProxy> getAllRootObjects(String objectTypeID) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getAllRootObjects_Internal(objectTypeID);
        return GenericModuleDataDocGenProxy.transformItemList(itemList, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    public List<GenericModuleDataDocGenProxy> getAllRootObjectsWithCategory(String objectTypeID, String categoryID) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllRootObjects(objectTypeID), (String)categoryID);
    }

    public List<GenericModuleDataDocGenProxy> getAllRootObjectsWithDefaultCategory(String objectTypeID) {
        return this.getAllRootObjectsWithCategory(objectTypeID, null);
    }

    public List<GenericModuleDataDocGenProxy> getAllRootObjects(String objectTypeID, String attributeToSortBy) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        ReportDataProvider.checkAttributeType(objectTypeID, attributeToSortBy, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getAllRootObjects_Internal(objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_sortByAttribute(itemList, objectTypeID, attributeToSortBy, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    public List<GenericModuleDataDocGenProxy> getAllRootObjectsWithCategory(String objectTypeID, String categoryID, String attributeToSortBy) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllRootObjects(objectTypeID, attributeToSortBy), (String)categoryID);
    }

    public List<GenericModuleDataDocGenProxy> getAllRootObjectsWithDefaultCategory(String objectTypeID, String attributeToSortBy) {
        return this.getAllRootObjectsWithCategory(objectTypeID, null, attributeToSortBy);
    }

    private List<ImExGenericModuleData> getAllRootObjects_Internal(String objectTypeID) {
        return new ArrayList<ImExGenericModuleData>(this.dataFacade.getAllRootObjects(objectTypeID, this.getFilters(), this.locale));
    }

    public GenericModuleDataDocGenProxy findObjectByUID(String uid, String objectTypeID) {
        ImExGenericModuleData matchingItem = this.dataFacade.getObjectByUID(objectTypeID, uid, this.locale);
        if (matchingItem != null) {
            GenericModuleDataDocGenProxy docGenProxy = new GenericModuleDataDocGenProxy(matchingItem, this.dataFacade, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.getFilters(), this.locale, this.currentPage);
            return docGenProxy;
        }
        return null;
    }

    @Override
    public GenericModuleDataDocGenProxy findObject(String path, String objectTypeID) {
        String decodedPath = HTMLEncoder.decode((String)path);
        decodedPath = decodedPath.replaceAll("//", REPLACEMENT_PATTERN_FOR_ESCAPED_SLASHES);
        String[] setNames = decodedPath.trim().split("/");
        int setIndex = 0;
        while (setIndex < setNames.length) {
            setNames[setIndex] = setNames[setIndex].replaceAll(REPLACEMENT_PATTERN_FOR_ESCAPED_SLASHES, "/");
            ++setIndex;
        }
        if (setNames.length == 0) {
            return null;
        }
        List rootItemCollection = this.dataFacade.getAllRootObjects(objectTypeID, this.getFilters(), this.locale);
        ImExGenericModuleData matchingItem = ReportDataProvider.findObjectWithLabel(rootItemCollection, setNames[0], this.moduleDataSpecification);
        int i = 1;
        while (i < setNames.length) {
            if (matchingItem == null) {
                return null;
            }
            List children = this.dataFacade.getChildObjects(matchingItem, objectTypeID, this.getFilters(), this.locale);
            matchingItem = ReportDataProvider.findObjectWithLabel(children, setNames[i], this.moduleDataSpecification);
            ++i;
        }
        if (matchingItem != null) {
            GenericModuleDataDocGenProxy docGenProxy = new GenericModuleDataDocGenProxy(matchingItem, this.dataFacade, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.getFilters(), this.locale, this.currentPage);
            return docGenProxy;
        }
        return null;
    }

    private static ImExGenericModuleData findObjectWithLabel(Collection<ImExGenericModuleData> items, String label, ModuleDataSpecification moduleDataSpecification) {
        for (ImExGenericModuleData item : items) {
            String itemLabel;
            ObjectType objectType = moduleDataSpecification.getObjectType(item.getObjectTypeID());
            if (objectType.getLabelAttributeID().equals("none") || !(itemLabel = item.getAttributeValueAsString(objectType.getLabelAttributeID())).equals(label)) continue;
            return item;
        }
        return null;
    }

    public List<GenericModuleDataDocGenProxy> getItemsNotLinkedToAnyModelElement(String objectTypeID) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getItemsNotLinkedToAnyModelElement_Internal(objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_defaultSort(itemList, objectTypeID, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    public List<GenericModuleDataDocGenProxy> getItemsNotLinkedToAnyModelElement(String objectTypeID, String attributeToSortBy) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        ReportDataProvider.checkAttributeType(objectTypeID, attributeToSortBy, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getAllRootObjects_Internal(objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_sortByAttribute(itemList, objectTypeID, attributeToSortBy, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    private List<ImExGenericModuleData> getItemsNotLinkedToAnyModelElement_Internal(String objectTypeID) {
        return new ArrayList<ImExGenericModuleData>(this.dataFacade.getItemsNotLinkedToAnyModelElement(objectTypeID, this.getFilters(), this.locale));
    }

    @Override
    public boolean areAnyItemsLinkedToModelElement(String modelElementUID) {
        boolean result = false;
        List modelElementLinks = this.dataFacade.getModuleSpecification().getModuleDataSpecification().getRelationTypeListOfType(ModelElementLinkType.class);
        for (ModelElementLinkType modelElementLinkType : modelElementLinks) {
            List linkedItems = this.dataFacade.getItemsForModelElement(modelElementUID, modelElementLinkType.getLinkedObjectTypeID(), this.getFilters(), this.locale);
            if (linkedItems.size() <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean areItemsLinkedToModelElement(String modelElementUID, String objectTypeID) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        boolean result = false;
        List linkedItems = this.dataFacade.getItemsForModelElement(modelElementUID, objectTypeID, this.getFilters(), this.locale);
        result = linkedItems.size() > 0;
        return result;
    }

    public List<GenericModuleDataDocGenProxy> getItemsForModelElement(String modelElementUID, String objectTypeID) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getItemsForModelElement_Internal(modelElementUID, objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_defaultSort(itemList, objectTypeID, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    public List<GenericModuleDataDocGenProxy> getItemsForModelElement(String modelElementUID, String objectTypeID, String attributeToSortBy) {
        ReportDataProvider.checkObjectType(objectTypeID, this.dataFacade);
        ReportDataProvider.checkAttributeType(objectTypeID, attributeToSortBy, this.dataFacade);
        List<ImExGenericModuleData> itemList = this.getItemsForModelElement_Internal(modelElementUID, objectTypeID);
        return GenericModuleDataDocGenProxy.sortAndTransformItemList_sortByAttribute(itemList, objectTypeID, attributeToSortBy, this.dataFacade, this.getFilters(), this.locale, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.currentPage);
    }

    private List<ImExGenericModuleData> getItemsForModelElement_Internal(String modelElementUID, String objectTypeID) {
        return new ArrayList<ImExGenericModuleData>(this.dataFacade.getItemsForModelElement(modelElementUID, objectTypeID, this.getFilters(), this.locale));
    }

    @Override
    public List<String> getKnownValuesForAttribute(String objectTypeID, String attributeID) {
        ReportDataProvider.checkAttributeType(objectTypeID, attributeID, this.dataFacade);
        ObjectType objectType = this.dataFacade.getModuleSpecification().getModuleDataSpecification().getObjectType(objectTypeID);
        Attribute attribute = objectType.getAttribute(attributeID);
        if (attribute instanceof LinkedModuleDataAttribute) {
            return this.getKnownValuesForLinkedModuleDataAttribute(objectTypeID, attributeID);
        }
        if (attribute instanceof EnumerationAttribute) {
            return this.getKnownValuesForEnumerationAttribute(objectTypeID, attributeID);
        }
        throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.NoEnumerationAttribute1")) + " \"" + attributeID + "\" " + Messages.getString("ErrorMessage.NoEnumerationAttribute2"));
    }

    private List<String> getKnownValuesForLinkedModuleDataAttribute(String objectTypeID, String attributeID) {
        List possibleValues = this.dataFacade.getKnownValuesForLinkedAttribute(objectTypeID, attributeID, this.locale);
        return possibleValues;
    }

    private List<String> getKnownValuesForEnumerationAttribute(String objectTypeID, String attributeID) {
        List possibleValues = this.dataFacade.getKnownValuesForEnumerationAttribute(objectTypeID, attributeID, this.locale);
        return possibleValues;
    }

    static void checkObjectType(String objectTypeID, DataFacade dataFacade) {
        if (!dataFacade.isExistingObjectType(objectTypeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.ObjectTypeDoesNotExist1")) + " \"" + objectTypeID + "\" " + Messages.getString("ErrorMessage.ObjectTypeDoesNotExist2"));
        }
    }

    static void checkAttributeType(String objectTypeID, String attributeID, DataFacade dataFacade) {
        ReportDataProvider.checkObjectType(objectTypeID, dataFacade);
        if (!dataFacade.isExistingAttributeType(objectTypeID, attributeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.AttributeDoesNotExist1")) + " \"" + attributeID + "\" " + Messages.getString("ErrorMessage.AttributeDoesNotExist2"));
        }
    }

    static void checkMDRelationType(String objectTypeID, String relationTypeID, DataFacade dataFacade) {
        if (!dataFacade.isExistingMDRelationType(objectTypeID, relationTypeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.RelationTypeDoesNotExist1")) + " \"" + relationTypeID + "\" " + Messages.getString("ErrorMessage.RelationTypeDoesNotExist2"));
        }
    }

    static void checkLORelationType(String objectTypeID, String relationTypeID, DataFacade dataFacade) {
        if (!dataFacade.isExistingLORelationType(objectTypeID, relationTypeID)) {
            throw new ReportDataProviderException(String.valueOf(Messages.getString("ErrorMessage.RelationTypeDoesNotExist1")) + " \"" + relationTypeID + "\" " + Messages.getString("ErrorMessage.RelationTypeDoesNotExist2"));
        }
    }

    public boolean isResponsibleFor(AbstractImExModuleData exportableItem) {
        return exportableItem instanceof ImExGenericModuleData && this.moduleID.equals(((ImExGenericModuleData)exportableItem).getModuleID());
    }

    public IModuleDataDocGenProxy getDocGenProxy(AbstractImExModuleData exportableItem) {
        if (exportableItem instanceof ImExGenericModuleData) {
            return new GenericModuleDataDocGenProxy((ImExGenericModuleData)exportableItem, this.dataFacade, (IGraphicsAndFilesHelper)this.reportContext.getGraphicsProvider(), this.getFilters(), this.locale, this.currentPage);
        }
        return null;
    }

    public List<GenericModuleDataDocGenProxy> getAllObjectsForHistoryItem(String objectTypeID, IHistoryEntry historyEntry) {
        ArrayList<GenericModuleDataDocGenProxy> objectsForHistoryItem = new ArrayList<GenericModuleDataDocGenProxy>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<GenericModuleDataDocGenProxy> objects = this.getAllObjects(objectTypeID);
            for (GenericModuleDataDocGenProxy object : objects) {
                if (!commitVersion.equals(object.getCommitVersion())) continue;
                objectsForHistoryItem.add(object);
            }
        }
        return objectsForHistoryItem;
    }
}

