/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.genericmodule.docgen.filters;

import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.AbstractFilterItemProvider2;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataFacade;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.core.datamanagement.DataFacade;
import com.arcway.cockpit.genericmodule.client.gui.filters.GenericModuleFilters;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.genericmodule.client.messages.GMDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.FilterHelper;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.util.LabelProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;

public class FilterItemProvider
extends AbstractFilterItemProvider2
implements IExecutableExtension {
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private final List<IFilterItem> filterItems = new ArrayList<IFilterItem>();
    private static final String CONFIGITEMID_GENERICMODULE_PREFIX = "GENERICMODULE-";

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.moduleID = SpecificationProvider.getDefault().getModuleID(data);
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(this.moduleID);
        super.setup(ModuleIdentification.getFullModuleID((String)this.moduleID), new LabelProvider(this.moduleSpecification.getModuleDataName()).getLabel(Locale.getDefault()));
    }

    public void initialize(IModuleDataFacade moduleDataFacade, IFrameProjectAgent projectAgent) {
        DataFacade dataFacade = (DataFacade)moduleDataFacade;
        GenericModuleFilters filterFactory = new GenericModuleFilters(this.moduleID, this.moduleSpecification, dataFacade.getModelController());
        this.filterItems.clear();
        this.filterItems.addAll(filterFactory.createFilters(false));
        IModelController modelController = dataFacade.getModelController();
        IDataTypesHelper clientDataFactory = GMDataTypesHelper.getDefault((String)this.moduleID);
        for (String dataTypeID : clientDataFactory.getDocumentationCustomPropertyDataTypes()) {
            FilterHelper.getCustomPropertyFilters((String)dataTypeID, this.filterItems, (IModelController)modelController);
        }
    }

    public boolean isOptionalProvider() {
        return true;
    }

    public List<IFilterItem> getItems() {
        return new ArrayList<IFilterItem>(this.filterItems);
    }

    protected String getModuleDocumentationConfigurationItemID() {
        return CONFIGITEMID_GENERICMODULE_PREFIX + this.moduleID;
    }
}

