/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.handlers;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.GetProjectFromServerDialog;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsNumber;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHServerLoadProject
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHServerLoadProject.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ServerConnection serverConnection;
        String serverID;
        IStructuredSelection selection;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)activeWorkbenchWindow);
        if (shell != null && (selection = CommandHandlerHelper.getRelevantSelection((ExecutionEvent)event)) != null && !selection.isEmpty() && (serverID = ProjectSelectionAnalyser.extractServerID((ISelection)selection)) != null && (serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(serverID)) != null && serverConnection.isConnected()) {
            Object licenseValue;
            String serverAvailability = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID()).getServerAvailabilityState();
            if (serverAvailability != null) {
                String title = Messages.getString((String)"NewProjectAction.cannot_create");
                String msg = String.valueOf(Messages.getString((String)"NewProjectAction.reason")) + serverAvailability;
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                return null;
            }
            if (!ProjectMgr.getProjectMgr().connectToServer(serverConnection.getServerID())) {
                return null;
            }
            int nrOfLocalProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
            IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverID);
            IClientFunctionLicense createLicense = null;
            createLicense = sp.getFunctionLicenseManager().findClientFunctionLicense((IClientFunctionLicenseType)ClientFunctionLicenseTypeProjectsLoad.getInstance());
            int maxNr = 0;
            if (createLicense != null && (licenseValue = createLicense.getValue()) != null && ((Boolean)licenseValue).booleanValue()) {
                maxNr = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects((IClientFunctionLicenseManager)sp.getFunctionLicenseManager());
            }
            if (maxNr >= 0 && maxNr <= nrOfLocalProjects) {
                MessageDialog mDialog = new MessageDialog(shell, Messages.getString((String)"NewProjectAction.no_more_projects_allowed"), null, String.valueOf(Messages.getString((String)"NewProjectAction.not_allowed_to_create_more")) + maxNr + Messages.getString((String)"NewProjectAction.projects_on_this_client"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                mDialog.open();
                return null;
            }
            try {
                EOProject[] projects = sp.getAvailableProjectsFromServer(shell);
                String title = sp.getGetProjectFromServerLabel();
                String message = sp.getGetProjectFromServerDescription();
                if (projects != null) {
                    GetProjectFromServerDialog getFromServerDialog = new GetProjectFromServerDialog(currentPage, serverConnection, projects, title, title, message);
                    getFromServerDialog.setBlockOnOpen(true);
                    getFromServerDialog.open();
                }
            }
            catch (ServerNotAvailableException e) {
                logger.error("could not get project from server", (Throwable)e);
            }
            catch (EXServerException e) {
                logger.error("could not get project from server", (Throwable)e);
            }
            catch (LoginCanceledException e) {
            }
            catch (UnknownServerException e) {
                logger.error("could not get project from server", (Throwable)e);
            }
        }
        return null;
    }
}

