/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.handlers;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.Cursors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHProjectRefresh
extends AbstractHandler {
    private static final ILogger logger = Logger.getLogger(CHProjectRefresh.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProjectAgent projectAgent;
        String projectUID;
        IStructuredSelection sel;
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (activeWorkbenchWindow != null && (sel = CommandHandlerHelper.getRelevantSelection((ExecutionEvent)event)) != null && (projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)sel)) != null && (projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID)) != null) {
            try {
                Cursor previouslyActiveCursor = activeWorkbenchWindow.getShell().getCursor();
                activeWorkbenchWindow.getShell().setCursor(Cursors.APPSTARTING);
                try {
                    CHProjectRefresh cHProjectRefresh = this;
                    synchronized (cHProjectRefresh) {
                        try {
                            ((Object)((Object)this)).wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    projectAgent.getFrameServerProxy().refreshProject();
                }
                finally {
                    activeWorkbenchWindow.getShell().setCursor(previouslyActiveCursor);
                }
            }
            catch (ServerNotAvailableException e) {
                logger.error("could not execute", (Throwable)e);
                PSCClientServiceFacade.getFacade().showException((Exception)((Object)e), projectAgent.getServerID());
            }
            catch (EXServerException e) {
                logger.error("could not execute", (Throwable)e);
                PSCClientServiceFacade.getFacade().showException((Exception)((Object)e), projectAgent.getServerID());
            }
            catch (LoginCanceledException e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (UnknownServerException e) {
                logger.error("could not execute", (Throwable)e);
                PSCClientServiceFacade.getFacade().showException((Exception)((Object)e), projectAgent.getServerID());
            }
        }
        return null;
    }
}

