/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.handlers;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineMode;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHProjectLeaveOfflineMode
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)activeWorkbenchWindow);
        IStructuredSelection sel = CommandHandlerHelper.getRelevantSelection((ExecutionEvent)event);
        String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)sel);
        if (projectUID != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            try {
                projectAgent.getOfflineModeManager().leaveMode(currentPage);
            }
            catch (EXOfflineMode exOM) {
                int exceptionLevelForDialog;
                String dialogTitle;
                int exceptionLevel = exOM.getExceptionLevel();
                switch (exceptionLevel) {
                    case 2: {
                        dialogTitle = Messages.getString((String)"ProjectView.ErrorLeavingOffMode.Warning");
                        exceptionLevelForDialog = 3;
                        break;
                    }
                    case 3: {
                        dialogTitle = Messages.getString((String)"ProjectView.ErrorLeavingOffMode.Information");
                        exceptionLevelForDialog = 4;
                        break;
                    }
                    default: {
                        dialogTitle = Messages.getString((String)"ProjectView.ErrorLeavingOffMode.Exception");
                        exceptionLevelForDialog = 2;
                    }
                }
                String humanReadableDescriptionOfConsequence = Messages.getString((String)"ProjectView.CannotLeaveOffMode");
                ModificationProblem mProblem = new ModificationProblem((Exception)((Object)exOM), exceptionLevelForDialog, humanReadableDescriptionOfConsequence);
                ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
                mProblems.add(mProblem);
                ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, activeShell);
                mpDialog.open();
            }
        }
        return null;
    }
}

