/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.handlers;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.gui.menu.handlers.CommandHandlerHelper;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineModeNotAvailableException;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CHProjectEnterOfflineMode
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)activeWorkbenchWindow);
        IStructuredSelection sel = CommandHandlerHelper.getRelevantSelection((ExecutionEvent)event);
        String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)sel);
        if (projectUID != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            IPreferenceStore framePluginPrefStore = FramePlugin.getDefault().getPreferenceStore();
            String enterModeWithoutShowingAdvice = framePluginPrefStore.getString("enterOfflineMode.WithoutConfirmation");
            boolean enterMode = true;
            if (enterModeWithoutShowingAdvice.equals("never")) {
                String dialogMessage = NLS.bind((String)Messages.getString((String)"ProjectView.showOfflineModeAdvice.Message"), (Object)projectAgent.getProjectName());
                MessageDialogWithToggle showAdvice = new MessageDialogWithToggle(activeShell, Messages.getString((String)"ProjectView.showOfflineModeAdvice.Title"), Icons.getArcWayLogo(), dialogMessage, 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1, Messages.getString((String)"ProjectView.showOfflineModeAdvice.doNotShowMessageAgain"), false);
                showAdvice.setPrefStore(framePluginPrefStore);
                showAdvice.setPrefKey("enterOfflineMode.WithoutConfirmation");
                if (showAdvice.open() == 1) {
                    enterMode = false;
                }
            }
            if (enterMode) {
                try {
                    projectAgent.getOfflineModeManager().enterMode(currentPage);
                }
                catch (EXOfflineModeNotAvailableException exOMNA) {
                    int exceptionLevelForDialog;
                    String dialogTitle;
                    int exceptionLevel = exOMNA.getExceptionLevel();
                    switch (exceptionLevel) {
                        case 2: {
                            dialogTitle = Messages.getString((String)"ProjectView.ErrorEnteringOffMode.Warning");
                            exceptionLevelForDialog = 3;
                            break;
                        }
                        case 3: {
                            dialogTitle = Messages.getString((String)"ProjectView.ErrorEnteringOffMode.Information");
                            exceptionLevelForDialog = 4;
                            break;
                        }
                        default: {
                            dialogTitle = Messages.getString((String)"ProjectView.ErrorEnteringOffMode.Exception");
                            exceptionLevelForDialog = 2;
                        }
                    }
                    String humanReadableDescriptionOfConsequence = Messages.getString((String)"ProjectView.CannotEnterOffMode");
                    ModificationProblem mProblem = new ModificationProblem((Exception)((Object)exOMNA), exceptionLevelForDialog, humanReadableDescriptionOfConsequence);
                    ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
                    mProblems.add(mProblem);
                    ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, activeShell);
                    mpDialog.open();
                }
            }
        }
        return null;
    }
}

