/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.menu.actions;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frameserverproxy.gui.SelectProjectOnServerWidgetController;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractProjectAdminDialog
extends TitleAreaDialog
implements IStructuredContentProvider,
ILabelProvider {
    private final Collection<ServerProjectContainer> projects;
    private Image iconClosedProject;
    private Collection<ServerProjectContainer> selectedProjects;
    private SelectProjectOnServerWidgetController selectProjectWidget = null;

    public AbstractProjectAdminDialog(Shell parentShell, Collection<ServerProjectContainer> projects) {
        super(parentShell);
        this.projects = projects;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selectProjectWidget = new SelectProjectOnServerWidgetController(projects, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        this.selectProjectWidget.createDialogArea(base);
        this.selectProjectWidget.addSelectionListener(new SelectProjectOnServerWidgetController.ServerProjectContainerSelectedListener(){

            @Override
            public void serverProjectSelectionChanged(List<ServerProjectContainer> projects) {
                if (!projects.isEmpty()) {
                    AbstractProjectAdminDialog.this.selectedProjects = projects;
                    AbstractProjectAdminDialog.this.getButton(0).setEnabled(true);
                } else {
                    AbstractProjectAdminDialog.this.selectedProjects = projects;
                    AbstractProjectAdminDialog.this.getButton(0).setEnabled(false);
                }
            }
        });
        return base;
    }

    protected Control createButtonBar(Composite parent) {
        Control ctrl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return ctrl;
    }

    public Collection<ServerProjectContainer> getSelectedProjectAgents() {
        return this.selectedProjects;
    }

    public void dispose() {
        if (this.iconClosedProject != null) {
            this.iconClosedProject.dispose();
            this.iconClosedProject = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Object[] getElements(Object inputElement) {
        return this.projects.toArray();
    }

    public Image getImage(Object element) {
        return Icons.getImageForOpenProject();
    }

    public String getText(Object element) {
        ServerProjectContainer projectContainer = (ServerProjectContainer)element;
        String projectText = Project.getProjectName((EOProject)projectContainer.getProject());
        String serverName = projectContainer.getServer().getServerName();
        projectText = String.valueOf(projectText) + Messages.getString((String)"DeleteProjectDialog.__(Server___4") + serverName + ")";
        return projectText;
    }
}

