/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import de.plans.psc.client.communication.ServerConnection;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

public class ServerSelectionPage
extends WizardPage {
    private TableViewer tableViewer;
    private IServerConnectionVerifier connectionVerifier;
    private ServerConnection[] serverConnections;
    private ServerConnection selectedServerConnection = null;

    public ServerSelectionPage(String pageID) {
        super(pageID);
        this.reinit(null, new ServerConnection[0]);
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.getString((String)"ServerSelectionPage.Title"));
        this.setMessage(Messages.getString((String)"ServerSelectionPage.Message"));
        Table table = new Table(parent, 68352);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof ServerConnection) {
                    ServerConnection server = (ServerConnection)element;
                    String serverName = server.getServerName();
                    if (server.isConnected()) {
                        String username = server.getUserData().getUser().getDisplayName();
                        serverName = String.valueOf(serverName) + " ";
                        serverName = String.valueOf(serverName) + NLS.bind((String)Messages.getString((String)"ServerSelectionPage.connected_as"), (Object)username);
                    }
                    return serverName;
                }
                return "" + element;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof ServerConnection) {
                    ServerConnection server = (ServerConnection)element;
                    if (server.isConnected()) {
                        return ProjectTreeContentProvider.getImage((String)"frame.serverconnected");
                    }
                    return ProjectTreeContentProvider.getImage((String)"frame.serverdisconnected");
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection.size() == 1) {
                        ServerSelectionPage.this.updatePage((ServerConnection)structuredSelection.getFirstElement());
                    } else {
                        if (!$assertionsDisabled && !structuredSelection.isEmpty()) {
                            throw new AssertionError();
                        }
                        ServerSelectionPage.this.updatePage(null);
                    }
                } else {
                    ServerSelectionPage.this.updatePage(null);
                }
            }
        });
        this.reinit(this.connectionVerifier, this.serverConnections);
        this.setControl((Control)table);
    }

    private void updatePage(ServerConnection p_selectedServerConnection) {
        String errorMessage;
        this.selectedServerConnection = p_selectedServerConnection;
        if (this.selectedServerConnection != null && this.connectionVerifier != null) {
            errorMessage = this.connectionVerifier.isServerConnectionSuitable(this.selectedServerConnection, true);
            if (this.tableViewer != null) {
                this.tableViewer.refresh();
            }
        } else {
            errorMessage = null;
        }
        if (this.selectedServerConnection != null && errorMessage == null) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(errorMessage);
            this.setPageComplete(false);
        }
    }

    public ServerConnection getSelectedServerConnection() {
        return this.selectedServerConnection;
    }

    public void reinit(IServerConnectionVerifier p_connectionVerifier, ServerConnection[] p_serverConnections) {
        this.connectionVerifier = p_connectionVerifier;
        this.serverConnections = p_serverConnections;
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)this.serverConnections);
            this.tableViewer.refresh();
            if (this.serverConnections.length == 1) {
                this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.serverConnections[0]));
            }
        }
        if (this.serverConnections.length == 1) {
            this.updatePage(this.serverConnections[0]);
        } else {
            this.updatePage(null);
        }
    }

    public static interface IServerConnectionVerifier {
        public String isServerConnectionSuitable(ServerConnection var1, boolean var2);
    }
}

