/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.AbstractProjectSelectionDialog;
import com.arcway.cockpit.frame.shared.message.EOProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class ProjectSelectionPage
extends WizardPage {
    private Text filter;
    private FilteredList fList;
    protected final AbstractProjectSelectionDialog.EOProjectLabelProvider labelProvider = new AbstractProjectSelectionDialog.EOProjectLabelProvider();
    private EOProject[] projects = new EOProject[0];
    private EOProject selectedProject = null;

    public ProjectSelectionPage(String pageID) {
        super(pageID);
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.getString((String)"ProjectSelectionPage.Title"));
        this.setMessage(Messages.getString((String)"ProjectSelectionPage.Message"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(1, true));
        Composite childComposite = new Composite(base, 16);
        childComposite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, false);
        childComposite.setLayoutData((Object)layoutData);
        Label lblSearch = new Label(childComposite, 0);
        lblSearch.setLayoutData((Object)new GridData());
        lblSearch.setText(AbstractProjectSelectionDialog.FILTER_LABEL_TEXT);
        this.filter = new Text(childComposite, 2048);
        this.filter.setLayoutData((Object)new GridData(768));
        this.fList = new FilteredList(base, 2052, (ILabelProvider)this.labelProvider, true, true, true);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        this.fList.setLayoutData((Object)layoutData);
        this.fList.setElements((Object[])this.projects);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object[] selection = ProjectSelectionPage.this.fList.getSelection();
                if (selection.length == 1 && selection[0] instanceof EOProject) {
                    ProjectSelectionPage.this.selectedProject = (EOProject)selection[0];
                } else {
                    ProjectSelectionPage.this.selectedProject = null;
                }
                ProjectSelectionPage.this.refresh();
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = ProjectSelectionPage.this.fList.getSelection();
                if (selection.length == 1 && selection[0] instanceof EOProject) {
                    ProjectSelectionPage.this.selectedProject = (EOProject)selection[0];
                } else {
                    ProjectSelectionPage.this.selectedProject = null;
                }
                ProjectSelectionPage.this.refresh();
            }
        });
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = "*" + ProjectSelectionPage.this.filter.getText().toLowerCase();
                ProjectSelectionPage.this.fList.setFilter(filterText);
            }
        });
        this.reinit(this.projects);
        this.setControl((Control)base);
    }

    private void refresh() {
        this.setPageComplete(this.selectedProject != null);
    }

    public void reinit(EOProject[] p_projects) {
        this.projects = p_projects;
        this.selectedProject = null;
        if (this.filter != null) {
            this.fList.setElements((Object[])this.projects);
            this.filter.setText("");
            if (this.projects.length == 1) {
                this.fList.setSelection(new int[1]);
            }
        }
    }

    public EOProject getSelectedProject() {
        return this.selectedProject;
    }
}

