/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.gui.dump;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frameserverproxy.gui.SelectProjectOnServerWidgetController;
import com.arcway.cockpit.frameserverproxy.menu.actions.ServerProjectContainer;
import com.arcway.lib.io.FileSystemDefaultPaths;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DumpProjectDialog
extends TitleAreaDialog {
    private Composite detailArea;
    private Text dumpFileName;
    private Button btnSelectDumpFile;
    private File dumpFile;
    private final SelectProjectOnServerWidgetController selectProjectWidget;
    private ServerProjectContainer selectedProject = null;

    public DumpProjectDialog(Shell shell, Collection<ServerProjectContainer> projects) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.selectProjectWidget = new SelectProjectOnServerWidgetController(projects, false);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(String.valueOf(Messages.getString((String)"DumpProjectDialog.Dump_Project_1")) + " ...");
        this.setTitle(Messages.getString((String)"DumpProjectDialog.Dump_Project_1"));
        this.setMessage(Messages.getString((String)"DumpProjectDialog.Select_the_project_you_want_to_dump_and_a_file_into_which_the_data_shall_be_dumped._2"));
        this.detailArea = new Composite(parent, 2048);
        this.detailArea.setLayoutData((Object)new GridData(1808));
        GridLayout topGridLayout = new GridLayout();
        topGridLayout.numColumns = 1;
        this.detailArea.setLayout((Layout)topGridLayout);
        this.selectProjectWidget.createDialogArea(this.detailArea);
        this.selectProjectWidget.addSelectionListener(new SelectProjectOnServerWidgetController.ServerProjectContainerSelectedListener(){

            @Override
            public void serverProjectSelectionChanged(List<ServerProjectContainer> selectedProjects) {
                if (selectedProjects.isEmpty()) {
                    DumpProjectDialog.this.selectedProject = null;
                    DumpProjectDialog.this.checkValues();
                } else {
                    DumpProjectDialog.this.selectedProject = selectedProjects.get(0);
                    DumpProjectDialog.this.checkValues();
                }
            }
        });
        Composite cmpFileSelection = new Composite(this.detailArea, 0);
        cmpFileSelection.setLayoutData((Object)new GridData(768));
        topGridLayout = new GridLayout();
        topGridLayout.numColumns = 3;
        cmpFileSelection.setLayout((Layout)topGridLayout);
        Label pDumpFile = new Label(cmpFileSelection, 0);
        pDumpFile.setText(Messages.getString((String)"DumpProjectDialog.Dump_File__6"));
        this.dumpFileName = new Text(cmpFileSelection, 2052);
        this.dumpFileName.setLayoutData((Object)new GridData(768));
        this.dumpFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DumpProjectDialog.this.checkValues();
            }
        });
        this.btnSelectDumpFile = new Button(cmpFileSelection, 8);
        this.btnSelectDumpFile.setText("...");
        this.btnSelectDumpFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpProjectDialog.this.selectFile();
            }
        });
        return this.detailArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button ok = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        ok.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void selectFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.getString((String)"DumpProjectDialog.Please_select_the_dump_file._8"));
        dialog.setFilterPath(FileSystemDefaultPaths.getDefaultUserPathForSaving().getAbsolutePath());
        dialog.setFilterExtensions(new String[]{"*.zip"});
        String fileName = dialog.open();
        if (fileName != null) {
            if (fileName.toLowerCase().endsWith(".zip")) {
                this.dumpFileName.setText(fileName);
            } else {
                this.dumpFileName.setText(String.valueOf(fileName) + ".zip");
            }
        }
    }

    private boolean checkValues() {
        String error = null;
        if (this.selectedProject == null) {
            error = Messages.getString((String)"DumpProjectDialog.Please_select_a_project._12");
        } else if (this.dumpFileName.getText().length() == 0) {
            error = Messages.getString((String)"DumpProjectDialog.Please_select_a_dump_file._13");
        }
        this.setErrorMessage(error);
        return error == null;
    }

    public void setErrorMessage(String newErrorMessage) {
        Button btnOk = this.getButton(0);
        btnOk.setEnabled(newErrorMessage == null);
        super.setErrorMessage(newErrorMessage);
    }

    protected void cancelPressed() {
        this.dumpFile = null;
        this.selectedProject = null;
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.checkValues()) {
            this.dumpFile = new File(this.dumpFileName.getText());
            this.setReturnCode(0);
            super.okPressed();
        } else {
            this.selectedProject = null;
            this.dumpFile = null;
            this.setReturnCode(1);
        }
    }

    public ServerProjectContainer getSelectedProject() {
        return this.selectedProject;
    }

    public File getDumpFile() {
        return this.dumpFile;
    }
}

