/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frameserverproxy.client;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.SplittedLockSet;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ExRetryProjectOpen;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frameserverproxy.client.FrameServerProxy;
import com.arcway.cockpit.frameserverproxy.client.Messages;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOGenericMessage;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public class CommitProgressDetector {
    private static final ILogger LOGGER = Logger.getLogger(CommitProgressDetector.class);
    private static final String STALE_COMMIT_LOCKS_DETECTED_COMMIT_SUCCESS = "StaleCommitLocksSuccess";
    private static final String STALE_COMMIT_LOCKS_DETECTED_COMMIT_FAILURE = "StaleCommitLocksFailure";

    private CommitProgressDetector() {
    }

    public static EOLock generateUUniqueCommitLock(String projectUID) {
        long currentTimeMillis = System.currentTimeMillis();
        return new EOLock(UUIDGenerator.getUniqueID(), projectUID, "commit", ProjectMgr.getProjectMgr().getWorkspaceUID(), "clientworkspace." + currentTimeMillis, null, null, new Timestamp(currentTimeMillis));
    }

    public static EOList<EOFrameDataModification<EOFrameData>> createCommitSuccessMarkerModifications(String projectUID, Collection<EOLock> commitLocks) {
        EOList commitDataContributions = new EOList();
        EOList eoAdded = new EOList();
        for (EOLock commitLock : commitLocks) {
            assert (commitLock.getProjectUID().equals(projectUID));
            assert (commitLock.getLockTypeID().equals("commit"));
            EOFrameData commitSuccessMarker = new EOFrameData();
            commitSuccessMarker.setUID(commitLock.getUID());
            commitSuccessMarker.setProjectUID(projectUID);
            commitSuccessMarker.setTypeID("com.arcway.cockpit.commitmarker");
            commitSuccessMarker.setModCount(0);
            commitSuccessMarker.setCommitCount(0);
            eoAdded.add((EncodableObjectBase)commitSuccessMarker);
        }
        EOList eoModified = new EOList();
        EOList eoDeleted = new EOList();
        EOFrameDataModification mod = new EOFrameDataModification("com.arcway.cockpit.commitmarker", eoAdded, eoModified, eoDeleted);
        commitDataContributions.add((EncodableObjectBase)mod);
        return commitDataContributions;
    }

    public static boolean assessCommitSuccess(Collection<EOLock> commitLocks, EOServerResponse commitMarkerFetchResponse) {
        assert (!commitLocks.isEmpty());
        HashSet<String> commitLockUIDs = new HashSet<String>(commitLocks.size() * 2 + 10);
        for (EOLock lock : commitLocks) {
            commitLockUIDs.add(lock.getUID());
        }
        for (EOFrameData commitMarker : (EOList)commitMarkerFetchResponse.getResponseData()) {
            commitLockUIDs.remove(commitMarker.getUID());
        }
        return !commitLocks.isEmpty() && commitLockUIDs.isEmpty();
    }

    public static void checkForStaleCommitLocksAndProposeSecondAttempt(String serverID, IFrameProjectAgent projectAgent, Collection<EOLock> allLocksCurrentlyAllocatedOnServer, EXServerException openException) throws ServerNotAvailableException, LoginCanceledException, UnknownServerException, EXServerException, ExRetryProjectOpen {
        String analysisResult = null;
        if ("frame.locks".equals(openException.getGroup())) {
            try {
                SplittedLockSet allLocksCurrentlyAllocatedOnServerSplitted = new SplittedLockSet(allLocksCurrentlyAllocatedOnServer);
                if (!allLocksCurrentlyAllocatedOnServerSplitted.getCommitLocks().isEmpty()) {
                    EOClientRequest commitMarkerFetchRequest = FrameServerProxy.FrameDataRequester.getRequest(projectAgent.getProjectUID(), "com.arcway.cockpit.commitmarker");
                    EOServerResponse commitMarkerFetchResponse = PSCClientServiceFacade.getFacade().sendRequest(serverID, commitMarkerFetchRequest);
                    if (CommitProgressDetector.assessCommitSuccess(allLocksCurrentlyAllocatedOnServerSplitted.getCommitLocks(), commitMarkerFetchResponse)) {
                        analysisResult = STALE_COMMIT_LOCKS_DETECTED_COMMIT_SUCCESS;
                    } else if (commitMarkerFetchResponse != null) {
                        EOGenericMessage metadataReqContent = new EOGenericMessage();
                        metadataReqContent.addAttribute("uid", projectAgent.getProjectUID());
                        metadataReqContent.addChild((EncodableObjectBase)new EOList(allLocksCurrentlyAllocatedOnServerSplitted.getOtherLocks()));
                        EOClientRequest request = new EOClientRequest("frame.project", "frame.GetProject", (EncodableObjectBase)metadataReqContent);
                        PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
                        analysisResult = STALE_COMMIT_LOCKS_DETECTED_COMMIT_FAILURE;
                    } else {
                        assert (false);
                        LOGGER.error("cannot happen - at least i can not imagine");
                    }
                }
            }
            catch (EXServerException e1) {
                if (!e1.getGroup().equals(openException.getGroup()) || !e1.getId().equals(openException.getId())) {
                    throw new EXServerException("UnknownException", "Exception", String.valueOf(Messages.getString("CommitProgressDetector.ProblemDuringCommitProgressDetection")) + e1.getLocalizedMessage(), (Exception)((Object)e1));
                }
                throw e1;
            }
        }
        if (STALE_COMMIT_LOCKS_DETECTED_COMMIT_FAILURE.equals(analysisResult)) {
            Collection commitLocks = new SplittedLockSet(projectAgent.getLockManager().getAllLocksCurrentlyAllocatedOnServer()).getCommitLocks();
            projectAgent.getLockManager().releaseCommitLocks(commitLocks);
            LOGGER.warn("Stale commit locks detected and cleaned up. Initiating second attempt.", (Throwable)openException);
            throw new ExRetryProjectOpen(analysisResult, (Throwable)openException, ExRetryProjectOpen.CleanupActionBeforeNextOpenAttempt.CleanupAlreadyDone);
        }
        if (STALE_COMMIT_LOCKS_DETECTED_COMMIT_SUCCESS.equals(analysisResult)) {
            LOGGER.warn("Stale commit locks detected after successful commit. Initiating second open attempt with advice to delete local modifications.", (Throwable)openException);
            throw new ExRetryProjectOpen(analysisResult, (Throwable)openException, ExRetryProjectOpen.CleanupActionBeforeNextOpenAttempt.DiscardLocalModifications);
        }
    }
}

