/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.repository.cockpitadapter.locks;

import com.arcway.repository.cockpitadapter.locks.EODataLock;
import com.arcway.repository.cockpitadapter.locks.EODataLockA;
import com.arcway.repository.cockpitadapter.locks.EODataLockMS;
import com.arcway.repository.cockpitadapter.locks.EODataLockMX;
import com.arcway.repository.cockpitadapter.locks.EODataLockN;
import com.arcway.repository.cockpitadapter.locks.EODataLockS;
import com.arcway.repository.cockpitadapter.locks.EODataLockX;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class EOPlatformLock
extends EOEncodableObject {
    private static final String ATTRIBUTE_SEPERATOR = ";";
    private static final String VALUE_SEPERATOR = "=";
    public static final String XML_TAG_LOCK = "lock";
    private static final String XML_ATTRIBUTE_COMMITUID = "commitUID";
    private String commitUID;

    public static EOPlatformLock createLockFromCanonicalString(String commitUID, String canonicalString) {
        EODataLock createdLock;
        StringBuffer canonicalStringRest = new StringBuffer(canonicalString);
        String name = EOPlatformLock.getNextSubString(canonicalStringRest, ATTRIBUTE_SEPERATOR);
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (canonicalStringRest.length() > 0) {
            String key = EOPlatformLock.getNextSubString(canonicalStringRest, VALUE_SEPERATOR);
            String value = EOPlatformLock.getNextSubString(canonicalStringRest, ATTRIBUTE_SEPERATOR);
            attributes.put(key, value);
        }
        if (name.equals("lock.data.s")) {
            createdLock = new EODataLockS(commitUID, attributes);
        } else if (name.equals("lock.data.ms")) {
            createdLock = new EODataLockMS(commitUID, attributes);
        } else if (name.equals("lock.data.mx")) {
            createdLock = new EODataLockMX(commitUID, attributes);
        } else if (name.equals("lock.data.x")) {
            createdLock = new EODataLockX(commitUID, attributes);
        } else if (name.equals("lock.data.a")) {
            createdLock = new EODataLockA(commitUID, attributes);
        } else if (name.equals("lock.data.n")) {
            createdLock = new EODataLockN(commitUID, attributes);
        } else {
            throw new RuntimeException("unknown lock type: " + canonicalString);
        }
        return createdLock;
    }

    private static String getNextSubString(StringBuffer buffer, String seperator) {
        int pos = buffer.indexOf(seperator);
        if (pos == -1) {
            pos = buffer.length();
        }
        String subString = buffer.substring(0, pos);
        buffer.delete(0, pos);
        return subString;
    }

    public EOPlatformLock(String xmlName, String commitUID) {
        super(xmlName);
        this.commitUID = commitUID;
    }

    EOPlatformLock(String xmlName, XMLContext xmlContext) {
        super(xmlName, xmlContext);
    }

    EOPlatformLock(String xmlName, String commitUID, Map attributes) {
        super(xmlName);
        this.commitUID = commitUID;
        for (Map.Entry entry : attributes.entrySet()) {
            String value;
            String key = (String)entry.getKey();
            if (this.setAttributeFromXML(key, value = (String)entry.getValue())) continue;
            throw new IllegalArgumentException();
        }
        assert (this.getCanonicalString().length() <= 512) : "table column length is 512";
    }

    public String getCommitUID() {
        return this.commitUID;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success;
        if (name.equals(XML_ATTRIBUTE_COMMITUID)) {
            this.commitUID = value;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    protected final void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        for (KeyValue keyValue : this.getAttributes()) {
            super.appendAttrToXML(writeContext, keyValue.getKey(), keyValue.getValue());
        }
    }

    private List getAttributes() {
        ArrayList attributes = new ArrayList();
        this.appendAttributesToList(attributes);
        return attributes;
    }

    public String getCanonicalString() {
        StringBuffer canonicalString = new StringBuffer();
        canonicalString.append(this.getTag());
        for (KeyValue keyValue : this.getAttributes()) {
            if (keyValue.getKey().equals(XML_ATTRIBUTE_COMMITUID)) continue;
            canonicalString.append(ATTRIBUTE_SEPERATOR);
            canonicalString.append(keyValue.getKey());
            canonicalString.append(VALUE_SEPERATOR);
            canonicalString.append(keyValue.getValue());
        }
        return canonicalString.toString();
    }

    protected void appendAttributesToList(List attributes) {
        if (this.commitUID != null) {
            attributes.add(new KeyValue(XML_ATTRIBUTE_COMMITUID, this.commitUID));
        }
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public int hashCode() {
        return this.getCanonicalString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EOPlatformLock)) {
            return false;
        }
        EOPlatformLock other = (EOPlatformLock)((Object)obj);
        return this.getCanonicalString().equals(other.getCanonicalString());
    }

    protected static class KeyValue {
        private final String key;
        private final String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

