/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.shared.message;

import com.arcway.cockpit.frame.shared.message.EOCurrentCommitVersions;
import com.arcway.cockpit.frame.shared.message.EOLock;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOForeignLocksRequest
extends EOEncodableObject {
    private EOList<EOLock> clientLocksNeededByServer;
    private String projectUID;
    private EOCurrentCommitVersions currentCommitVersions;
    public static final String XML_TAG = "foreignlocksrequest";
    private static final String XML_ATTRIBUTE_PROJECTUID = "projectuid";
    public static final String LOCK_LIST_ROLE_CLIENT_LOCKS_NEEDED_BY_SERVER = "clientLocksNeededByServer";

    public EOForeignLocksRequest(EOList<EOLock> clientLocksNeededByServer, String projectUID, EOCurrentCommitVersions currentCommitVersions) {
        super(XML_TAG);
        this.clientLocksNeededByServer = clientLocksNeededByServer;
        this.projectUID = projectUID;
        this.currentCommitVersions = currentCommitVersions;
    }

    public EOForeignLocksRequest(XMLContext xmlContext) {
        super(XML_TAG, xmlContext);
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        super.appendAttrToXML(writeContext, XML_ATTRIBUTE_PROJECTUID, this.projectUID);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success;
        if (name.equals(XML_ATTRIBUTE_PROJECTUID)) {
            this.projectUID = value;
            success = true;
        } else {
            success = false;
        }
        return success;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.clientLocksNeededByServer.writeXMLBody(writeContext, depth);
        if (this.currentCommitVersions != null) {
            this.currentCommitVersions.writeXMLBody(writeContext, depth);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success;
        if (newChild instanceof EOCurrentCommitVersions) {
            this.currentCommitVersions = (EOCurrentCommitVersions)newChild;
            success = true;
        } else if (newChild instanceof EOList) {
            EOList currentList = (EOList)newChild;
            String role = currentList.getRole();
            if (role.equals(LOCK_LIST_ROLE_CLIENT_LOCKS_NEEDED_BY_SERVER)) {
                this.clientLocksNeededByServer = currentList;
                success = true;
            } else {
                success = false;
            }
        } else {
            success = false;
        }
        return success;
    }

    public EOList<EOLock> getClientLocksNeededByServer() {
        return this.clientLocksNeededByServer;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public EOCurrentCommitVersions getCurrentCommitVersions() {
        return this.currentCommitVersions;
    }
}

