/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.messages;

import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.documentmodule.client.messages.description.DocumentContainerDescription;
import com.arcway.cockpit.documentmodule.client.messages.description.RLFileSystemLinkDescription;
import com.arcway.cockpit.documentmodule.client.messages.description.RLWebLinkDescription;
import com.arcway.cockpit.modulelib2.client.core.AbstractClientDataFactory;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.shared.messages.EOModuleData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClientDataFactory
extends AbstractClientDataFactory {
    public static final List trueDataTypeIDs_AsList;
    private static final Set trueDataTypeIDs_AsSet;
    private static final Set allDataTypeIDs_AsSet;

    static {
        List<String> truedataTypeIDs = Arrays.asList("dcm.documentcontainer", "dcm.filesystemlink", "dcm.weblink", "dcm.category");
        trueDataTypeIDs_AsList = Collections.unmodifiableList(truedataTypeIDs);
        trueDataTypeIDs_AsSet = Collections.unmodifiableSet(new HashSet<String>(truedataTypeIDs));
        ArrayList<String> allDataTypeIDs = new ArrayList<String>(truedataTypeIDs);
        allDataTypeIDs.add("dcm.ResourceLocator");
        allDataTypeIDs_AsSet = Collections.unmodifiableSet(new HashSet<String>(allDataTypeIDs));
    }

    public IModuleData convertFromEO(EOModuleData item) {
        if (item.getTypeID().equals("dcm.documentcontainer")) {
            return new DocumentContainer(item);
        }
        if (item.getTypeID().equals("dcm.filesystemlink")) {
            return new RLFileSystemLink(item);
        }
        if (item.getTypeID().equals("dcm.weblink")) {
            return new RLWebLink(item);
        }
        if (item.getTypeID().equals("dcm.category")) {
            return new Category(item);
        }
        return null;
    }

    public Set getTrueModuleDataTypes() {
        return trueDataTypeIDs_AsSet;
    }

    public Set getAllModuleDataTypes() {
        return allDataTypeIDs_AsSet;
    }

    public Class getClassForDataTypeID(String dataTypeId) {
        if (dataTypeId.equals("dcm.documentcontainer")) {
            return DocumentContainer.class;
        }
        if (dataTypeId.equals("dcm.filesystemlink")) {
            return RLFileSystemLink.class;
        }
        if (dataTypeId.equals("dcm.weblink")) {
            return RLWebLink.class;
        }
        if (dataTypeId.equals("dcm.category")) {
            return Category.class;
        }
        if (dataTypeId.equals("dcm.ResourceLocator")) {
            return ResourceLocator.class;
        }
        return null;
    }

    public Collection getAllModuleDataTypes_asDescriptionForFrame() {
        return Arrays.asList(CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, DocumentContainerDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, RLFileSystemLinkDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, RLWebLinkDescription.MODULEDATATYPEDESCRIPTION_FORFRAME);
    }
}

