/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.linkviewcontribution;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.gui.linkviewcontribution.DocumentLinks;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.IDocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.RLFileSystemLink;
import com.arcway.cockpit.documentmodule.client.messages.RLWebLink;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IModuleLinkLabelProvider;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.StringCondenser;
import java.util.Collection;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class LinkLabelProvider
implements IModuleLinkLabelProvider {
    private static final int DISPLAY_LENGHT = 60;
    ImageDescriptorRegistry imageDescriptorRegistry = DocumentModulePlugin.getDefault().getImageDescriptorRegistry();

    public Image getImage(Object element) {
        Image image = null;
        ImageDescriptor desc = null;
        if (element instanceof IDocumentContainer) {
            DocumentContainer container = ((IDocumentContainer)element).getDocumentContainer();
            String projectUid = container.getProjectUID();
            IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUid);
            Collection children = modelController.getChildren((IModuleData)container);
            if (children.size() == 1) {
                ResourceLocator resource = (ResourceLocator)((Object)children.iterator().next());
                if (resource instanceof RLFileSystemLink) {
                    RLFileSystemLink fileLink = (RLFileSystemLink)resource;
                    desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileLink.getPreMappedURL().getValue());
                } else if (resource instanceof RLWebLink) {
                    desc = DocumentModulePlugin.getImageDescriptor("weblink.gif");
                }
            } else {
                desc = DocumentModulePlugin.getImageDescriptor("container.gif");
            }
        } else if (element instanceof ResourceLocator) {
            ResourceLocator resource = (ResourceLocator)((Object)element);
            if (resource instanceof RLFileSystemLink) {
                RLFileSystemLink fileLink = (RLFileSystemLink)((Object)element);
                desc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileLink.getPreMappedURL().getValue());
            } else if (element instanceof RLWebLink) {
                desc = DocumentModulePlugin.getImageDescriptor("weblink.gif");
            }
        } else if (element instanceof EOLink) {
            EOLink link = (EOLink)element;
            if (link.getLinkTypeID().equals("FilelinkDocumentContainer") || link.getLinkTypeID().equals("WeblinkDocumentContainer")) {
                desc = DocumentModulePlugin.getImageDescriptor("container.gif");
            }
        } else if (element instanceof DocumentLinks) {
            desc = DocumentModulePlugin.getImageDescriptor("documents.gif");
        }
        if (desc != null) {
            image = this.imageDescriptorRegistry.get(desc);
        }
        return image;
    }

    public String getText(Object element) {
        return this.getText(element, false);
    }

    public String getText(Object element, boolean limited) {
        String text;
        if (element instanceof EOLink) {
            if ("DocumentContainerUE".equals(((EOLink)element).getLinkTypeID())) {
                String containerUid = ((EOLink)element).getModuleDataUID();
                String projectUid = ((EOLink)element).getProjectUID();
                IModelController modelController = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUid);
                DocumentContainer container = (DocumentContainer)modelController.getItem("dcm.documentcontainer", containerUid);
                String displayString = container.getName().getDisplayStringRepresentation();
                if (displayString != null) {
                    displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
                    if (limited) {
                        displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
                    }
                    text = displayString;
                } else {
                    text = "-";
                }
            } else {
                text = null;
            }
        } else if (element instanceof IDocumentContainer) {
            String displayString = ((IDocumentContainer)element).getDocumentContainer().getName().getDisplayStringRepresentation();
            displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
            if (limited) {
                displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
            }
            text = displayString;
        } else if (element instanceof RLFileSystemLink) {
            IPreferenceStore store = DocumentModulePlugin.getDefault().getPreferenceStore();
            String prefShowURL = store.getString("dcm.prefs.PrefShowUrlForFilelink");
            String displayString = "-";
            displayString = prefShowURL.equals("dcm.prefs.values.CShortenedUrl") ? ((RLFileSystemLink)((Object)element)).getShortenedURL() : ((RLFileSystemLink)((Object)element)).getLocalURL();
            displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
            if (limited) {
                displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
            }
            text = displayString;
        } else if (element instanceof RLWebLink) {
            IPreferenceStore store = DocumentModulePlugin.getDefault().getPreferenceStore();
            String prefShowURL = store.getString("dcm.prefs.PrefShowUrlForWeblink");
            String displayString = "-";
            displayString = prefShowURL.equals("dcm.prefs.values.CShortenedUrl") ? ((RLWebLink)((Object)element)).getShortenedURL() : ((RLWebLink)((Object)element)).getURL().getDisplayStringRepresentation();
            displayString = StringUtil.removeNewlinesAndTrim((String)displayString);
            if (limited) {
                displayString = StringCondenser.cutOffEnd((String)displayString, (int)60);
            }
            text = displayString;
        } else {
            text = element instanceof DocumentLinks ? Messages.getString("LinkViewContribution.RootLabel") : null;
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

