/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.dialogs;

import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.description.DocumentContainerDescription;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.ModuleDataReference;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextDropDown;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EditDocumentContainerAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private DocumentContainer container = null;
    private Category currentCategory = null;
    private ModuleDataReference containerCategory = new ModuleDataReference();
    private IModelController model = null;
    private UIETextField name;
    private UIETextField keywords;
    private UIETextDropDown state;
    private LockAccess lock;

    public EditDocumentContainerAdapter(Category parent) {
        super(true);
        this.currentCategory = parent;
    }

    public EditDocumentContainerAdapter() {
        super(false);
    }

    public String getDataTypeID() {
        return "dcm.documentcontainer";
    }

    public Class getDataClass() {
        return DocumentContainer.class;
    }

    public String getPropertyName() {
        return DocumentContainer.MODULE_DATA_NAME;
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("container.gif");
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DocumentModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public Composite createEditPage_internal(Composite parent) {
        Composite editArea = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        editArea.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        editArea.setLayout((Layout)layout);
        this.createCategoryWidget(editArea, 4, (IModuleData)this.container);
        Label label = new Label(editArea, 0);
        label.setText(String.valueOf(DocumentContainer.NAME_NAME) + ":");
        Control widget = this.name.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 1;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(Messages.getString("EditDocumentContainerDialog.KEYW_LABEL_Part1")) + ":" + "\n" + Messages.getString("EditDocumentContainerDialog.KEYW_LABEL_Part2"));
        widget = this.keywords.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 1;
        widget.setLayoutData((Object)gridData);
        label = new Label(editArea, 0);
        label.setText(String.valueOf(DocumentContainer.STATE_NAME) + ":");
        widget = this.state.getControl(editArea);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 1;
        widget.setLayoutData((Object)gridData);
        this.setWidgetState();
        this.setValues();
        this.name.addModifyListener((ModifyListener)this);
        this.keywords.addModifyListener((ModifyListener)this);
        this.state.addModifyListener((ModifyListener)this);
        this.handleModifications(null, false);
        return editArea;
    }

    private void setWidgetState() {
        AbstractPermissionMgr permissionMgr = this.model.getPermissionMgr();
        boolean mayEdit = true;
        if (!this.isCreationDialogue()) {
            mayEdit &= permissionMgr.mayEditItemStructurally((IModuleData)this.container, (IModuleData)this.currentCategory);
        }
        if (mayEdit && !this.isCreationDialogue() && !this.lock.hasLock()) {
            mayEdit = false;
        }
        if (mayEdit) {
            this.name.setEditable(true);
        } else {
            this.name.setEditable(false);
        }
        if (mayEdit) {
            this.keywords.setEditable(true);
        } else {
            this.keywords.setEditable(false);
        }
        if (mayEdit) {
            this.state.setEnabled(true);
        } else {
            this.state.setEnabled(false);
        }
        if (mayEdit) {
            this.setCategoryEditable(true);
        } else {
            this.setCategoryEditable(false);
        }
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            this.container = (DocumentContainer)items[0];
            this.model = DocumentModulePlugin.getDefault().getProjectManager().getModelController(this.container.getProjectUID());
            if (!this.isCreationDialogue()) {
                this.currentCategory = (Category)((Object)this.model.getLinkableObjects((IModuleData)this.container, "ContainerCategory").iterator().next());
            }
            this.containerCategory = new ModuleDataReference((AbstractModuleData)this.currentCategory);
            this.internalConstruct(this.model);
            if (!this.isCreationDialogue()) {
                ModuleLockManager lockMgr = (ModuleLockManager)this.model.getLockMgr();
                this.lock = lockMgr.acquireEditLock((ICockpitProjectData)this.container);
                if (!this.lock.hasLock()) {
                    this.lock.releaseLocks();
                } else {
                    this.container = (DocumentContainer)this.model.getItem("dcm.documentcontainer", this.container.getUID());
                    if (this.container == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    private void internalConstruct(IModelController modelCtrl) {
        this.name = new UIETextField(Messages.getString("DocumentContainer.NAME_NAME"), this.container.getName().getValueRangeHelper());
        this.keywords = new UIETextField(Messages.getString("DocumentContainer.KEYW_NAME"), this.container.getKeywords().getValueRangeHelper());
        this.state = new UIETextDropDown(Messages.getString("DocumentContainer.STATE_NAME"), this.container.getState().getValueRangeHelper(Locale.getDefault()));
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return DocumentContainerDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private void setValues() {
        this.name.setValue();
        this.keywords.setValue();
        this.state.setValue();
    }

    private void getValues() {
        this.name.getValue();
        this.keywords.getValue();
        this.state.getValue();
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(e, true);
    }

    private void handleModifications(ModifyEvent e, boolean notAtInitialisation) {
        String checkResult = null;
        checkResult = this.name.checkCurrentValue();
        if (checkResult == null) {
            checkResult = this.keywords.checkCurrentValue();
        }
        if (checkResult == null) {
            checkResult = this.state.checkCurrentValue();
        }
        if (notAtInitialisation) {
            this.getCallback().setErrMsg(checkResult);
            this.getCallback().setChangedStatus(true);
        } else {
            if (checkResult != null) {
                this.getCallback().setCommitable(false);
            }
            this.getCallback().setChangedStatus(false);
        }
    }

    public DocumentContainer getDocumentContainer() {
        return this.container;
    }

    public ModuleDataReference getContainerCategory() {
        return this.containerCategory;
    }

    public void cancelChanges1() {
        if (!this.isCreationDialogue() && this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.EMPTY_LIST;
    }

    public void rollbackCommitRequest() {
    }

    protected void doCommitChanges() {
        this.getValues();
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.container);
            Category newCategory = (Category)this.containerCategory.getItem();
            if (newCategory != null) {
                IStatus iStatus = this.model.createLink(newCategory.getUID(), (IModuleData)this.container, "ContainerCategory");
            }
        } else {
            Category newCategory = (Category)this.containerCategory.getItem();
            if (!(this.currentCategory == null || newCategory != null && this.currentCategory.getUID().equals(newCategory.getUID()))) {
                this.model.deleteLink(this.currentCategory.getUID(), this.container.getUID(), "ContainerCategory");
            }
            if (!(newCategory == null || this.currentCategory != null && this.currentCategory.getUID().equals(newCategory.getUID()))) {
                this.model.createLink(newCategory.getUID(), (IModuleData)this.container, "ContainerCategory");
            }
            this.model.itemPropertiesModified((IModuleData)this.container, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return DocumentModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return DocumentModulePlugin.getImageDescriptor("container_big.gif");
    }
}

