/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.documentmodule.client.DocumentModulePlugin;
import com.arcway.cockpit.documentmodule.client.Messages;
import com.arcway.cockpit.documentmodule.client.core.licensetypes.ClientFunctionLicenseTypeDCMModifyItems;
import com.arcway.cockpit.documentmodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.documentmodule.client.gui.DataView;
import com.arcway.cockpit.documentmodule.client.gui.actions.DCMModuleActionDelegate;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.EditDocumentContainerAdapter;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.SelectCategoryDialogContentProvider;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.SelectCategoryDialogLabelProvider;
import com.arcway.cockpit.documentmodule.client.gui.dialogs.SelectionStatusValidator;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.shared.ModuleIdentification;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ActionDelegateNewContainerViaUniqueElement
extends DCMModuleActionDelegate {
    public static final int STATUS_OK = 0;
    public static final int STATUS_NO_SELECTION = 1;
    public static final int STATUS_UNKNOWN = 2;
    public static final int STATUS_LOCKED = 3;
    public static final int STATUS_NO_PERMISSION = 4;
    public static final int[] SEVERITIES;
    public static final String[] STATUS_MESSAGES;
    private IModelController modelCtrl;
    private ArrayList<IUniqueElement> selectedUniqueElements;
    private boolean enabled;
    public static String moduleID;

    static {
        int[] nArray = new int[5];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        SEVERITIES = nArray;
        STATUS_MESSAGES = new String[]{"", Messages.getString("ActionDelegateNewContainerViaUniqueElement.ErrMsgNoSelection"), "", Messages.getString("ActionDelegateNewContainerViaUniqueElement.ErrMsgNoLock"), Messages.getString("ActionDelegateNewContainerViaUniqueElement.ErrMsgNoPermission")};
        moduleID = ModuleIdentification.getModuleID();
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        this.selectedUniqueElements = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (!(element instanceof IUniqueElement)) continue;
                this.selectedUniqueElements.add((IUniqueElement)element);
            }
            if (!this.selectedUniqueElements.isEmpty()) {
                String projectUID = this.selectedUniqueElements.get(0).getProjectUID();
                this.modelCtrl = DocumentModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
                this.enabled = true;
            } else {
                this.enabled = false;
            }
        } else {
            this.enabled = false;
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        ActionDelegateNewContainerViaUniqueElement.createContainer(this.modelCtrl, this.selectedUniqueElements, this.getIssuingShell(), this.getIssuingPart());
    }

    public static DocumentContainer createContainer(IModelController modelController, Collection<IUniqueElement> uniqueElements, Shell issuingShell, IWorkbenchPart issuingPart) {
        return ActionDelegateNewContainerViaUniqueElement.createContainer(modelController, uniqueElements, "", issuingShell, issuingPart);
    }

    public static DocumentContainer createContainer(final IModelController modelController, final Collection<IUniqueElement> uniqueElements, String nameSuggestion, Shell issuingShell, IWorkbenchPart issuingPart) {
        SelectCategoryDialogContentProvider contentProvider = new SelectCategoryDialogContentProvider(issuingPart.getSite().getPage(), false);
        SelectCategoryDialogLabelProvider labelProvider = new SelectCategoryDialogLabelProvider();
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(issuingShell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setDoubleClickSelects(true);
        selectionDialog.setMessage(Messages.getString("ActionDelegateNewContainerViaUniqueElement.DialogMessage"));
        selectionDialog.setTitle(Messages.getString("ActionDelegateNewContainerViaUniqueElement.DialogTitle"));
        selectionDialog.setEmptyListMessage(Messages.getString("ActionDelegateNewContainerViaUniqueElement.NoDocumentSetsAvailable"));
        List input = new ArrayList(modelController.getAllRootItems());
        IViewPart dataView = issuingPart.getSite().getPage().findView("com.arcway.cockpit.documentmodule.client.gui.dataview");
        if (dataView != null) {
            input = ((DataView)dataView).applySorters(input);
        }
        selectionDialog.setInput(input);
        ModuleLockManager lockManager = (ModuleLockManager)modelController.getLockMgr();
        PermissionMgr permissionMgr = (PermissionMgr)modelController.getPermissionMgr();
        SelectionStatusValidator validator = new SelectionStatusValidator(lockManager, permissionMgr);
        selectionDialog.setValidator((ISelectionStatusValidator)validator);
        if (selectionDialog.open() == 0) {
            Category newParent = (Category)((Object)selectionDialog.getFirstResult());
            EditDocumentContainerAdapter dialogProvider = new EditDocumentContainerAdapter(newParent);
            ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "dcm.documentcontainer", modelController, Messages.getString("ActionDelegateNewContainerViaUniqueElement.WizardText"));
            DocumentContainer newItem = new DocumentContainer();
            newItem.getName().setValueViaDisplayStringRepresentation(nameSuggestion);
            newItem.setProjectUID(modelController.getProjectUID());
            boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{newParent});
            if (!creationPossible) {
                ActionDelegateNewContainerViaUniqueElement.releaseInsertLock(validator);
                return null;
            }
            WizardDialog dialog = new WizardDialog(issuingShell, (IWizard)wizard);
            if (dialog.open() == 0) {
                final DocumentContainer documentContainer = dialogProvider.getDocumentContainer();
                if (uniqueElements != null) {
                    modelController.executeTransaction(new Runnable(){

                        @Override
                        public void run() {
                            for (IUniqueElement ue : uniqueElements) {
                                modelController.createLink(ue.getUID(), (IModuleData)documentContainer, "DocumentContainerUE");
                            }
                        }
                    });
                }
                return documentContainer;
            }
        } else {
            ActionDelegateNewContainerViaUniqueElement.releaseInsertLock(validator);
        }
        return null;
    }

    private static void releaseInsertLock(SelectionStatusValidator validator) {
        LockAccess insertLock = validator.getLock();
        if (insertLock != null) {
            insertLock.releaseLocks();
        }
    }

    protected <T> boolean determineEnabledStatus(IPropertyChanges<T> changes, Class<T> clazz) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeDCMModifyItems.getInstance();
    }
}

