/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.documentmodule.client.core.project.datafacade;

import com.arcway.cockpit.documentmodule.client.core.project.DataMgr;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExDocumentContainer;
import com.arcway.cockpit.documentmodule.client.core.project.datafacade.ImExResourceLocator;
import com.arcway.cockpit.documentmodule.client.messages.Category;
import com.arcway.cockpit.documentmodule.client.messages.DocumentContainer;
import com.arcway.cockpit.documentmodule.client.messages.ResourceLocator;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class DataFacade
extends AbstractDataFacade {
    private DataMgr dataMgr;

    public void construct(IModel dataManager_, IModelController modelController_, IClientDataFactory clientDataFactory) {
        super.construct(dataManager_, modelController_, clientDataFactory);
        this.dataMgr = (DataMgr)dataManager_;
    }

    public List<ImExResourceLocator> getResourceLocators(DocumentContainer container, Locale locale) {
        ArrayList resourceLocators = new ArrayList(this.modelController.getModuleData((IModuleData)container, "FilelinkDocumentContainer"));
        resourceLocators.addAll(this.modelController.getModuleData((IModuleData)container, "WeblinkDocumentContainer"));
        this.sortByNaturalOrder(resourceLocators);
        ArrayList<ImExResourceLocator> locatorList = new ArrayList<ImExResourceLocator>();
        for (ResourceLocator rl : resourceLocators) {
            ImExResourceLocator imEx = new ImExResourceLocator(rl, this.dataMgr.getModelController(), locale);
            locatorList.add(imEx);
        }
        return locatorList;
    }

    public List<ImExDocumentContainer> getDocumentContainers(ImExCategory category, Locale locale) {
        ArrayList<ImExDocumentContainer> imExContainers = new ArrayList<ImExDocumentContainer>();
        ArrayList containers = new ArrayList(this.modelController.getChildren(this.getModuleDataItemForImExItem(category)));
        this.sortByNaturalOrder(containers);
        for (DocumentContainer documentContainer : containers) {
            imExContainers.add(new ImExDocumentContainer(documentContainer, this, this.dataMgr.getModelController(), locale));
        }
        return imExContainers;
    }

    public ImExCategory getCategory(DocumentContainer container, Locale locale) {
        Collection categories = this.modelController.getLinkableObjects((IModuleData)container, "ContainerCategory");
        if (categories.size() > 0) {
            assert (categories.size() == 1);
            Category cat = (Category)((Object)categories.iterator().next());
            return new ImExCategory(cat, this, this.dataMgr.getModelController(), locale);
        }
        return null;
    }

    public List<ImExCategory> getAllCategories(Locale locale) {
        ArrayList<ImExCategory> imExCategories = new ArrayList<ImExCategory>();
        ArrayList categories = new ArrayList(this.modelController.getAllRootItems());
        this.sortByNaturalOrder(categories);
        for (Category category : categories) {
            imExCategories.add(new ImExCategory(category, this, this.dataMgr.getModelController(), locale));
        }
        return imExCategories;
    }

    public Collection<ImExDocumentContainer> getDocumentContainersLinkedWithUE(String uniqueElementUID, Locale locale) {
        Collection containers = this.modelController.getModuleData(uniqueElementUID, "DocumentContainerUE");
        ArrayList<ImExDocumentContainer> imExContainers = new ArrayList<ImExDocumentContainer>();
        for (DocumentContainer documentContainer : containers) {
            ImExDocumentContainer imExContainer = new ImExDocumentContainer(documentContainer, this, this.dataMgr.getModelController(), locale);
            imExContainers.add(imExContainer);
        }
        return imExContainers;
    }

    public AbstractImExModuleData getExportableItem(IModuleData item, Locale locale, Collection filters) {
        if (item instanceof Category) {
            return new ImExCategory((Category)item, this, this.dataMgr.getModelController(), locale);
        }
        if (item instanceof DocumentContainer) {
            return new ImExDocumentContainer((DocumentContainer)item, this, this.dataMgr.getModelController(), locale);
        }
        if (item instanceof ResourceLocator) {
            return new ImExResourceLocator((ResourceLocator)item, this.dataMgr.getModelController(), locale);
        }
        return null;
    }
}

